/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.core.IRepositoryProviderListener;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.RepositoryProviderManager;
import org.eclipse.team.internal.core.TeamPlugin;

public class WorkspaceSubscriber
extends Subscriber
implements ISubscriberChangeListener,
IRepositoryProviderListener,
IResourceChangeListener {
    private static WorkspaceSubscriber instance;
    private Map projects = new HashMap();

    public static synchronized WorkspaceSubscriber getInstance() {
        if (instance == null) {
            instance = new WorkspaceSubscriber();
        }
        return instance;
    }

    public WorkspaceSubscriber() {
        RepositoryProviderManager.getInstance().addListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            this.handleProject(project);
            ++i;
        }
    }

    private void handleProject(IProject project) {
        if (RepositoryProvider.isShared(project)) {
            try {
                Subscriber subscriber;
                RepositoryProviderType type;
                String currentId = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                if (currentId != null && (type = RepositoryProviderType.getProviderType(currentId)) != null && (subscriber = type.getSubscriber()) != null) {
                    subscriber.addListener(this);
                    this.projects.put(project, subscriber);
                }
            }
            catch (CoreException e) {
                TeamPlugin.log(e);
            }
        }
    }

    public String getName() {
        return Messages.WorkspaceSubscriber_0;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        Subscriber subscriber = this.getSubscriber(resource);
        if (subscriber != null) {
            return subscriber.isSupervised(resource);
        }
        return false;
    }

    public IResource[] members(IResource resource) throws TeamException {
        Subscriber subscriber = this.getSubscriber(resource);
        if (subscriber != null) {
            return subscriber.members(resource);
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                return container.members();
            }
            catch (CoreException e) {
                throw TeamException.asTeamException(e);
            }
        }
        return new IResource[0];
    }

    public IResource[] roots() {
        return this.projects.keySet().toArray(new IProject[this.projects.size()]);
    }

    public IDiff getDiff(IResource resource) throws CoreException {
        Subscriber subscriber = this.getSubscriber(resource);
        if (subscriber != null) {
            return subscriber.getDiff(resource);
        }
        return super.getDiff(resource);
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        Subscriber subscriber = this.getSubscriber(resource);
        if (subscriber != null) {
            return subscriber.getSyncInfo(resource);
        }
        return null;
    }

    public IResourceVariantComparator getResourceComparator() {
        return new IResourceVariantComparator(){

            public boolean isThreeWay() {
                return true;
            }

            public boolean compare(IResourceVariant base, IResourceVariant remote) {
                return false;
            }

            public boolean compare(IResource local, IResourceVariant remote) {
                return false;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(ResourceTraversal[] traversals, IProgressMonitor monitor) throws TeamException {
        try {
            ArrayList<TeamException> errors = new ArrayList<TeamException>();
            Subscriber[] subscribers = this.getSubscribers();
            monitor.beginTask(null, subscribers.length * 100);
            int i = 0;
            while (i < subscribers.length) {
                Subscriber subscriber = subscribers[i];
                try {
                    subscriber.refresh(traversals, Policy.subMonitorFor(monitor, 100));
                }
                catch (TeamException e) {
                    errors.add(e);
                }
                ++i;
            }
            try {
                this.handleErrors(errors.toArray(new CoreException[errors.size()]));
            }
            catch (CoreException e) {
                throw TeamException.asTeamException(e);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        this.refresh(new ResourceTraversal[]{new ResourceTraversal(resources, depth, 0)}, monitor);
    }

    public void accept(ResourceTraversal[] traversals, IDiffVisitor visitor) throws CoreException {
        ArrayList<CoreException> errors = new ArrayList<CoreException>();
        Subscriber[] subscribers = this.getSubscribers();
        int i = 0;
        while (i < subscribers.length) {
            Subscriber subscriber = subscribers[i];
            try {
                subscriber.accept(traversals, visitor);
            }
            catch (CoreException e) {
                errors.add(e);
            }
            ++i;
        }
        this.handleErrors(errors.toArray(new CoreException[errors.size()]));
    }

    public void accept(IResource[] resources, int depth, IDiffVisitor visitor) throws CoreException {
        this.accept(new ResourceTraversal[]{new ResourceTraversal(resources, depth, 0)}, visitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getState(ResourceMapping mapping, int stateMask, IProgressMonitor monitor) throws CoreException {
        int state = 0;
        try {
            ArrayList<TeamException> errors = new ArrayList<TeamException>();
            Subscriber[] subscribers = this.getSubscribers(mapping.getProjects());
            monitor.beginTask(null, subscribers.length * 100);
            int i = 0;
            while (true) {
                block6: {
                    if (i < subscribers.length) break block6;
                    this.handleErrors(errors.toArray(new CoreException[errors.size()]));
                    break;
                }
                Subscriber subscriber = subscribers[i];
                try {
                    int subscriberState = subscriber.getState(mapping, stateMask, Policy.subMonitorFor(monitor, 100));
                    state |= subscriberState;
                }
                catch (TeamException e) {
                    errors.add(e);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        monitor.done();
        return state & stateMask;
    }

    private Subscriber[] getSubscribers(IProject[] projects) {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!this.projects.containsKey(project)) {
                this.handleProject(project);
            }
            ++i;
        }
        return this.getSubscribers();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collectOutOfSync(IResource[] resources, int depth, SyncInfoSet set, IProgressMonitor monitor) {
        try {
            Subscriber[] subscribers = this.getSubscribers();
            monitor.beginTask(null, subscribers.length * 100);
            int i = 0;
            while (i < subscribers.length) {
                Subscriber subscriber = subscribers[i];
                subscriber.collectOutOfSync(resources, depth, set, Policy.subMonitorFor(monitor, 100));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
    }

    private Subscriber[] getSubscribers() {
        HashSet<Subscriber> result = new HashSet<Subscriber>();
        Iterator iter = this.projects.values().iterator();
        while (iter.hasNext()) {
            Subscriber subscriber = (Subscriber)iter.next();
            result.add(subscriber);
        }
        return result.toArray(new Subscriber[result.size()]);
    }

    private Subscriber getSubscriber(IResource resource) {
        return (Subscriber)this.projects.get(resource.getProject());
    }

    private void handleErrors(CoreException[] exceptions) throws CoreException {
        if (exceptions.length == 0) {
            return;
        }
        if (exceptions.length == 1) {
            throw exceptions[0];
        }
        MultiStatus result = new MultiStatus("org.eclipse.team.core", 0, Messages.WorkspaceSubscriber_1, null);
        int i = 0;
        while (i < exceptions.length) {
            CoreException exception = exceptions[i];
            Status status = new Status(exception.getStatus().getSeverity(), exception.getStatus().getPlugin(), exception.getStatus().getCode(), exception.getStatus().getMessage(), (Throwable)exception);
            result.add((IStatus)status);
            ++i;
        }
        throw new TeamException((IStatus)result);
    }

    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        this.fireTeamResourceChange(deltas);
    }

    public void providerMapped(RepositoryProvider provider) {
        Subscriber subscriber = provider.getSubscriber();
        if (subscriber != null) {
            this.projects.put(provider.getProject(), subscriber);
        }
    }

    public void providerUnmapped(IProject project) {
        this.projects.remove(project);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        IResourceDelta[] projectDeltas = delta.getAffectedChildren(5);
        int i = 0;
        while (i < projectDeltas.length) {
            IResourceDelta projectDelta = projectDeltas[i];
            IResource resource = projectDelta.getResource();
            if ((projectDelta.getFlags() & 0x4000) != 0 && resource.getType() == 4) {
                IProject project = (IProject)resource;
                if (project.isAccessible()) {
                    this.handleProject(project);
                } else {
                    this.projects.remove(project);
                }
            }
            ++i;
        }
    }
}

