/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.subscribers.SubscriberEventHandler;
import org.eclipse.team.internal.core.subscribers.SubscriberResourceCollector;

public class SubscriberDiffTreeEventHandler
extends SubscriberEventHandler {
    private ResourceDiffTree tree;
    private SubscriberDiffCollector collector;
    private ISynchronizationScopeManager manager;
    private Object family;

    public SubscriberDiffTreeEventHandler(Subscriber subscriber, ISynchronizationScopeManager manager, ResourceDiffTree tree) {
        super(subscriber, manager.getScope());
        this.manager = manager;
        this.tree = tree;
        this.collector = new SubscriberDiffCollector(subscriber);
    }

    protected void reset(ResourceTraversal[] traversals, int type) {
        if (type == 3 && traversals.length == 0) {
            this.queueEvent(new SubscriberEventHandler.RunnableEvent(this, new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SubscriberDiffTreeEventHandler.this.prepareScope(monitor);
                }
            }, true), true);
        } else {
            super.reset(traversals, type);
        }
    }

    protected void prepareScope(IProgressMonitor monitor) {
        try {
            this.manager.initialize(monitor);
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        ResourceTraversal[] traversals = this.manager.getScope().getTraversals();
        if (traversals.length > 0) {
            this.reset(traversals, 3);
        }
    }

    protected void handleChange(IResource resource) throws CoreException {
        IDiff node = this.getSubscriber().getDiff(resource);
        if (node == null) {
            this.queueDispatchEvent(new SubscriberEventHandler.SubscriberEvent(this, resource, 1, 0));
        } else {
            this.queueDispatchEvent(new SubscriberDiffChangedEvent(resource, 2, 0, node));
        }
    }

    protected void collectAll(IResource resource, int depth, final IProgressMonitor monitor) {
        ResourceTraversal[] traversals = new ResourceTraversal[]{new ResourceTraversal(new IResource[]{resource}, depth, 0)};
        try {
            this.getSubscriber().accept(traversals, new IDiffVisitor(){

                public boolean visit(IDiff node) {
                    SubscriberDiffTreeEventHandler.this.queueDispatchEvent(new SubscriberDiffChangedEvent(SubscriberDiffTreeEventHandler.this.tree.getResource(node), 2, 0, node));
                    SubscriberDiffTreeEventHandler.this.handlePreemptiveEvents(monitor);
                    SubscriberDiffTreeEventHandler.this.handlePendingDispatch(monitor);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            this.handleException(e, resource, 2, e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispatchEvents(SubscriberEventHandler.SubscriberEvent[] events, IProgressMonitor monitor) {
        try {
            this.tree.beginInput();
            int i = 0;
            while (i < events.length) {
                SubscriberEventHandler.SubscriberEvent event = events[i];
                switch (event.getType()) {
                    case 2: {
                        if (!(event instanceof SubscriberDiffChangedEvent)) break;
                        SubscriberDiffChangedEvent se = (SubscriberDiffChangedEvent)event;
                        IDiff changedNode = se.getChangedNode();
                        if (changedNode.getKind() == 0) {
                            this.tree.remove(changedNode.getPath());
                            break;
                        }
                        this.tree.add(changedNode);
                        break;
                    }
                    case 1: {
                        IDiff[] nodesToRemove = this.tree.getDiffs(new ResourceTraversal[]{event.asTraversal()});
                        int j = 0;
                        while (j < nodesToRemove.length) {
                            IDiff node = nodesToRemove[j];
                            this.tree.remove(node.getPath());
                            ++j;
                        }
                        break;
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.tree.endInput(monitor);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        this.tree.endInput(monitor);
    }

    public IResourceDiffTree getTree() {
        return this.tree;
    }

    public Subscriber getSubscriber() {
        return super.getSubscriber();
    }

    public void shutdown() {
        this.collector.dispose();
        super.shutdown();
    }

    protected Object getJobFamiliy() {
        return this.family;
    }

    public void setJobFamily(Object family) {
        this.family = family;
    }

    protected void handleException(CoreException e, IResource resource, int code, String message) {
        super.handleException(e, resource, code, message);
        this.tree.reportError(new TeamStatus(4, "org.eclipse.team.core", code, message, e, resource));
    }

    protected void handleCancel(OperationCanceledException e) {
        super.handleCancel(e);
        this.tree.reportError(new TeamStatus(4, "org.eclipse.team.core", 3, Messages.SubscriberEventHandler_12, e, (IResource)ResourcesPlugin.getWorkspace().getRoot()));
    }

    private class SubscriberDiffChangedEvent
    extends SubscriberEventHandler.SubscriberEvent {
        private final IDiff node;

        public SubscriberDiffChangedEvent(IResource resource, int type, int depth, IDiff node) {
            super(SubscriberDiffTreeEventHandler.this, resource, type, depth);
            this.node = node;
        }

        public IDiff getChangedNode() {
            return this.node;
        }
    }

    private class SubscriberDiffCollector
    extends SubscriberResourceCollector {
        public SubscriberDiffCollector(Subscriber subscriber) {
            super(subscriber);
        }

        protected boolean hasMembers(IResource resource) {
            return SubscriberDiffTreeEventHandler.this.tree.members(resource).length > 0;
        }

        protected void remove(IResource resource) {
            SubscriberDiffTreeEventHandler.this.remove(resource);
        }

        protected void change(IResource resource, int depth) {
            SubscriberDiffTreeEventHandler.this.change(resource, depth);
        }
    }
}

