/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class ShowModelProviderAction extends Action {

	private final ISynchronizePageConfiguration configuration;
	private final ModelProvider provider;

	public ShowModelProviderAction(ISynchronizePageConfiguration configuration, ModelProvider provider) {
		super(Utils.getLabel(provider), IAction.AS_RADIO_BUTTON);
		this.configuration = configuration;
		this.provider = provider;
		setImageDescriptor(getImageDescriptor(provider));
	}
	
	private ImageDescriptor getImageDescriptor(ModelProvider provider) {
		ITeamContentProviderManager manager = TeamUI.getTeamContentProviderManager();
		ITeamContentProviderDescriptor desc = manager.getDescriptor(provider.getId());
		return desc.getImageDescriptor();
	}

	public void run() {
		Viewer v = configuration.getPage().getViewer();
		v.setInput(provider);
		configuration.setProperty(
				ModelSynchronizeParticipant.P_VISIBLE_MODEL_PROVIDER,
				provider.getDescriptor().getId());
		configuration.setProperty(
				ISynchronizePageConfiguration.P_PAGE_DESCRIPTION,
				NLS.bind(TeamUIMessages.ShowModelProviderAction_0, new String[] {Utils.getLabel(provider), configuration.getParticipant().getName()}));
	}

	public String getProviderId() {
		return provider.getDescriptor().getId();
	}

}
