/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.core.resources.IResource;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.ui.IWorkingSet;

public class DefaultTextSearchQueryProvider
extends TextSearchQueryProvider {
    public ISearchQuery createQuery(TextSearchQueryProvider.TextSearchInput input) {
        FileTextSearchScope scope = input.getScope();
        String text = input.getSearchText();
        boolean regEx = input.isRegExSearch();
        boolean caseSensitive = input.isCaseSensitiveSearch();
        return new FileSearchQuery(text, regEx, caseSensitive, scope);
    }

    public ISearchQuery createQuery(String searchForString) {
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope(this.getPreviousFileNamePatterns(), false);
        return new FileSearchQuery(searchForString, false, true, scope);
    }

    public ISearchQuery createQuery(String selectedText, IResource[] resources) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope(resources, this.getPreviousFileNamePatterns(), false);
        return new FileSearchQuery(selectedText, false, true, scope);
    }

    public ISearchQuery createQuery(String selectedText, IWorkingSet[] ws) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope(ws, this.getPreviousFileNamePatterns(), false);
        return new FileSearchQuery(selectedText, false, true, scope);
    }

    private FileSearchQuery findLastUsedOldQuery() {
        ISearchQuery query;
        AbstractTextSearchResult searchResult;
        FileSearchPage searchPage;
        ISearchResultViewPart searchView = InternalSearchUI.getInstance().getSearchViewManager().getActiveSearchView();
        if (searchView instanceof SearchView && (searchPage = (FileSearchPage)((SearchView)searchView).getSearchPageRegistry().findPageForPageId("org.eclipse.search.text.FileSearchResultPage", false)) != null && (searchResult = searchPage.getInput()) instanceof FileSearchResult && (query = searchResult.getQuery()) instanceof FileSearchQuery) {
            return (FileSearchQuery)query;
        }
        return null;
    }

    private String[] getPreviousFileNamePatterns() {
        FileSearchQuery lastQuery = this.findLastUsedOldQuery();
        if (lastQuery != null) {
            return lastQuery.getSearchScope().getFileNamePatterns();
        }
        return null;
    }
}

