/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.IEditableTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ITaskGroup;

public class TaskStateUtilities {
    public static ICompositeCheatSheetTask findBlockedAncestor(ICompositeCheatSheetTask task) {
        ITaskGroup parent = ((AbstractTask)task).getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.requiredTasksCompleted()) {
            return parent;
        }
        return TaskStateUtilities.findBlockedAncestor(parent);
    }

    public static ICompositeCheatSheetTask findSkippedAncestor(ICompositeCheatSheetTask task) {
        ITaskGroup parent = ((AbstractTask)task).getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getState() == 2) {
            return parent;
        }
        return TaskStateUtilities.findSkippedAncestor(parent);
    }

    public static ICompositeCheatSheetTask findCompletedAncestor(ICompositeCheatSheetTask task) {
        ITaskGroup parent = ((AbstractTask)task).getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getState() == 3) {
            return parent;
        }
        return TaskStateUtilities.findCompletedAncestor(parent);
    }

    public static boolean isSkipEnabled(ICompositeCheatSheetTask task) {
        if (!task.isSkippable()) {
            return false;
        }
        if (task.getState() == 3) {
            return false;
        }
        if (task.getState() == 2) {
            return false;
        }
        if (TaskStateUtilities.findCompletedAncestor(task) != null) {
            return false;
        }
        return TaskStateUtilities.findSkippedAncestor(task) == null;
    }

    public static boolean isStartEnabled(ICompositeCheatSheetTask task) {
        if (!(task instanceof IEditableTask)) {
            return false;
        }
        if (task.getState() != 0) {
            return false;
        }
        if (TaskStateUtilities.findSkippedAncestor(task) != null) {
            return false;
        }
        if (TaskStateUtilities.findCompletedAncestor(task) != null) {
            return false;
        }
        if (!task.requiredTasksCompleted()) {
            return false;
        }
        return TaskStateUtilities.findBlockedAncestor(task) == null;
    }

    public static AbstractTask[] getRestartTasks(ICompositeCheatSheetTask task) {
        ArrayList restartables = new ArrayList();
        TaskStateUtilities.addRestartableTasks(restartables, task);
        return restartables.toArray(new AbstractTask[restartables.size()]);
    }

    private static void addRestartableTasks(List restartables, ICompositeCheatSheetTask task) {
        if (task instanceof IEditableTask && task.getState() != 0) {
            restartables.add(task);
        } else if (task.getState() == 2) {
            restartables.add(task);
        }
        ICompositeCheatSheetTask[] children = task.getSubtasks();
        int i = 0;
        while (i < children.length) {
            TaskStateUtilities.addRestartableTasks(restartables, children[i]);
            ++i;
        }
    }
}

