/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarkupParser {
    public static String parseAndTrimTextMarkup(Node parentNode) {
        return MarkupParser.parseMarkup(parentNode).trim();
    }

    private static String parseMarkup(Node parentNode) {
        NodeList children = parentNode.getChildNodes();
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 3) {
                text.append(MarkupParser.escapeText(childNode.getNodeValue()));
            } else if (childNode.getNodeType() == 1) {
                text.append('<');
                text.append(childNode.getNodeName());
                text.append('>');
                text.append(MarkupParser.parseMarkup(childNode));
                text.append("</");
                text.append(childNode.getNodeName());
                text.append('>');
            }
            ++i;
        }
        return text.toString();
    }

    private static String escapeText(String nodeValue) {
        String temp = nodeValue.replaceAll(">", "&gt;");
        return temp.replaceAll("<", "&lt;");
    }
}

