/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.universal.BaseData;
import org.eclipse.ui.internal.intro.universal.ExtensionData;
import org.eclipse.ui.internal.intro.universal.ExtensionDataTransfer;
import org.eclipse.ui.internal.intro.universal.GroupData;
import org.eclipse.ui.internal.intro.universal.IntroData;
import org.eclipse.ui.internal.intro.universal.Messages;
import org.eclipse.ui.internal.intro.universal.PageData;
import org.eclipse.ui.internal.intro.universal.SeparatorData;
import org.eclipse.ui.internal.intro.universal.UniversalIntroPlugin;
import org.eclipse.ui.internal.intro.universal.util.BundleUtil;
import org.eclipse.ui.internal.intro.universal.util.ImageUtil;
import org.eclipse.ui.internal.intro.universal.util.Log;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;

public class WelcomeCustomizationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    private static final String INTRO_ROOT_PAGES = "INTRO_ROOT_PAGES";
    private static final String INTRO_DATA = "INTRO_DATA";
    private static final String INTRO_THEME = "INTRO_THEME";
    private TabFolder tabFolder;
    private String firstPageId;
    private Composite pageContainer;
    private TableViewer themes;
    private TableViewer available;
    private TableViewer topLeft;
    private TableViewer topRight;
    private TableViewer bottomLeft;
    private TableViewer bottomRight;
    private CheckboxTableViewer rootPages;
    private ArrayList introRootPages = new ArrayList();
    private ArrayList themeList = new ArrayList();
    private IntroTheme introTheme;
    private String introThemeId;
    private IntroData introData;
    private Canvas themePreview;
    private TableContentProvider contentProvider;
    private TableLabelProvider labelProvider;
    private Button applyToAll;
    private Image extensionImage;
    private Image themeImage;
    private Image ihighImage;
    private Image ilowImage;
    private Image inewImage;
    private Image icalloutImage;
    private static final Transfer[] TRANSFER_TYPES = new Transfer[]{ExtensionDataTransfer.getInstance()};
    private static final RootPage[] ROOT_PAGE_TABLE = new RootPage[]{new RootPage("overview", Messages.WelcomeCustomizationPreferencePage_overview), new RootPage("firststeps", Messages.WelcomeCustomizationPreferencePage_firststeps), new RootPage("tutorials", Messages.WelcomeCustomizationPreferencePage_tutorials), new RootPage("samples", Messages.WelcomeCustomizationPreferencePage_samples), new RootPage("whatsnew", Messages.WelcomeCustomizationPreferencePage_whatsnew), new RootPage("webresources", Messages.WelcomeCustomizationPreferencePage_webresources), new RootPage("migrate", Messages.WelcomeCustomizationPreferencePage_migrate)};

    public WelcomeCustomizationPreferencePage() {
    }

    public WelcomeCustomizationPreferencePage(String title) {
        super(title);
    }

    public WelcomeCustomizationPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.tabFolder = new TabFolder(container, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabItem[] selection = WelcomeCustomizationPreferencePage.this.tabFolder.getSelection();
                WelcomeCustomizationPreferencePage.this.onTabChange(selection[0]);
            }
        });
        this.applyToAll = new Button(container, 32);
        this.applyToAll.setText(Messages.WelcomeCustomizationPreferencePage_applyToAll);
        this.contentProvider = new TableContentProvider();
        this.labelProvider = new TableLabelProvider();
        if (this.isCustomizationMode()) {
            Button serialize = new Button(container, 8);
            serialize.setText(Messages.WelcomeCustomizationPreferencePage_serialize);
            serialize.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WelcomeCustomizationPreferencePage.this.doSerializeState();
                }
            });
        }
        this.extensionImage = ImageUtil.createImage("full/obj16/extension_obj.gif");
        this.ihighImage = ImageUtil.createImage("full/obj16/ihigh_obj.gif");
        this.ilowImage = ImageUtil.createImage("full/obj16/ilow_obj.gif");
        this.inewImage = ImageUtil.createImage("full/obj16/inew_obj.gif");
        this.icalloutImage = ImageUtil.createImage("full/obj16/icallout_obj.gif");
        this.themeImage = ImageUtil.createImage("full/obj16/image_obj.gif");
        this.addPages();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void doSerializeState() {
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setText(Messages.WelcomeCustomizationPreferencePage_serializeTitle);
        String fileName = fd.open();
        if (fileName != null) {
            try {
                FileWriter writer = new FileWriter(fileName);
                PrintWriter pwriter = new PrintWriter(writer);
                this.introData.write(pwriter);
                pwriter.close();
            }
            catch (IOException e) {
                Log.error("Error while saving the intro data file", e);
            }
        }
    }

    private boolean isCustomizationMode() {
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    private void addPages() {
        this.loadData(false);
        this.addHomePage();
        this.createPageContainer();
        this.addRootPages();
        this.updateWidgetsFromData();
        this.selectFirstPage();
    }

    private void addRootPages() {
        this.addPage("overview");
        this.addPage("firststeps");
        this.addPage("tutorials");
        this.addPage("samples");
        this.addPage("whatsnew");
        this.addPage("webresources");
        this.addPage("migrate");
    }

    private void createPageContainer() {
        this.pageContainer = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        this.pageContainer.setLayout((Layout)layout);
        layout.numColumns = 4;
        Label label = new Label(this.pageContainer, 64);
        label.setText(Messages.WelcomeCustomizationPreferencePage_pageDesc);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 4;
        label.setLayoutData((Object)gd);
        label = new Label(this.pageContainer, 258);
        gd = new GridData(256);
        gd.horizontalSpan = 4;
        label.setLayoutData((Object)gd);
        label = new Label(this.pageContainer, 0);
        label.setText(Messages.WelcomeCustomizationPreferencePage_available);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        label = new Label(this.pageContainer, 514);
        gd = new GridData(16);
        gd.verticalSpan = 3;
        gd.widthHint = 10;
        label.setLayoutData((Object)gd);
        label = new Label(this.pageContainer, 0);
        label.setText(Messages.WelcomeCustomizationPreferencePage_left);
        label = new Label(this.pageContainer, 0);
        label.setText(Messages.WelcomeCustomizationPreferencePage_right);
        this.available = this.createTableViewer(this.pageContainer, "hidden");
        this.available.setSorter(new ViewerSorter());
        gd = new GridData(784);
        gd.verticalSpan = 2;
        gd.widthHint = 100;
        this.available.getControl().setLayoutData((Object)gd);
        this.topLeft = this.createTableViewer(this.pageContainer, "top-left");
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.topLeft.getControl().setLayoutData((Object)gd);
        this.topRight = this.createTableViewer(this.pageContainer, "top-right");
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.topRight.getControl().setLayoutData((Object)gd);
        this.bottomLeft = this.createTableViewer(this.pageContainer, "bottom-left");
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.bottomLeft.getControl().setLayoutData((Object)gd);
        this.bottomRight = this.createTableViewer(this.pageContainer, "bottom-right");
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.bottomRight.getControl().setLayoutData((Object)gd);
    }

    private void updatePageContainer(String pageId, PageData pd) {
        if (pageId == null) {
            return;
        }
        this.refreshQuadrant(this.topLeft, pd, "top-left");
        this.refreshQuadrant(this.topRight, pd, "top-right");
        this.refreshQuadrant(this.bottomLeft, pd, "bottom-left");
        this.refreshQuadrant(this.bottomRight, pd, "bottom-right");
        this.refreshQuadrant(this.available, pd, "hidden");
    }

    private void refreshQuadrant(TableViewer viewer, PageData pd, String quadrant) {
        GroupData gd = pd != null ? pd.findGroup(quadrant) : null;
        viewer.setInput((Object)gd);
        if (gd != null) {
            this.updateColumnSizes(viewer);
        }
    }

    private void onTabChange(TabItem item) {
        String id = (String)item.getData();
        if (item.getControl() == this.pageContainer) {
            this.updatePageContainer(id, (PageData)item.getData("pageData"));
        }
    }

    private void loadData(boolean fromDefault) {
        String value;
        String rootPages;
        IProduct product = Platform.getProduct();
        if (product == null) {
            return;
        }
        String pid = product.getId();
        this.introRootPages.clear();
        Preferences prefs = UniversalIntroPlugin.getDefault().getPluginPreferences();
        Preferences iprefs = IntroPlugin.getDefault().getPluginPreferences();
        String key = String.valueOf(pid) + "_" + INTRO_ROOT_PAGES;
        String string = rootPages = fromDefault ? prefs.getDefaultString(key) : prefs.getString(key);
        if (rootPages.length() == 0) {
            String string2 = rootPages = fromDefault ? prefs.getDefaultString(INTRO_ROOT_PAGES) : prefs.getString(INTRO_ROOT_PAGES);
        }
        if (rootPages.length() > 0) {
            StringTokenizer stok = new StringTokenizer(rootPages, ",");
            while (stok.hasMoreTokens()) {
                String tok = stok.nextToken().trim();
                this.introRootPages.add(tok);
            }
        }
        key = String.valueOf(pid) + "_" + INTRO_THEME;
        String string3 = value = fromDefault ? iprefs.getDefaultString(key) : iprefs.getString(key);
        if (value.length() == 0) {
            key = INTRO_THEME;
            String string4 = value = fromDefault ? iprefs.getDefaultString(key) : iprefs.getString(key);
        }
        if (value.length() > 0) {
            this.introThemeId = value;
        }
        key = String.valueOf(pid) + "_" + INTRO_DATA;
        String string5 = value = fromDefault ? prefs.getDefaultString(key) : prefs.getString(key);
        if (value.length() == 0) {
            key = INTRO_DATA;
            String string6 = value = fromDefault ? prefs.getDefaultString(key) : prefs.getString(key);
        }
        if (value.length() == 0) {
            value = null;
        }
        if (value != null && value.startsWith("product:")) {
            value = value.substring(8);
        }
        value = BundleUtil.getResolvedResourceLocation(value, product.getDefiningBundle());
        this.introData = new IntroData(pid, value, true);
        this.introData.addImplicitContent();
    }

    public void dispose() {
        this.themeList.clear();
        this.extensionImage.dispose();
        this.ihighImage.dispose();
        this.ilowImage.dispose();
        this.inewImage.dispose();
        this.icalloutImage.dispose();
        this.themeImage.dispose();
        super.dispose();
    }

    private void updateIntroThemeFromData() {
        if (this.introThemeId != null) {
            int i = 0;
            while (i < this.themeList.size()) {
                IntroTheme theme = (IntroTheme)this.themeList.get(i);
                if (theme.getId().equals(this.introThemeId)) {
                    this.introTheme = theme;
                    break;
                }
                ++i;
            }
        }
        this.updateThemePreview();
    }

    private void updateWidgetsFromData() {
        this.updateIntroThemeFromData();
        this.rootPages.setInput((Object)ROOT_PAGE_TABLE);
        ArrayList<RootPage> selected = new ArrayList<RootPage>();
        int i = 0;
        while (i < ROOT_PAGE_TABLE.length) {
            String id = WelcomeCustomizationPreferencePage.ROOT_PAGE_TABLE[i].id;
            if (this.introRootPages.contains(id)) {
                selected.add(ROOT_PAGE_TABLE[i]);
            }
            ++i;
        }
        this.rootPages.setCheckedElements(selected.toArray());
    }

    private void updateThemePreview() {
        this.themes.setInput((Object)this.themes);
        if (this.introTheme != null) {
            this.themes.setSelection((ISelection)new StructuredSelection((Object)this.introTheme), true);
        }
        this.themePreview.redraw();
    }

    public boolean performOk() {
        this.saveData();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                WelcomeCustomizationPreferencePage.this.restartIntro();
            }
        });
        return true;
    }

    private void restartIntro() {
        IIntroManager manager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart part = manager.getIntro();
        if (part != null && part instanceof CustomizableIntroPart) {
            IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
            String currentPageId = modelRoot.getCurrentPageId();
            IWorkbenchWindow window = part.getIntroSite().getWorkbenchWindow();
            boolean standby = manager.isIntroStandby(part);
            PlatformUI.getWorkbench().getIntroManager().closeIntro(part);
            IntroPlugin.getDefault().resetVolatileImageRegistry();
            UniversalIntroPlugin.getDefault().resetVolatileImageRegistry();
            part = PlatformUI.getWorkbench().getIntroManager().showIntro(window, standby);
            if (part != null) {
                StringBuffer url = new StringBuffer();
                url.append("http://org.eclipse.ui.intro/showPage?id=");
                url.append(currentPageId);
                IIntroURL introURL = IntroURLFactory.createIntroURL((String)url.toString());
                if (introURL != null) {
                    introURL.execute();
                }
            }
        }
    }

    protected void performDefaults() {
        this.loadData(true);
        TabItem[] items = this.tabFolder.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("pageData") != null) {
                items[i].dispose();
            }
            ++i;
        }
        this.addRootPages();
        this.updateWidgetsFromData();
        items = this.tabFolder.getItems();
        this.onTabChange(items[0]);
        super.performDefaults();
    }

    private void saveData() {
        Preferences prefs = UniversalIntroPlugin.getDefault().getPluginPreferences();
        Preferences iprefs = IntroPlugin.getDefault().getPluginPreferences();
        boolean toAll = this.applyToAll.getSelection();
        IProduct product = Platform.getProduct();
        if (product == null) {
            return;
        }
        String pid = product.getId();
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.introRootPages.size()) {
            if (i > 0) {
                sbuf.append(",");
            }
            sbuf.append((String)this.introRootPages.get(i));
            ++i;
        }
        String key = String.valueOf(pid) + "_" + INTRO_ROOT_PAGES;
        prefs.setValue(key, sbuf.toString());
        if (toAll) {
            key = INTRO_ROOT_PAGES;
            prefs.setValue(key, sbuf.toString());
        }
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        this.introData.write(pwriter);
        pwriter.close();
        String value = writer.toString();
        key = String.valueOf(pid) + "_" + INTRO_DATA;
        prefs.setValue(key, value);
        if (toAll) {
            key = INTRO_DATA;
            prefs.setValue(key, value);
        }
        if (this.introTheme != null) {
            key = String.valueOf(pid) + "_" + INTRO_THEME;
            value = this.introTheme.getId();
            iprefs.setValue(key, value);
        }
        if (toAll) {
            key = INTRO_THEME;
            iprefs.setValue(key, value);
        }
        UniversalIntroPlugin.getDefault().savePluginPreferences();
        IntroPlugin.getDefault().savePluginPreferences();
    }

    private void addHomePage() {
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText("Home");
        Composite container = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.WelcomeCustomizationPreferencePage_background);
        GridData gd = new GridData(2);
        label.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(Messages.WelcomeCustomizationPreferencePage_preview);
        this.themes = new TableViewer(container, 2048);
        this.themes.getControl().setLayoutData((Object)new GridData(1808));
        this.themes.setContentProvider((IContentProvider)this.contentProvider);
        this.themes.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.themes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object sel = ((StructuredSelection)e.getSelection()).getFirstElement();
                WelcomeCustomizationPreferencePage.this.introTheme = (IntroTheme)sel;
                WelcomeCustomizationPreferencePage.this.themePreview.redraw();
            }
        });
        this.loadThemes();
        this.themePreview = new Canvas(container, 0);
        gd = new GridData();
        gd.widthHint = 180;
        gd.heightHint = 140;
        this.themePreview.setLayoutData((Object)gd);
        this.themePreview.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (WelcomeCustomizationPreferencePage.this.introTheme == null) {
                    return;
                }
                Image bgImage = WelcomeCustomizationPreferencePage.this.introTheme.getPreviewImage();
                if (bgImage == null) {
                    return;
                }
                Rectangle ibounds = bgImage.getBounds();
                e.gc.drawImage(bgImage, 0, 0, ibounds.width, ibounds.height, 10, 10, 160, 120);
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.WelcomeCustomizationPreferencePage_rootpages);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.rootPages = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
        this.rootPages.setContentProvider((IContentProvider)this.contentProvider);
        this.rootPages.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.rootPages.getControl().setLayoutData((Object)gd);
        this.rootPages.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RootPage page = (RootPage)event.getElement();
                boolean checked = event.getChecked();
                WelcomeCustomizationPreferencePage.this.onPageChecked(page.id, checked);
            }
        });
        item.setControl((Control)container);
    }

    private void loadThemes() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("theme")) {
                this.themeList.add(new IntroTheme(elements[i]));
            }
            ++i;
        }
    }

    private void addPage(String id) {
        if (!this.getRootPageSelected(id)) {
            return;
        }
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText(this.getRootPageName(id));
        item.setControl((Control)this.pageContainer);
        item.setData((Object)id);
        PageData pd = this.introData.getPage(id);
        item.setData("pageData", (Object)pd);
    }

    private void onPageChecked(String id, boolean checked) {
        TabItem[] items = this.tabFolder.getItems();
        if (checked) {
            int i = 0;
            while (i < items.length) {
                TabItem item = items[i];
                if (item.getData() != null) {
                    item.dispose();
                }
                ++i;
            }
            this.introRootPages.add(id);
            this.addRootPages();
        } else {
            int i = 0;
            while (i < items.length) {
                TabItem item = items[i];
                String itemId = (String)item.getData();
                if (itemId != null && itemId.equals(id)) {
                    item.dispose();
                    this.introRootPages.remove(id);
                    return;
                }
                ++i;
            }
        }
    }

    private String getRootPageName(String id) {
        int i = 0;
        while (i < ROOT_PAGE_TABLE.length) {
            if (WelcomeCustomizationPreferencePage.ROOT_PAGE_TABLE[i].id.equals(id)) {
                return WelcomeCustomizationPreferencePage.ROOT_PAGE_TABLE[i].name;
            }
            ++i;
        }
        return "?";
    }

    private boolean getRootPageSelected(String id) {
        int i = 0;
        while (i < this.introRootPages.size()) {
            String cid = (String)this.introRootPages.get(i);
            if (cid.equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private void createPopupMenu(final TableViewer viewer) {
        MenuManager manager = new MenuManager();
        manager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(manager.getMenu());
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WelcomeCustomizationPreferencePage.this.fillPopupMenu(manager, viewer);
            }
        });
    }

    private void addDNDSupport(TableViewer viewer) {
        viewer.addDragSupport(2, TRANSFER_TYPES, (DragSourceListener)new TableDragSourceListener(viewer));
        viewer.addDropSupport(2, TRANSFER_TYPES, (DropTargetListener)new TableDropTargetListener(viewer));
    }

    private TableViewer createTableViewer(Composite parent, String id) {
        Table table = new Table(parent, 67584);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setMoveable(false);
        column1.setWidth(20);
        column1.setResizable(false);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setResizable(true);
        final TableViewer viewer = new TableViewer(table);
        CellEditor[] editors = new CellEditor[2];
        editors[0] = new ComboBoxCellEditor((Composite)table, ExtensionData.IMPORTANCE_NAME_TABLE, 8);
        viewer.setCellEditors(editors);
        viewer.setColumnProperties(new String[]{"importance", "name"});
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("importance");
            }

            public Object getValue(Object element, String property) {
                if (element instanceof ExtensionData) {
                    ExtensionData ed = (ExtensionData)element;
                    if (property.equals("importance")) {
                        return new Integer(ed.getImportance());
                    }
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Integer ivalue = (Integer)value;
                TableItem item = (TableItem)element;
                ExtensionData ed = (ExtensionData)item.getData();
                ed.setImportance(ivalue);
                viewer.update((Object)ed, new String[]{"importance"});
            }
        });
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setData("id", (Object)id);
        this.createPopupMenu(viewer);
        this.addDNDSupport(viewer);
        return viewer;
    }

    private void fillPopupMenu(IMenuManager manager, final TableViewer viewer) {
        StructuredSelection ssel = (StructuredSelection)viewer.getSelection();
        manager.add((IContributionItem)new Separator());
        Action addSeparator = new Action(Messages.WelcomeCustomizationPreferencePage_addSeparator){

            public void run() {
                WelcomeCustomizationPreferencePage.this.doAddSeparator((Viewer)viewer);
            }
        };
        manager.add((IAction)addSeparator);
        manager.add((IContributionItem)new Separator());
        if (ssel.size() == 1 && viewer != this.available) {
            Action upAction = new Action(Messages.WelcomeCustomizationPreferencePage_up){

                public void run() {
                    WelcomeCustomizationPreferencePage.this.doMove((Viewer)viewer, true);
                }
            };
            Action downAction = new Action(Messages.WelcomeCustomizationPreferencePage_down){

                public void run() {
                    WelcomeCustomizationPreferencePage.this.doMove((Viewer)viewer, false);
                }
            };
            BaseData ed = (BaseData)ssel.getFirstElement();
            GroupData gd = (GroupData)viewer.getInput();
            upAction.setEnabled(gd.canMoveUp(ed));
            downAction.setEnabled(gd.canMoveDown(ed));
            manager.add((IAction)upAction);
            manager.add((IAction)downAction);
        }
        if (ssel.size() > 0) {
            manager.add((IContributionItem)new Separator());
            MenuManager menu = new MenuManager(Messages.WelcomeCustomizationPreferencePage_moveTo);
            this.addMoveToAction(menu, this.available, viewer, Messages.WelcomeCustomizationPreferencePage_menu_available);
            this.addMoveToAction(menu, this.topLeft, viewer, Messages.WelcomeCustomizationPreferencePage_menu_top_left);
            this.addMoveToAction(menu, this.topRight, viewer, Messages.WelcomeCustomizationPreferencePage_menu_top_right);
            this.addMoveToAction(menu, this.bottomLeft, viewer, Messages.WelcomeCustomizationPreferencePage_menu_bottom_left);
            this.addMoveToAction(menu, this.bottomRight, viewer, Messages.WelcomeCustomizationPreferencePage_menu_bottom_right);
            manager.add((IContributionItem)menu);
            boolean addDeleteSeparator = false;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof SeparatorData) {
                    addDeleteSeparator = true;
                    continue;
                }
                addDeleteSeparator = false;
                break;
            }
            if (addDeleteSeparator) {
                Action deleteSeparator = new Action(Messages.WelcomeCustomizationPreferencePage_removeSeparator){

                    public void run() {
                        WelcomeCustomizationPreferencePage.this.doRemoveSeparators((Viewer)viewer);
                    }
                };
                manager.add((IAction)deleteSeparator);
            }
        }
    }

    private void addMoveToAction(MenuManager menu, final TableViewer target, final TableViewer source, String name) {
        if (source == target) {
            return;
        }
        Action action = new Action(name){

            public void run() {
                WelcomeCustomizationPreferencePage.this.doMoveTo(source, target);
            }
        };
        menu.add((IAction)action);
    }

    private void doMove(Viewer viewer, boolean up) {
        Object obj = ((StructuredSelection)viewer.getSelection()).getFirstElement();
        GroupData gd = (GroupData)viewer.getInput();
        if (up) {
            gd.moveUp((BaseData)obj);
        } else {
            gd.moveDown((BaseData)obj);
        }
        viewer.refresh();
    }

    private void doAddSeparator(Viewer viewer) {
        Object obj = ((StructuredSelection)viewer.getSelection()).getFirstElement();
        GroupData gd = (GroupData)viewer.getInput();
        gd.addSeparator((BaseData)obj);
        viewer.refresh();
    }

    private void doRemoveSeparators(Viewer viewer) {
        StructuredSelection ssel = (StructuredSelection)viewer.getSelection();
        GroupData gd = (GroupData)viewer.getInput();
        Iterator iter = ssel.iterator();
        while (iter.hasNext()) {
            SeparatorData sdata = (SeparatorData)iter.next();
            gd.remove(sdata);
        }
        viewer.refresh();
    }

    private void doMoveTo(TableViewer source, TableViewer target) {
        Object[] selObjs = ((StructuredSelection)source.getSelection()).toArray();
        GroupData sourceGd = (GroupData)source.getInput();
        GroupData targetGd = (GroupData)target.getInput();
        if (targetGd == null) {
            targetGd = this.createTargetGd((Viewer)target);
        }
        int i = 0;
        while (i < selObjs.length) {
            BaseData ed = (BaseData)selObjs[i];
            sourceGd.remove(ed);
            targetGd.add(ed);
            ++i;
        }
        source.refresh();
        this.updateColumnSizes(source);
        if (target.getInput() != null) {
            target.refresh();
        } else {
            target.setInput((Object)targetGd);
        }
        this.updateColumnSizes(target);
    }

    private void updateColumnSizes(TableViewer viewer) {
        TableColumn sc = viewer.getTable().getColumn(1);
        sc.pack();
    }

    private GroupData createTargetGd(Viewer target) {
        GroupData targetGd = null;
        if (target == this.topLeft) {
            targetGd = new GroupData("page-content/top-left", false);
        } else if (target == this.topRight) {
            targetGd = new GroupData("page-content/top-right", false);
        } else if (target == this.bottomLeft) {
            targetGd = new GroupData("page-content/bottom-left", false);
        } else if (target == this.bottomRight) {
            targetGd = new GroupData("page-content/bottom-right", false);
        } else if (target == this.available) {
            targetGd = new GroupData("hidden", false);
        } else {
            return null;
        }
        TabItem[] items = this.tabFolder.getSelection();
        PageData pd = (PageData)items[0].getData("pageData");
        pd.add(targetGd);
        return targetGd;
    }

    public void setCurrentPage(String pageId) {
        this.firstPageId = pageId;
    }

    private void selectFirstPage() {
        if (this.firstPageId == null) {
            return;
        }
        TabItem[] items = this.tabFolder.getItems();
        int i = 0;
        while (i < items.length) {
            TabItem item = items[i];
            PageData pd = (PageData)item.getData("pageData");
            if (pd != null && pd.getId().equals(this.firstPageId)) {
                this.tabFolder.setSelection(i);
                this.onTabChange(item);
                return;
            }
            ++i;
        }
    }

    static class RootPage {
        public String id;
        public String name;

        public RootPage(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof RootPage) {
                RootPage page = (RootPage)obj;
                return page.id.equals(this.id) && page.name.equals(this.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == ROOT_PAGE_TABLE) {
                return ROOT_PAGE_TABLE;
            }
            if (inputElement instanceof GroupData) {
                return ((GroupData)inputElement).getChildren();
            }
            if (inputElement == WelcomeCustomizationPreferencePage.this.themes) {
                return WelcomeCustomizationPreferencePage.this.themeList.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableDragSourceListener
    implements DragSourceListener {
        TableViewer viewer;
        BaseData[] sel;

        public TableDragSourceListener(TableViewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection ssel = (IStructuredSelection)this.viewer.getSelection();
            event.doit = ssel.size() > 0;
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection ssel = (IStructuredSelection)this.viewer.getSelection();
            BaseData[] array = new BaseData[ssel.size()];
            int i = 0;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                array[i++] = (BaseData)iter.next();
            }
            event.data = array;
            this.sel = array;
        }

        public void dragFinished(DragSourceEvent event) {
            if (event.detail == 2) {
                GroupData gd = (GroupData)this.viewer.getInput();
                int i = 0;
                while (i < this.sel.length) {
                    BaseData ed = this.sel[i];
                    gd.remove(ed);
                    ++i;
                }
                this.viewer.refresh();
                WelcomeCustomizationPreferencePage.this.updateColumnSizes(this.viewer);
            }
            this.sel = null;
        }
    }

    class TableDropTargetListener
    extends ViewerDropAdapter {
        public TableDropTargetListener(TableViewer viewer) {
            super((Viewer)viewer);
        }

        public boolean performDrop(Object data) {
            BaseData target = (BaseData)this.getCurrentTarget();
            int loc = this.getCurrentLocation();
            GroupData gd = (GroupData)this.getViewer().getInput();
            if (gd == null) {
                gd = WelcomeCustomizationPreferencePage.this.createTargetGd(this.getViewer());
            }
            BaseData[] sel = (BaseData[])data;
            int index = target != null ? gd.getIndexOf(target) : -1;
            int startingIndex = this.getStartIndex(gd, sel);
            if (target != null) {
                if (loc == 2 || loc == 3 && startingIndex != -1 && startingIndex < index) {
                    ++index;
                } else if (index > 0 && loc == 1) {
                    --index;
                }
            }
            int i = 0;
            while (i < sel.length) {
                BaseData ed = sel[i];
                if (index == -1) {
                    gd.add(ed);
                } else {
                    gd.add(index++, ed);
                }
                ++i;
            }
            if (this.getViewer().getInput() != null) {
                this.getViewer().refresh();
            } else {
                this.getViewer().setInput((Object)gd);
            }
            WelcomeCustomizationPreferencePage.this.updateColumnSizes((TableViewer)this.getViewer());
            return true;
        }

        private int getStartIndex(GroupData gd, BaseData[] sel) {
            int i = 0;
            while (i < sel.length) {
                BaseData ed = sel[i];
                int index = gd.getIndexOf(ed.getId());
                if (index != -1) {
                    return index;
                }
                ++i;
            }
            return -1;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return ExtensionDataTransfer.getInstance().isSupportedType(transferType);
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof RootPage) {
                return ((RootPage)obj).name;
            }
            if (obj instanceof ExtensionData) {
                ExtensionData ed = (ExtensionData)obj;
                String name = ed.getName();
                if (name != null && name.length() > 0) {
                    return name;
                }
                return ed.getId();
            }
            if (obj instanceof SeparatorData) {
                return Messages.WelcomeCustomizationPreferencePage_horizontalSeparator;
            }
            if (obj instanceof IntroTheme) {
                IntroTheme bg = (IntroTheme)obj;
                return bg.getName();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof ExtensionData) {
                ExtensionData ed = (ExtensionData)obj;
                switch (ed.getImportance()) {
                    case 3: {
                        return WelcomeCustomizationPreferencePage.this.ihighImage;
                    }
                    case 1: {
                        return WelcomeCustomizationPreferencePage.this.ilowImage;
                    }
                    case 4: {
                        return WelcomeCustomizationPreferencePage.this.inewImage;
                    }
                    case 0: {
                        return WelcomeCustomizationPreferencePage.this.icalloutImage;
                    }
                }
                return WelcomeCustomizationPreferencePage.this.extensionImage;
            }
            if (obj instanceof IntroTheme) {
                return WelcomeCustomizationPreferencePage.this.themeImage;
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1 || element instanceof IntroTheme || element instanceof RootPage) {
                return this.getText(element);
            }
            return null;
        }
    }

    class IntroTheme {
        IConfigurationElement element;
        Image previewImage;

        public String getName() {
            return this.element.getAttribute("name");
        }

        public String getId() {
            return this.element.getAttribute("id");
        }

        public IntroTheme(IConfigurationElement element) {
            this.element = element;
        }

        public Image getPreviewImage() {
            String bid;
            Bundle bundle;
            String path;
            if (this.previewImage == null && (path = this.element.getAttribute("previewImage")) != null && (bundle = Platform.getBundle((String)(bid = this.element.getDeclaringExtension().getNamespaceIdentifier()))) != null) {
                ImageDescriptor desc = ImageUtil.createImageDescriptor(bundle, path);
                this.previewImage = desc.createImage();
            }
            return this.previewImage;
        }

        public void dispose() {
            if (this.previewImage != null) {
                this.previewImage.dispose();
                this.previewImage = null;
            }
        }
    }
}

