/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class NavigatorPipelineService
implements INavigatorPipelineService {
    private NavigatorContentService contentService;

    public NavigatorPipelineService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        return null;
    }

    PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        HashSet overrideableExtensions = new HashSet();
        Iterator iter = aRefreshSynchronization.getRefreshTargets().iterator();
        while (iter.hasNext()) {
            overrideableExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(iter.next()));
        }
        if (overrideableExtensions.isEmpty()) {
            return false;
        }
        return this.pipelineRefresh(overrideableExtensions, aRefreshSynchronization);
    }

    private boolean pipelineRefresh(Set overrideableExtensions, PipelinedViewerUpdate aRefreshSynchronization) {
        boolean intercepted = false;
        Iterator extensionsItr = overrideableExtensions.iterator();
        while (extensionsItr.hasNext()) {
            NavigatorContentExtension extension = (NavigatorContentExtension)extensionsItr.next();
            if (!(extension.getContentProvider() instanceof IPipelinedTreeContentProvider)) continue;
            if (!extension.getDescriptor().hasOverridingExtensions()) {
                intercepted |= ((IPipelinedTreeContentProvider)extension.getContentProvider()).interceptRefresh(aRefreshSynchronization);
                continue;
            }
            HashSet<NavigatorContentExtension> nextLevelOfOverrideableExtensions = new HashSet<NavigatorContentExtension>();
            Iterator refreshTargetsItr = aRefreshSynchronization.getRefreshTargets().iterator();
            while (refreshTargetsItr.hasNext()) {
                nextLevelOfOverrideableExtensions.addAll(Arrays.asList(extension.getOverridingExtensionsForPossibleChild(refreshTargetsItr.next())));
            }
            if (nextLevelOfOverrideableExtensions.isEmpty()) continue;
            intercepted |= this.pipelineRefresh(nextLevelOfOverrideableExtensions, aRefreshSynchronization);
        }
        return intercepted;
    }

    public PipelinedViewerUpdate interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return null;
    }
}

