/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.progress.UIJob;

public class StructuredViewerManager {
    private Viewer viewer;
    private Object cachedOldInput;
    private Object cachedNewInput;
    private UIJob refreshJob = new UIJob(CommonNavigatorMessages.StructuredViewerManager_0){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (StructuredViewerManager.this.viewer != null) {
                try {
                    if (StructuredViewerManager.this.viewer.getControl().isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    Display display = StructuredViewerManager.this.viewer.getControl().getDisplay();
                    if (!display.isDisposed() && StructuredViewerManager.this.viewer != null) {
                        StructuredViewerManager.this.viewer.refresh();
                    }
                }
                catch (RuntimeException e) {
                    NavigatorPlugin.logError(0, e.toString(), e);
                }
            }
            return Status.OK_STATUS;
        }
    };

    public StructuredViewerManager(Viewer aViewer) {
        this.viewer = aViewer;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Object anOldInput, Object aNewInput) {
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public boolean initialize(IStructuredContentProvider aContentProvider) {
        boolean result = true;
        try {
            if (aContentProvider != null) {
                aContentProvider.inputChanged(this.viewer, this.cachedOldInput, this.cachedNewInput);
            }
        }
        catch (RuntimeException e) {
            NavigatorPlugin.logError(0, e.toString(), e);
            result = false;
        }
        return result;
    }

    public void safeRefresh() {
        this.refreshJob.schedule(10L);
    }
}

