/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonDragAdapter;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class CommonViewer
extends TreeViewer {
    private final NavigatorContentService contentService;

    protected void init() {
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)this.contentService.createCommonContentProvider());
        DecoratingLabelProvider decoratingProvider = new DecoratingLabelProvider(this.contentService.createCommonLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        this.setLabelProvider((IBaseLabelProvider)decoratingProvider);
        this.initDragAndDrop();
    }

    protected void removeWithoutRefresh(Object[] elements) {
        super.remove(elements);
    }

    protected void initDragAndDrop() {
        int operations = 3;
        CommonDragAdapter dragAdapter = new CommonDragAdapter(this.contentService, (ISelectionProvider)this);
        this.addDragSupport(operations, dragAdapter.getSupportedDragTransfers(), (DragSourceListener)dragAdapter);
        CommonDropAdapter dropAdapter = new CommonDropAdapter(this.contentService, (StructuredViewer)this);
        this.addDropSupport(operations, dropAdapter.getSupportedDropTransfers(), (DropTargetListener)dropAdapter);
    }

    protected void createTreeItem(Widget parent, Object element, int index) {
        try {
            super.createTreeItem(parent, element, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] changed = event.getElements();
        if (changed != null) {
            ArrayList<Object> others = new ArrayList<Object>();
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                others.add(curr);
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.dispose();
    }

    protected void setSelectionToWidget(List v, boolean reveal) {
        if (v == null) {
            this.setSelection(new ArrayList(0));
            return;
        }
        int size = v.size();
        ArrayList<Widget> newSelection = new ArrayList<Widget>(size);
        int i = 0;
        while (i < size) {
            Widget w = this.internalExpand(v.get(i), reveal);
            if (w instanceof Item) {
                newSelection.add(w);
            }
            ++i;
        }
        this.setSelection(newSelection);
    }

    public CommonViewer(String aViewerId, Composite aParent, int aStyle) {
        super(aParent, aStyle);
        this.contentService = new NavigatorContentService(aViewerId, (StructuredViewer)this);
        this.init();
    }

    public void dispose() {
        if (this.contentService != null) {
            this.contentService.dispose();
        }
    }

    public void setSorter(ViewerSorter sorter) {
        if (sorter != null && sorter instanceof CommonViewerSorter) {
            ((CommonViewerSorter)sorter).setContentService(this.contentService);
        }
        super.setSorter(sorter);
    }

    public INavigatorContentService getNavigatorContentService() {
        return this.contentService;
    }

    public void add(Object parentElement, Object[] childElements) {
        super.add(parentElement, childElements);
    }

    public void remove(Object[] elements) {
        super.remove(elements);
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        int i = 0;
        while (i < elements.length) {
            super.internalRefresh(contentProvider.getParent(elements[i]));
            ++i;
        }
    }

    public void refresh(Object element, boolean updateLabels) {
        INavigatorPipelineService pipeDream = this.contentService.getPipelineService();
        PipelinedViewerUpdate update = new PipelinedViewerUpdate();
        update.getRefreshTargets().add(element);
        update.setUpdateLabels(updateLabels);
        if (pipeDream.interceptRefresh(update)) {
            boolean toUpdateLabels = update.isUpdateLabels();
            Iterator iter = update.getRefreshTargets().iterator();
            while (iter.hasNext()) {
                super.refresh(iter.next(), toUpdateLabels);
            }
        } else {
            super.refresh(element, updateLabels);
        }
    }

    public void refresh(Object element) {
        this.refresh(element, true);
    }

    public void update(Object element, String[] properties) {
        super.update(element, properties);
    }

    public String toString() {
        return String.valueOf(this.contentService.toString()) + " Viewer";
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (element == null && this.getRoot() == null) {
            return;
        }
        super.internalRefresh(element, updateLabels);
    }
}

