/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.databinding.internal.beans.ListenerSupport;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservableCollection;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.MappingDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.ObservableMultiMappingWithDomain;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Policy;

public class JavaBeanObservableMultiMapping
extends ObservableMultiMappingWithDomain {
    private final PropertyDescriptor[] propertyDescriptors;
    private PropertyChangeListener elementListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeanObservableMultiMapping.this.updating) {
                int i = 0;
                while (i < JavaBeanObservableMultiMapping.this.propertyDescriptors.length) {
                    if (JavaBeanObservableMultiMapping.this.propertyDescriptors[i].getName().equals(event.getPropertyName())) {
                        int[] indices = new int[]{i};
                        Set<Object> elements = Collections.singleton(event.getSource());
                        JavaBeanObservableMultiMapping.this.fireMappingValueChange(new MappingDiff(this, elements, indices, event){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Set val$elements;
                            private final /* synthetic */ int[] val$indices;
                            private final /* synthetic */ PropertyChangeEvent val$event;
                            {
                                this.this$1 = var1_1;
                                this.val$elements = set;
                                this.val$indices = nArray;
                                this.val$event = propertyChangeEvent;
                            }

                            public Set getElements() {
                                return this.val$elements;
                            }

                            public int[] getAffectedIndices() {
                                return this.val$indices;
                            }

                            public Object[] getOldMappingValues(Object element, int[] indices) {
                                return new Object[]{this.val$event.getOldValue()};
                            }

                            public Object[] getNewMappingValues(Object element, int[] indices) {
                                return new Object[]{this.val$event.getNewValue()};
                            }
                        });
                    }
                    ++i;
                }
            }
        }
    };
    private ListenerSupport listenerSupport = new ListenerSupport(this.elementListener);
    private boolean updating = false;

    public JavaBeanObservableMultiMapping(IObservableCollection domain, PropertyDescriptor[] propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
        int i = 0;
        while (i < propertyDescriptors.length) {
            Assert.isTrue((propertyDescriptors[i] != null ? 1 : 0) != 0);
            ++i;
        }
        this.initDomain(domain);
    }

    protected void addListenerTo(Object domainElement) {
        this.listenerSupport.hookListener(domainElement);
    }

    protected void removeListenerFrom(Object domainElement) {
        this.listenerSupport.unhookListener(domainElement);
    }

    private Object doGetMappingValue(Object element, PropertyDescriptor propertyDescriptor) {
        try {
            return propertyDescriptor.getReadMethod().invoke(element, new Object[0]);
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 4, "cannot get value", (Throwable)e));
            return null;
        }
    }

    public void setMappingValues(Object element, int[] indices, Object[] values) {
        int i = 0;
        while (i < indices.length) {
            this.setMappingValue(element, this.propertyDescriptors[indices[i]], values[i]);
            ++i;
        }
    }

    private void setMappingValue(Object element, PropertyDescriptor propertyDescriptor, Object value) {
        try {
            propertyDescriptor.getWriteMethod().invoke(element, value);
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 4, "cannot set value", (Throwable)e));
        }
    }

    protected Object[] doGetMappingValues(Object element, int[] indices) {
        Object[] result = new Object[indices.length];
        int i = 0;
        while (i < result.length) {
            result[i] = indices[i] < this.propertyDescriptors.length ? this.doGetMappingValue(element, this.propertyDescriptors[indices[i]]) : null;
            ++i;
        }
        return result;
    }

    public Object[] getValueTypes() {
        Object[] result = new Class[this.propertyDescriptors.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.propertyDescriptors[i].getPropertyType();
            ++i;
        }
        return result;
    }
}

