/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractVetoableValue;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextObservableValue
extends AbstractVetoableValue {
    private final Text text;
    private boolean updating = false;
    private int updatePolicy;
    private String bufferedValue;
    private Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            if (!TextObservableValue.this.updating) {
                String oldValue = TextObservableValue.this.bufferedValue;
                String newValue = TextObservableValue.this.text.getText();
                if (TextObservableValue.this.updatePolicy == 16) {
                    TextObservableValue.this.bufferedValue = TextObservableValue.this.text.getText();
                    if (!oldValue.equals(newValue)) {
                        TextObservableValue.this.fireValueChange(Diffs.createValueDiff(oldValue, newValue));
                    }
                } else {
                    TextObservableValue.this.fireValueChange(Diffs.createValueDiff(oldValue, TextObservableValue.this.text.getText()));
                }
            }
        }
    };
    private VerifyListener verifyListener;
    private KeyListener keyListener;
    static /* synthetic */ Class class$0;

    public TextObservableValue(final Text text, int updatePolicy) {
        this.text = text;
        this.updatePolicy = updatePolicy;
        if (updatePolicy != 0) {
            text.addListener(updatePolicy, this.updateListener);
        }
        if (updatePolicy == 24) {
            text.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    if (!TextObservableValue.this.updating) {
                        TextObservableValue.this.bufferedValue = text.getText();
                    }
                }
            });
        }
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String newText;
                String currentText;
                if (!TextObservableValue.this.updating && !TextObservableValue.this.fireValueChanging(Diffs.createValueDiff(currentText = TextObservableValue.this.text.getText(), newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end)))) {
                    e.doit = false;
                }
            }
        };
        text.addVerifyListener(this.verifyListener);
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b' && TextObservableValue.this.bufferedValue != null) {
                    text.setText(TextObservableValue.this.bufferedValue);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        text.addKeyListener(this.keyListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSetValue(Object value) {
        try {
            this.updating = true;
            this.bufferedValue = (String)value;
            this.text.setText(value == null ? "" : value.toString());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updating = false;
            return;
        }
    }

    public Object doGetValue() {
        return this.text.getText();
    }

    public Object getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void dispose() {
        if (!this.text.isDisposed()) {
            if (this.updatePolicy != 0) {
                this.text.removeListener(this.updatePolicy, this.updateListener);
            }
            this.text.removeVerifyListener(this.verifyListener);
        }
        super.dispose();
    }
}

