/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.viewers;

import org.eclipse.jface.internal.databinding.internal.viewers.StructuredViewerObservableCollectionWithLabels;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMultiMapping;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class AbstractListViewerObservableCollectionWithLabels
extends StructuredViewerObservableCollectionWithLabels {
    private LabelProvider labelProvider = new LabelProvider();
    private IMultiMapping labelMapping;

    public AbstractListViewerObservableCollectionWithLabels(AbstractListViewer abstractListViewer) {
        super((StructuredViewer)abstractListViewer);
    }

    public void init(IMultiMapping labelMapping) {
        this.labelMapping = labelMapping;
        this.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    public void updateElements(Object[] elements) {
        this.labelProvider.fireLabelsChanged(elements);
    }

    public void dispose() {
        super.dispose();
        this.labelProvider = null;
        this.labelMapping = null;
    }

    protected void addToViewer(Object element) {
        ((AbstractListViewer)this.getViewer()).add(element);
    }

    protected void addToViewer(Object[] elements) {
        ((AbstractListViewer)this.getViewer()).add(elements);
    }

    protected void removeFromViewer(Object element) {
        ((AbstractListViewer)this.getViewer()).remove(element);
    }

    protected void removeFromViewer(Object[] elements) {
        ((AbstractListViewer)this.getViewer()).remove(elements);
    }

    protected void addToViewer(int index, Object element) {
        this.getViewer().refresh();
    }

    private class LabelProvider
    implements IViewerLabelProvider,
    ILabelProvider {
        ListenerList listeners = new ListenerList();

        private LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void dispose() {
            this.listeners.clear();
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        private void fireLabelsChanged(Object[] elements) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, elements);
            Object[] listenerArray = this.listeners.getListeners();
            int i = 0;
            while (i < listenerArray.length) {
                ILabelProviderListener listener = (ILabelProviderListener)listenerArray[i];
                listener.labelProviderChanged(event);
                ++i;
            }
        }

        public void updateLabel(ViewerLabel label, Object element) {
            Object mapping = AbstractListViewerObservableCollectionWithLabels.this.labelMapping.getMappingValues(element, new int[1])[0];
            if (mapping instanceof ViewerLabel) {
                ViewerLabel viewerLabel = (ViewerLabel)mapping;
                label.setBackground(viewerLabel.getBackground());
                label.setForeground(viewerLabel.getForeground());
                label.setFont(viewerLabel.getFont());
                label.setImage(viewerLabel.getImage());
                label.setText(viewerLabel.getText());
            } else if (mapping != null) {
                label.setText(mapping.toString());
            }
        }

        public Image getImage(Object element) {
            Object mapping = AbstractListViewerObservableCollectionWithLabels.this.labelMapping.getMappingValues(element, new int[1])[0];
            if (mapping instanceof ViewerLabel) {
                ViewerLabel viewerLabel = (ViewerLabel)mapping;
                return viewerLabel.getImage();
            }
            return null;
        }

        public String getText(Object element) {
            Object mapping = AbstractListViewerObservableCollectionWithLabels.this.labelMapping.getMappingValues(element, new int[1])[0];
            if (mapping instanceof ViewerLabel) {
                ViewerLabel viewerLabel = (ViewerLabel)mapping;
                return viewerLabel.getText();
            }
            if (mapping != null) {
                return mapping.toString();
            }
            return "";
        }
    }
}

