/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.viewers;

import org.eclipse.jface.internal.databinding.internal.viewers.StructuredViewerObservableCollectionWithLabels;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMultiMapping;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TableViewerObservableCollectionWithLabels
extends StructuredViewerObservableCollectionWithLabels {
    private TabelLabelProvider labelProvider = new TabelLabelProvider();
    private IMultiMapping labelMapping;

    public TableViewerObservableCollectionWithLabels(TableViewer tableViewer) {
        super((StructuredViewer)tableViewer);
    }

    public void init(IMultiMapping labelMapping) {
        this.labelMapping = labelMapping;
        this.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    public void updateElements(Object[] elements) {
        this.labelProvider.fireLabelsChanged(elements);
    }

    public void dispose() {
        super.dispose();
        this.labelProvider = null;
        this.labelMapping = null;
    }

    protected void addToViewer(Object element) {
        ((TableViewer)this.getViewer()).add(element);
    }

    protected void addToViewer(Object[] elements) {
        ((TableViewer)this.getViewer()).add(elements);
    }

    protected void removeFromViewer(Object element) {
        ((TableViewer)this.getViewer()).remove(element);
    }

    protected void removeFromViewer(Object[] elements) {
        ((TableViewer)this.getViewer()).remove(elements);
    }

    protected void addToViewer(int index, Object element) {
        ((TableViewer)this.getViewer()).insert(element, index);
    }

    private class TabelLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        ListenerList listeners = new ListenerList();

        private TabelLabelProvider() {
        }

        private Object getColumnValue(Object element, int columnIndex) {
            return TableViewerObservableCollectionWithLabels.this.labelMapping.getMappingValues(element, new int[]{columnIndex})[0];
        }

        private ViewerLabel getColumnValueAsViewerLabel(Object element, int columnIndex) {
            Object columnValue = this.getColumnValue(element, columnIndex);
            if (columnValue instanceof ViewerLabel) {
                return (ViewerLabel)columnValue;
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ViewerLabel columnValue = this.getColumnValueAsViewerLabel(element, columnIndex);
            return columnValue == null ? null : columnValue.getImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            Object columnValue = this.getColumnValue(element, columnIndex);
            if (columnValue instanceof ViewerLabel) {
                return ((ViewerLabel)columnValue).getText();
            }
            if (columnValue != null) {
                return columnValue.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void dispose() {
            this.listeners.clear();
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        private void fireLabelsChanged(Object[] elements) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, elements);
            Object[] listenerArray = this.listeners.getListeners();
            int i = 0;
            while (i < listenerArray.length) {
                ILabelProviderListener listener = (ILabelProviderListener)listenerArray[i];
                listener.labelProviderChanged(event);
                ++i;
            }
        }

        public Color getForeground(Object element, int columnIndex) {
            ViewerLabel columnValue = this.getColumnValueAsViewerLabel(element, columnIndex);
            return columnValue == null ? null : columnValue.getForeground();
        }

        public Color getBackground(Object element, int columnIndex) {
            ViewerLabel columnValue = this.getColumnValueAsViewerLabel(element, columnIndex);
            return columnValue == null ? null : columnValue.getBackground();
        }

        public Font getFont(Object element, int columnIndex) {
            ViewerLabel columnValue = this.getColumnValueAsViewerLabel(element, columnIndex);
            return columnValue == null ? null : columnValue.getFont();
        }
    }
}

