/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional;

import org.eclipse.jface.internal.databinding.provisional.conversion.IConverter;
import org.eclipse.jface.internal.databinding.provisional.validation.IDomainValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;

public class BindSpec {
    private IConverter modelToTargetConverter;
    private IConverter targetToModelConverter;
    private IValidator targetValidator;
    private IDomainValidator domainValidator;
    private Integer modelUpdatePolicy;
    private Integer validatePolicy;
    private Integer targetUpdatePolicy;
    private boolean updateModel = true;
    private boolean updateTarget = true;

    public BindSpec(IConverter modelToTargetConverter, IConverter targetToModelConverter, IValidator targetValidator, IDomainValidator domainValidator, Integer modelUpdatePolicy, Integer validatePolicy, Integer targetUpdatePolicy) {
        this.modelToTargetConverter = modelToTargetConverter;
        this.targetToModelConverter = targetToModelConverter;
        this.targetValidator = targetValidator;
        this.domainValidator = domainValidator;
        this.modelUpdatePolicy = modelUpdatePolicy;
        this.validatePolicy = validatePolicy;
        this.targetUpdatePolicy = targetUpdatePolicy;
    }

    public BindSpec(IConverter modelToTargetConverter, IConverter targetToModelConverter, IValidator targetValidator, IDomainValidator domainValidator) {
        this(modelToTargetConverter, targetToModelConverter, targetValidator, domainValidator, null, null, null);
    }

    public BindSpec() {
        this(null, null, null, null, null, null, null);
    }

    public IConverter getModelToTargetConverter() {
        return this.modelToTargetConverter;
    }

    public IConverter getTargetToModelConverter() {
        return this.targetToModelConverter;
    }

    public IValidator getTypeConversionValidator() {
        return this.targetValidator;
    }

    public IDomainValidator getDomainValidator() {
        return this.domainValidator;
    }

    public Integer getModelUpdatePolicy() {
        return this.modelUpdatePolicy;
    }

    public Integer getValidatePolicy() {
        return this.validatePolicy;
    }

    public Integer getTargetUpdatePolicy() {
        return this.targetUpdatePolicy;
    }

    public BindSpec setModelToTargetConverter(IConverter converter) {
        this.modelToTargetConverter = converter;
        return this;
    }

    public BindSpec setTargetToModelConverter(IConverter converter) {
        this.targetToModelConverter = converter;
        return this;
    }

    public BindSpec setValidator(IValidator validator) {
        this.targetValidator = validator;
        return this;
    }

    public BindSpec setDomainValidator(IDomainValidator validator) {
        this.domainValidator = validator;
        return this;
    }

    public boolean updateModel() {
        return this.updateModel;
    }

    public boolean updateTarget() {
        return this.updateTarget;
    }

    public BindSpec setUpdateModel(boolean updateModel) {
        this.updateModel = updateModel;
        return this;
    }

    public BindSpec setUpdateTarget(boolean updateTarget) {
        this.updateTarget = updateTarget;
        return this;
    }

    public BindSpec setModelUpdatePolicy(Integer modelUpdatePolicy) {
        this.modelUpdatePolicy = modelUpdatePolicy;
        return this;
    }

    public BindSpec setTargetUpdatePolicy(Integer targetUpdatePolicy) {
        this.targetUpdatePolicy = targetUpdatePolicy;
        return this;
    }

    public BindSpec setValidatePolicy(Integer validatePolicy) {
        this.validatePolicy = validatePolicy;
        return this;
    }
}

