/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.factories;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.internal.databinding.internal.ClassLookupSupport;
import org.eclipse.jface.internal.databinding.internal.Pair;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.conversion.IConverter;
import org.eclipse.jface.internal.databinding.provisional.conversion.IdentityConverter;
import org.eclipse.jface.internal.databinding.provisional.factories.BindSupportFactory;
import org.eclipse.jface.internal.databinding.provisional.validation.IDomainValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ReadOnlyValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2BigDecimalValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2ByteValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2DateValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2DoubleValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2FloatValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2IntValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2LongValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2ShortValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public final class DefaultBindSupportFactory
extends BindSupportFactory {
    private ValidatorRegistry validatorRegistry = new ValidatorRegistry();
    private Map converterMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public IValidator createValidator(Object fromType, Object toType) {
        if (fromType == null || toType == null) {
            return new IValidator(){

                public ValidationError isPartiallyValid(Object value) {
                    return null;
                }

                public ValidationError isValid(Object value) {
                    return null;
                }
            };
        }
        IValidator dataTypeValidator = this.findValidator(fromType, toType);
        if (dataTypeValidator == null) {
            throw new BindingException("No IValidator is registered for conversions from " + fromType + " to " + toType);
        }
        return dataTypeValidator;
    }

    private IValidator findValidator(Object fromType, Object toType) {
        return this.validatorRegistry.get(fromType, toType);
    }

    public IConverter createConverter(Object fromType, Object toType) {
        Class fromClass;
        if (!(fromType instanceof Class) || !(toType instanceof Class)) {
            return null;
        }
        Class toClass = (Class)toType;
        if (toClass.isPrimitive()) {
            toClass = this.autoboxed(toClass);
        }
        if ((fromClass = (Class)fromType).isPrimitive()) {
            fromClass = this.autoboxed(fromClass);
        }
        if (toClass.isAssignableFrom(fromClass)) {
            return new IdentityConverter(fromClass, toClass);
        }
        Map converterMap = this.getConverterMap();
        Class[] supertypeHierarchyFlattened = ClassLookupSupport.getTypeHierarchyFlattened(fromClass);
        int i = 0;
        while (i < supertypeHierarchyFlattened.length) {
            Class currentFromClass = supertypeHierarchyFlattened[i];
            if (currentFromClass == toType) {
                return new IdentityConverter(fromClass, toClass);
            }
            Pair key = new Pair(currentFromClass.getName(), toClass.getName());
            Object converterOrClassname = converterMap.get(key);
            if (converterOrClassname instanceof IConverter) {
                return (IConverter)converterOrClassname;
            }
            if (converterOrClassname instanceof String) {
                String classname = (String)converterOrClassname;
                try {
                    Class<?> converterClass = Class.forName(classname);
                    IConverter result = (IConverter)converterClass.newInstance();
                    converterMap.put(key, result);
                    return result;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (fromClass.isAssignableFrom(toClass)) {
            return new IdentityConverter(fromClass, toClass);
        }
        return null;
    }

    private Map getConverterMap() {
        if (this.converterMap == null) {
            this.converterMap = new HashMap();
            this.converterMap.put(new Pair("java.util.Date", "java.lang.String"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertDate2String");
            this.converterMap.put(new Pair("java.lang.String", "java.math.BigDecimal"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2BigDecimal");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Boolean"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Boolean");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Byte"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Byte");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Character"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Character");
            this.converterMap.put(new Pair("java.lang.String", "java.util.Date"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Date");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Double"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Double");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Float"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Float");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Integer"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Integer");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Long"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Long");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Short"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Short");
            this.converterMap.put(new Pair("java.lang.Object", "java.lang.String"), "org.eclipse.jface.internal.databinding.provisional.conversion.ToStringConverter");
        }
        return this.converterMap;
    }

    public IDomainValidator createDomainValidator(Object modelType) {
        return new IDomainValidator(){

            public ValidationError isValid(Object value) {
                return null;
            }
        };
    }

    public Boolean isAssignableFromTo(Object fromType, Object toType) {
        if (fromType instanceof Class && toType instanceof Class) {
            Class fromClass;
            Class toClass = (Class)toType;
            if (toClass.isPrimitive()) {
                toClass = this.autoboxed(toClass);
            }
            if ((fromClass = (Class)fromType).isPrimitive()) {
                fromClass = this.autoboxed(fromClass);
            }
            return new Boolean(toClass.isAssignableFrom(fromClass));
        }
        return null;
    }

    private Class autoboxed(Class clazz) {
        if (clazz == Float.TYPE) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz2;
        }
        if (clazz == Double.TYPE) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz3;
        }
        if (clazz == Short.TYPE) {
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz4;
        }
        if (clazz == Integer.TYPE) {
            Class<?> clazz5 = class$3;
            if (clazz5 == null) {
                try {
                    clazz5 = class$3 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz5;
        }
        if (clazz == Long.TYPE) {
            Class<?> clazz6 = class$4;
            if (clazz6 == null) {
                try {
                    clazz6 = class$4 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz6;
        }
        if (clazz == Boolean.TYPE) {
            Class<?> clazz7 = class$5;
            if (clazz7 == null) {
                try {
                    clazz7 = class$5 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz7;
        }
        return clazz;
    }

    private static class ValidatorRegistry {
        private HashMap validators = new HashMap();
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;
        static /* synthetic */ Class class$8;

        private void associate(Object fromClass, Object toClass, IValidator validator) {
            this.validators.put(new Pair(fromClass, toClass), validator);
        }

        private IValidator get(Object fromClass, Object toClass) {
            IValidator result = (IValidator)this.validators.get(new Pair(fromClass, toClass));
            if (result != null) {
                return result;
            }
            if (fromClass != null && toClass != null && fromClass == toClass) {
                return new IValidator(this){
                    final /* synthetic */ ValidatorRegistry this$1;
                    {
                        this.this$1 = validatorRegistry;
                    }

                    public ValidationError isPartiallyValid(Object value) {
                        return null;
                    }

                    public ValidationError isValid(Object value) {
                        return null;
                    }
                };
            }
            return ReadOnlyValidator.getDefault();
        }

        private ValidatorRegistry() {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            Class<?> clazz8;
            Class<?> clazz9 = class$0;
            if (clazz9 == null) {
                try {
                    clazz9 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz9, Integer.TYPE, new String2IntValidator());
            Class<?> clazz10 = class$0;
            if (clazz10 == null) {
                try {
                    clazz10 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz10, Byte.TYPE, new String2ByteValidator());
            Class<?> clazz11 = class$0;
            if (clazz11 == null) {
                try {
                    clazz11 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz11, Short.TYPE, new String2ShortValidator());
            Class<?> clazz12 = class$0;
            if (clazz12 == null) {
                try {
                    clazz12 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz12, Long.TYPE, new String2LongValidator());
            Class<?> clazz13 = class$0;
            if (clazz13 == null) {
                try {
                    clazz13 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz13, Float.TYPE, new String2FloatValidator());
            Class<?> clazz14 = class$0;
            if (clazz14 == null) {
                try {
                    clazz14 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz14, Double.TYPE, new String2DoubleValidator());
            Class<?> clazz15 = class$0;
            if (clazz15 == null) {
                try {
                    clazz15 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz8 = class$1) == null) {
                try {
                    clazz8 = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz15, clazz8, new String2IntValidator());
            Class<?> clazz16 = class$0;
            if (clazz16 == null) {
                try {
                    clazz16 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz7 = class$2) == null) {
                try {
                    clazz7 = class$2 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz16, clazz7, new String2ByteValidator());
            Class<?> clazz17 = class$0;
            if (clazz17 == null) {
                try {
                    clazz17 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz6 = class$3) == null) {
                try {
                    clazz6 = class$3 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz17, clazz6, new String2ShortValidator());
            Class<?> clazz18 = class$0;
            if (clazz18 == null) {
                try {
                    clazz18 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz5 = class$4) == null) {
                try {
                    clazz5 = class$4 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz18, clazz5, new String2LongValidator());
            Class<?> clazz19 = class$0;
            if (clazz19 == null) {
                try {
                    clazz19 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz4 = class$5) == null) {
                try {
                    clazz4 = class$5 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz19, clazz4, new String2FloatValidator());
            Class<?> clazz20 = class$0;
            if (clazz20 == null) {
                try {
                    clazz20 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz3 = class$6) == null) {
                try {
                    clazz3 = class$6 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz20, clazz3, new String2DoubleValidator());
            Class<?> clazz21 = class$0;
            if (clazz21 == null) {
                try {
                    clazz21 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz2 = class$7) == null) {
                try {
                    clazz2 = class$7 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz21, clazz2, new String2DateValidator());
            Class<?> clazz22 = class$0;
            if (clazz22 == null) {
                try {
                    clazz22 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$8) == null) {
                try {
                    clazz = class$8 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associate(clazz22, clazz, new String2BigDecimalValidator());
        }
    }
}

