/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.set;

import java.util.HashSet;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ObservableSet;

public class ListToSetAdapter
extends ObservableSet {
    private final IObservableList list;
    private IListChangeListener listener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
            HashSet<Object> added = new HashSet<Object>();
            HashSet<Object> removed = new HashSet<Object>();
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                ListDiffEntry entry = differences[i];
                Object element = entry.getElement();
                if (entry.isAddition()) {
                    if (ListToSetAdapter.this.wrappedSet.add(element) && !removed.remove(element)) {
                        added.add(element);
                    }
                } else if (ListToSetAdapter.this.wrappedSet.remove(element)) {
                    removed.add(element);
                    added.remove(element);
                }
                ++i;
            }
            ListToSetAdapter.this.fireSetChange(Diffs.createSetDiff(added, removed));
        }
    };

    public ListToSetAdapter(IObservableList list) {
        super(new HashSet(), list.getElementType());
        this.list = list;
        this.wrappedSet.addAll(list);
        this.list.addListChangeListener(this.listener);
    }

    public void dispose() {
        super.dispose();
        if (this.list != null && this.listener != null) {
            this.list.removeListChangeListener(this.listener);
            this.listener = null;
        }
    }
}

