/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroInclude;
import org.eclipse.ui.internal.intro.impl.model.IntroInjectedIFrame;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractIntroPage
extends AbstractIntroContainer {
    protected static final String TAG_PAGE = "page";
    private static final String ATT_STYLE = "style";
    private static final String ATT_ALT_STYLE = "alt-style";
    private static final String ATT_CONTENT = "content";
    private static final String ATT_SHARED_STYLE = "shared-style";
    private static final String INVALID_CONTENT = "invalidPage/invalidPage.xhtml";
    private static final String INVALID_CONTENT_BASE = "invalidPage";
    private String style;
    private String altStyle;
    private String sharedStyle;
    private IntroPageTitle title;
    private String content;
    private IntroInjectedIFrame iframe;
    private String originalId;
    private Document dom;
    private boolean isXHTMLPage;
    private String initialBase;
    private Vector styles;
    private Hashtable altStyles;

    AbstractIntroPage(Element element, Bundle bundle, String base) {
        super(element, bundle, base);
        this.initialBase = base;
        this.content = this.getAttribute(element, ATT_CONTENT);
        if (this.content != null) {
            IPath subBase = ModelUtil.getParentFolderPath(this.content);
            this.base = new Path(base).append(subBase).toString();
            this.content = BundleUtil.getResolvedResourceLocation(base, this.content, bundle);
        }
        this.sharedStyle = this.getAttribute(element, ATT_SHARED_STYLE);
        if (this.sharedStyle == null) {
            this.sharedStyle = "true";
        }
    }

    public void setParent(AbstractIntroElement parent) {
        super.setParent(parent);
        if (this.content == null) {
            this.init(this.element, this.getBundle(), this.initialBase);
        }
    }

    public String getRawContent() {
        return this.getAttribute(this.element, ATT_CONTENT);
    }

    private void init(Element element, Bundle bundle, String base) {
        String[] altStyleValues;
        String[] styleValues = this.getAttributeList(element, ATT_STYLE);
        if (styleValues != null && styleValues.length > 0) {
            this.style = styleValues[0];
            this.style = BundleUtil.getResolvedResourceLocation(base, this.style, bundle);
            int i = 1;
            while (i < styleValues.length) {
                String style = styleValues[i];
                style = BundleUtil.getResolvedResourceLocation(base, style, bundle);
                this.addStyle(style);
                ++i;
            }
        }
        if ((altStyleValues = this.getAttributeList(element, ATT_ALT_STYLE)) != null && altStyleValues.length > 0) {
            this.altStyle = altStyleValues[0];
            this.altStyle = BundleUtil.getResolvedResourceLocation(base, this.altStyle, bundle);
            int i = 1;
            while (i < altStyleValues.length) {
                String style = altStyleValues[i];
                style = BundleUtil.getResolvedResourceLocation(base, style, bundle);
                this.addAltStyle(style, bundle);
                ++i;
            }
        }
    }

    public String getTitle() {
        IntroPageTitle[] titles;
        this.getChildren();
        if (this.title == null && (titles = (IntroPageTitle[])this.getChildrenOfType(4096)).length > 0) {
            this.title = titles[0];
        }
        if (this.title == null) {
            return null;
        }
        return this.title.getTitle();
    }

    public String getStyle() {
        return this.style;
    }

    public String getAltStyle() {
        return this.altStyle;
    }

    public String[] getStyles() {
        this.getChildren();
        if (this.styles == null) {
            return new String[0];
        }
        Object[] stylesArray = new String[this.styles.size()];
        this.styles.copyInto(stylesArray);
        return stylesArray;
    }

    public Hashtable getAltStyles() {
        this.getChildren();
        return this.altStyles;
    }

    protected void addStyle(String style) {
        if (!this.initStyles(style)) {
            return;
        }
        if (this.styles.contains(style)) {
            return;
        }
        this.styles.add(style);
    }

    public void insertStyle(String style, int location) {
        if (!this.initStyles(style)) {
            return;
        }
        if (this.styles.contains(style)) {
            return;
        }
        this.styles.add(location, style);
    }

    protected void addAltStyle(String altStyle, Bundle bundle) {
        if (!this.initAltStyles(altStyle)) {
            return;
        }
        if (this.altStyles.containsKey(altStyle)) {
            return;
        }
        this.altStyles.put(altStyle, bundle);
    }

    protected void addStyles(String[] styles) {
        if (styles == null) {
            return;
        }
        int i = 0;
        while (i < styles.length) {
            this.addStyle(styles[i]);
            ++i;
        }
    }

    protected void addAltStyles(Hashtable altStyles) {
        if (altStyles == null) {
            return;
        }
        if (this.altStyles == null) {
            this.altStyles = new Hashtable();
        }
        this.altStyles.putAll(altStyles);
    }

    private boolean initStyles(String style) {
        if (style == null) {
            return false;
        }
        if (this.styles == null) {
            this.styles = new Vector();
        }
        return true;
    }

    private boolean initAltStyles(String style) {
        if (style == null) {
            return false;
        }
        if (this.altStyles == null) {
            this.altStyles = new Hashtable();
        }
        return true;
    }

    public int getType() {
        return 12;
    }

    protected void resolveChildren() {
        if (this.isXHTMLPage) {
            this.resolvePage();
        } else {
            super.resolveChildren();
        }
    }

    protected AbstractIntroElement getModelChild(Element childElement, Bundle bundle, String base) {
        AbstractIntroElement child = null;
        if (childElement.getNodeName().equalsIgnoreCase("head")) {
            child = new IntroHead(childElement, bundle, base);
        } else if (childElement.getNodeName().equalsIgnoreCase("title") && this.title == null) {
            child = new IntroPageTitle(childElement, bundle);
        }
        if (child != null) {
            return child;
        }
        return super.getModelChild(childElement, bundle, base);
    }

    public IntroHead[] getHTMLHeads() {
        return (IntroHead[])this.getChildrenOfType(2048);
    }

    protected void loadChildren() {
        if (this.content == null) {
            super.loadChildren();
            return;
        }
        IntroContentParser parser = new IntroContentParser(this.content);
        Document dom = parser.getDocument();
        if (dom == null) {
            Bundle introBundle = Platform.getBundle((String)"org.eclipse.ui.intro");
            ModelUtil.extractParentFolder(introBundle, INVALID_CONTENT);
            String invalidContentFilePath = BundleUtil.getResolvedResourceLocation(INVALID_CONTENT, introBundle);
            parser = new IntroContentParser(invalidContentFilePath);
            dom = parser.getDocument();
            this.content = invalidContentFilePath;
            this.base = INVALID_CONTENT_BASE;
            this.setBundle(introBundle);
        }
        if (parser.hasXHTMLContent()) {
            this.loadXHTMLContent(dom);
            this.init(this.element, this.getBundle(), this.initialBase);
            super.loadChildren();
        } else {
            this.loadXMLContent(dom);
        }
    }

    private void loadXMLContent(Document dom) {
        Element[] pages = ModelUtil.getElementsByTagName(dom, TAG_PAGE);
        if (pages.length == 0) {
            Log.warning("Content file has no pages.");
            return;
        }
        boolean foundMatchingPage = false;
        int i = 0;
        while (i < pages.length) {
            Element pageElement = pages[i];
            if (pageElement.getAttribute("id").equals(this.getId())) {
                this.element = pageElement;
                this.init(pageElement, this.getBundle(), this.base);
                this.style_id = this.getAttribute(this.element, "style-id");
                this.filteredFrom = this.getAttribute(this.element, "filteredFrom");
                this.sharedStyle = this.getAttribute(this.element, ATT_SHARED_STYLE);
                if (this.sharedStyle == null) {
                    this.sharedStyle = "true";
                }
                foundMatchingPage = true;
            }
            ++i;
        }
        if (foundMatchingPage) {
            super.loadChildren();
        } else {
            this.children = new Vector();
            this.loaded = true;
            this.element = null;
            Log.warning("Content file does not have page with id= " + this.getId());
        }
    }

    private void loadXHTMLContent(Document dom) {
        this.dom = dom;
        this.isXHTMLPage = true;
        this.children = new Vector();
        this.loaded = true;
    }

    public Document getResolvedDocument() {
        this.getChildren();
        return this.dom;
    }

    public Document getDocument() {
        if (!this.loaded) {
            this.loadChildren();
        }
        return this.dom;
    }

    public boolean isXHTMLPage() {
        if (!this.loaded) {
            this.loadChildren();
        }
        return this.isXHTMLPage;
    }

    public Element findDomChild(String id, String localElementName) {
        if (!this.loaded) {
            this.loadChildren();
        }
        return ModelUtil.getElementById(this.dom, id, localElementName);
    }

    public Element findDomChild(String id) {
        return this.findDomChild(id, "*");
    }

    protected void resolvePage() {
        String[] styles;
        ModelUtil.insertBase(this.dom, ModelUtil.getParentFolderOSString(this.content));
        ModelUtil.updateResourceAttributes(this.dom.getDocumentElement(), this);
        IntroModelRoot modelRoot = (IntroModelRoot)this.getParent();
        IntroPartPresentation presentation = modelRoot.getPresentation();
        String[] stringArray = styles = presentation != null ? presentation.getImplementationStyles() : null;
        if (styles != null && this.injectSharedStyle()) {
            int i = 0;
            while (i < styles.length) {
                ModelUtil.insertStyle(this.dom, styles[i]);
                ++i;
            }
        }
        XHTMLSupport.getFilterProcessor().applyFilters(this.dom);
        this.resolveIncludes();
        ModelUtil.removeAllElements(this.dom, "anchor");
        this.resolved = true;
    }

    protected void resolveIncludes() {
        NodeList includes = this.dom.getElementsByTagNameNS("*", "include");
        Node[] nodes = ModelUtil.getArray(includes);
        int i = 0;
        while (i < nodes.length) {
            Element includeElement = (Element)nodes[i];
            IntroInclude include = new IntroInclude(includeElement, this.getBundle());
            Object[] results = this.findDOMIncludeTarget(include);
            Element targetElement = (Element)results[1];
            if (targetElement == null) {
                String message = "Could not resolve following include:  " + ModelLoaderUtil.getLogString(this.getBundle(), includeElement, "path");
                Log.warning(message);
                return;
            }
            Node targetNode = this.dom.importNode(targetElement, true);
            AbstractIntroPage page = (AbstractIntroPage)results[0];
            ModelUtil.updateResourceAttributes((Element)targetNode, page);
            includeElement.getParentNode().replaceChild(targetNode, includeElement);
            ++i;
        }
    }

    private Object[] findDOMIncludeTarget(IntroInclude include) {
        String path = include.getPath();
        IntroModelRoot targetModelRoot = (IntroModelRoot)this.getParentPage().getParent();
        String targetConfigID = include.getConfigId();
        if (targetConfigID != null) {
            targetModelRoot = ExtensionPointManager.getInst().getModel(targetConfigID);
        }
        if (targetModelRoot == null) {
            return null;
        }
        return this.findDOMTarget(targetModelRoot, path);
    }

    public Object[] findDOMTarget(IntroModelRoot model, String path) {
        Object[] results = new Object[2];
        String[] pathSegments = path.split("/");
        if (pathSegments.length != 2) {
            return results;
        }
        AbstractIntroPage targetPage = (AbstractIntroPage)model.findChild(pathSegments[0], 12);
        if (targetPage != null) {
            results[0] = targetPage;
            Element targetElement = targetPage.findDomChild(pathSegments[1]);
            if (targetElement != null) {
                results[1] = targetElement;
            }
        }
        return results;
    }

    public String getContent() {
        return this.content;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractIntroPage clone = (AbstractIntroPage)super.clone();
        if (this.title != null) {
            IntroPageTitle clonedTitle = (IntroPageTitle)this.title.clone();
            clonedTitle.setParent(clone);
            clone.title = clonedTitle;
        }
        if (this.styles != null) {
            clone.styles = (Vector)this.styles.clone();
        }
        if (this.altStyles != null) {
            clone.altStyles = (Hashtable)this.altStyles.clone();
        }
        return clone;
    }

    public void setId(String id) {
        this.originalId = this.id;
        this.id = id;
    }

    public boolean injectIFrame(String url, String embedTarget) {
        IntroGroup divToReplace = (IntroGroup)this.findTarget(embedTarget);
        if (divToReplace == null) {
            Log.warning("Failed to find embedTarget: " + embedTarget + " in page " + this.getId());
            return false;
        }
        this.iframe = new IntroInjectedIFrame(this.getElement(), this.getBundle());
        this.iframe.setParent(divToReplace);
        this.iframe.setIFrameURL(url);
        divToReplace.clearChildren();
        divToReplace.addChild(this.iframe);
        return true;
    }

    public boolean isIFramePage() {
        return this.iframe != null;
    }

    public String getUnmangledId() {
        if (this.isIFramePage()) {
            return this.originalId;
        }
        return this.id;
    }

    public void setIFrameURL(String url) {
        if (!this.isIFramePage()) {
            return;
        }
        this.iframe.setIFrameURL(url);
    }

    public String getIFrameURL() {
        if (!this.isIFramePage()) {
            return null;
        }
        return this.iframe.getIFrameURL();
    }

    public String getInitialBase() {
        return this.initialBase;
    }

    public boolean injectSharedStyle() {
        return this.sharedStyle.equals("true");
    }
}

