/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Enumeration;
import java.util.Map;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.intro.config.IntroElement;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class IntroGroup
extends AbstractIntroContainer {
    protected static final String TAG_GROUP = "group";
    private static final String ATT_LABEL = "label";
    private static final String ATT_COMPUTED = "computed";
    private static final String ATT_EXPANDABLE = "expandable";
    private static final String P_UPPERCASE = "capitalizeTitles";
    private String label;

    IntroGroup(Element element, Bundle bundle, String base) {
        super(element, bundle, base);
    }

    protected void loadFromParent() {
    }

    private void resolve() {
        if (this.label == null) {
            Map props;
            String value;
            IntroModelRoot root;
            this.label = this.getAttribute(this.element, ATT_LABEL);
            if (this.label != null && (root = this.getModelRoot()) != null && root.getTheme() != null && (value = (String)(props = root.getTheme().getProperties()).get(P_UPPERCASE)) != null && value.equalsIgnoreCase("true")) {
                this.label = this.label.toUpperCase();
            }
        }
    }

    public String getLabel() {
        this.resolve();
        return this.label;
    }

    public int getType() {
        return 16;
    }

    public boolean isExpandable() {
        String value = this.getAttribute(this.element, ATT_EXPANDABLE);
        return value != null && value.equalsIgnoreCase("true");
    }

    protected void loadChildren() {
        String value = this.getAttribute(this.element, ATT_COMPUTED);
        if (value != null && value.equalsIgnoreCase("true")) {
            this.loadDynamicNodes();
        }
        super.loadChildren();
    }

    private void loadDynamicNodes() {
        IntroModelRoot root = this.getModelRoot();
        if (root == null) {
            return;
        }
        AbstractIntroPage page = this.getParentPage();
        String pageId = page.getId();
        IntroElement[] nodes = root.getConfigurer().getGroupChildren(pageId, this.getId());
        this.addDynamicNodes(this.element, nodes);
    }

    private void addDynamicNodes(Element target, IntroElement[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            IntroElement node = nodes[i];
            this.addDynamicNode(target, node);
            ++i;
        }
    }

    private void addDynamicNode(Element target, IntroElement node) {
        IntroElement[] cnodes;
        Element clone = target.getOwnerDocument().createElement(node.getName());
        Enumeration atts = node.getAttributes();
        while (atts.hasMoreElements()) {
            String aname = (String)atts.nextElement();
            String avalue = node.getAttribute(aname);
            clone.setAttribute(aname, avalue);
        }
        String value = node.getValue();
        if (value != null) {
            Text textNode = target.getOwnerDocument().createTextNode(value);
            clone.appendChild(textNode);
        }
        if ((cnodes = node.getChildren()).length > 0) {
            this.addDynamicNodes(clone, cnodes);
        }
        target.appendChild(clone);
    }
}

