/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mx4j.ImplementationException;
import mx4j.server.interceptor.MBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptorConfiguratorMBean;

public class MBeanServerInterceptorConfigurator
implements MBeanServerInterceptorConfiguratorMBean {
    public static final String OBJECT_NAME = "JMImplementation:type=MBeanServerInterceptorConfigurator";
    private MBeanServer m_server;
    private ArrayList m_preInterceptors = new ArrayList();
    private ArrayList m_postInterceptors = new ArrayList();
    private ArrayList m_clientInterceptors = new ArrayList();
    private boolean m_running;

    public MBeanServerInterceptorConfigurator(MBeanServer server) {
        this.m_server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterceptor(MBeanServerInterceptor interceptor) {
        ArrayList arrayList = this.m_clientInterceptors;
        synchronized (arrayList) {
            this.m_clientInterceptors.add(interceptor);
        }
    }

    public void registerInterceptor(MBeanServerInterceptor interceptor, ObjectName name) throws MBeanException {
        try {
            this.m_server.registerMBean(interceptor, name);
        }
        catch (Exception x) {
            throw new MBeanException(x, "Could not register interceptor with name " + name);
        }
        this.addInterceptor(interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInterceptors() {
        ArrayList arrayList = this.m_clientInterceptors;
        synchronized (arrayList) {
            this.m_clientInterceptors.clear();
        }
    }

    public void addPreInterceptor(MBeanServerInterceptor interceptor) {
        if (this.isRunning()) {
            throw new ImplementationException();
        }
        this.m_preInterceptors.add(interceptor);
    }

    public void addPostInterceptor(MBeanServerInterceptor interceptor) {
        if (this.isRunning()) {
            throw new ImplementationException();
        }
        this.m_postInterceptors.add(interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServerInterceptor getHeadInterceptor() {
        if (this.isRunning()) {
            int size = this.m_clientInterceptors.size();
            ArrayList chain = new ArrayList(this.m_preInterceptors.size() + size + this.m_postInterceptors.size());
            chain.addAll(this.m_preInterceptors);
            if (size > 0) {
                ArrayList arrayList = this.m_clientInterceptors;
                synchronized (arrayList) {
                    chain.addAll(this.m_clientInterceptors);
                }
            }
            chain.addAll(this.m_postInterceptors);
            MBeanServerInterceptor first = (MBeanServerInterceptor)chain.get(0);
            first.setChain(chain);
            return first;
        }
        return null;
    }

    public void start() {
        if (!this.isRunning()) {
            this.m_running = true;
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.m_running = false;
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }
}

