/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.DevClassPathHelper;
import org.eclipse.pde.internal.build.packager.PackageScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.VersionedIdentifier;
import org.osgi.framework.Version;

public class BuildScriptGenerator
extends AbstractScriptGenerator {
    protected boolean generateArchive = true;
    protected boolean children = true;
    protected boolean groupConfigs = false;
    protected String[] elements;
    protected DevClassPathHelper devEntries;
    protected boolean recursiveGeneration = true;
    protected boolean generateBuildScript = true;
    protected boolean includePlatformIndependent = true;
    protected boolean signJars = false;
    protected boolean generateJnlp = false;
    protected boolean generateFeatureVersionSuffix = false;
    private String product;
    private HashMap archivesFormat;
    private boolean generateAssembleScript = true;
    private boolean ignoreMissingPropertiesFile = true;
    private boolean generateVersionsList = false;
    private static final String PROPERTY_ARCHIVESFORMAT = "archivesFormat";

    public void generate() throws CoreException {
        ArrayList plugins = new ArrayList(5);
        ArrayList features = new ArrayList(5);
        this.sortElements(features, plugins);
        this.generateModels(plugins);
        this.generateFeatures(features);
        this.flushState();
    }

    protected void sortElements(List features, List plugins) {
        int i = 0;
        while (i < this.elements.length) {
            int index = this.elements[i].indexOf(64);
            String type = this.elements[i].substring(0, index);
            String element = this.elements[i].substring(index + 1);
            if (type.equals("plugin") || type.equals("fragment")) {
                plugins.add(element);
            } else if (type.equals("feature")) {
                features.add(element);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    protected void generateModels(List models) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 140->144)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] getNameAndVersion(String id) {
        int versionPosition = id.indexOf(":");
        String[] result = new String[2];
        if (versionPosition != -1) {
            result[1] = id.substring(versionPosition + 1);
            result[0] = id.substring(0, versionPosition);
        } else {
            result[0] = id;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    protected void generateFeatures(List features) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 370->374)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void generateVersionsLists(AssemblyInformation assemblageInformation) throws CoreException {
        if (assemblageInformation == null) {
            return;
        }
        List configs = BuildScriptGenerator.getConfigInfos();
        HashSet features = new HashSet();
        HashSet plugins = new HashSet();
        Properties versions = new Properties();
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            String configString = config.toStringReplacingAny("_", "ANY");
            Collection list = assemblageInformation.getFeatures(config);
            versions.clear();
            features.addAll(list);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                IFeature feature = (IFeature)i.next();
                VersionedIdentifier id = feature.getVersionedIdentifier();
                this.recordVersion(id.getIdentifier(), new Version(id.getVersion().toString()), versions);
            }
            this.saveVersions(versions, "finalFeaturesVersions." + configString + ".properties");
            list = assemblageInformation.getPlugins(config);
            versions.clear();
            plugins.addAll(list);
            i = list.iterator();
            while (i.hasNext()) {
                BundleDescription bundle = (BundleDescription)i.next();
                this.recordVersion(bundle.getSymbolicName(), bundle.getVersion(), versions);
            }
            this.saveVersions(versions, "finalPluginsVersions." + configString + ".properties");
        }
        versions.clear();
        Iterator i = features.iterator();
        while (i.hasNext()) {
            IFeature feature = (IFeature)i.next();
            VersionedIdentifier id = feature.getVersionedIdentifier();
            this.recordVersion(id.getIdentifier(), new Version(id.getVersion().toString()), versions);
        }
        this.saveVersions(versions, "finalFeaturesVersions.properties");
        versions.clear();
        i = plugins.iterator();
        while (i.hasNext()) {
            BundleDescription bundle = (BundleDescription)i.next();
            this.recordVersion(bundle.getSymbolicName(), bundle.getVersion(), versions);
        }
        this.saveVersions(versions, "finalPluginsVersions.properties");
    }

    protected void recordVersion(String name, Version version, Properties properties) {
        String versionString = version.toString();
        if (properties.containsKey(name)) {
            Version existing = new Version((String)properties.get(name));
            if (version.compareTo((Object)existing) >= 0) {
                properties.put(name, versionString);
            }
        } else {
            properties.put(name, versionString);
        }
        String suffix = String.valueOf('_') + String.valueOf(version.getMajor()) + '.' + String.valueOf(version.getMinor()) + '.' + String.valueOf(version.getMicro());
        properties.put(String.valueOf(name) + suffix, versionString);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveVersions(Properties properties, String fileName) throws CoreException {
        String location = String.valueOf(workingDirectory) + '/' + fileName;
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(location));
            try {
                properties.store(os, null);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ((OutputStream)os).close();
                throw throwable;
            }
            {
                Object var5_8 = null;
                ((OutputStream)os).close();
                return;
            }
        }
        catch (IOException iOException) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)location);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, null));
        }
    }

    protected void generatePackageScripts(AssemblyInformation assemblageInformation, String[] featureInfo, BuildTimeSiteFactory factory) throws CoreException {
        PackageScriptGenerator assembler = null;
        assembler = new PackageScriptGenerator(workingDirectory, assemblageInformation, featureInfo[0]);
        assembler.setSignJars(this.signJars);
        assembler.setGenerateJnlp(this.generateJnlp);
        assembler.setArchivesFormat(this.getArchivesFormat());
        assembler.setProduct(this.product);
        assembler.setBuildSiteFactory(factory);
        assembler.setGroupConfigs(this.groupConfigs);
        assembler.generate();
    }

    private void generateAssembleScripts(AssemblyInformation assemblageInformation, String[] featureInfo, BuildTimeSiteFactory factory) throws CoreException {
        AssembleScriptGenerator assembler = new AssembleScriptGenerator(workingDirectory, assemblageInformation, featureInfo[0]);
        assembler.setSignJars(this.signJars);
        assembler.setGenerateJnlp(this.generateJnlp);
        assembler.setArchivesFormat(this.getArchivesFormat());
        assembler.setProduct(this.product);
        assembler.setBuildSiteFactory(factory);
        assembler.setGroupConfigs(this.groupConfigs);
        assembler.generate();
    }

    public void setGenerateArchive(boolean generateArchive) {
        this.generateArchive = generateArchive;
    }

    public void setChildren(boolean children) {
        this.children = children;
    }

    public void setDevEntries(String devEntries) {
        if (devEntries != null) {
            this.devEntries = new DevClassPathHelper(devEntries);
        }
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setRecursiveGeneration(boolean recursiveGeneration) {
        this.recursiveGeneration = recursiveGeneration;
    }

    public void setGenerateAssembleScript(boolean generateAssembleScript) {
        this.generateAssembleScript = generateAssembleScript;
    }

    public void setGenerateVersionsList(boolean generateVersionsList) {
        this.generateVersionsList = generateVersionsList;
    }

    public void setReportResolutionErrors(boolean value) {
        this.reportResolutionErrors = value;
    }

    public void setIgnoreMissingPropertiesFile(boolean value) {
        this.ignoreMissingPropertiesFile = value;
    }

    public void setProduct(String value) {
        this.product = value;
    }

    public void setSignJars(boolean value) {
        this.signJars = value;
    }

    public void setGenerateJnlp(boolean value) {
        this.generateJnlp = value;
    }

    public void setGenerateFeatureVersionSuffix(boolean value) {
        this.generateFeatureVersionSuffix = value;
    }

    public void setArchivesFormat(String archivesFormatAsString) throws CoreException {
        if (Utils.getPropertyFormat(PROPERTY_ARCHIVESFORMAT).equalsIgnoreCase(archivesFormatAsString)) {
            this.archivesFormat = new ArchiveTable(0);
            return;
        }
        this.archivesFormat = new ArchiveTable(BuildScriptGenerator.getConfigInfos().size());
        String[] configs = Utils.getArrayFromStringWithBlank(archivesFormatAsString, "&");
        int i = 0;
        while (i < configs.length) {
            String[] configElements = Utils.getArrayFromStringWithBlank(configs[i], ",");
            if (configElements.length != 3) {
                Status error = new Status(4, "org.eclipse.pde.build", 22, NLS.bind((String)Messages.error_configWrongFormat, (Object)configs[i]), null);
                throw new CoreException((IStatus)error);
            }
            String[] archAndFormat = Utils.getArrayFromStringWithBlank(configElements[2], "-");
            Config aConfig = new Config(configElements[0], configElements[1], archAndFormat[0]);
            if (BuildScriptGenerator.getConfigInfos().contains(aConfig)) {
                this.archivesFormat.put(aConfig, archAndFormat[1]);
            }
            ++i;
        }
    }

    protected HashMap getArchivesFormat() {
        if (this.archivesFormat == null) {
            try {
                this.setArchivesFormat(Utils.getPropertyFormat(PROPERTY_ARCHIVESFORMAT));
            }
            catch (CoreException coreException) {}
        }
        return this.archivesFormat;
    }

    public void includePlatformIndependent(boolean b) {
        this.includePlatformIndependent = b;
    }

    public void setGroupConfigs(boolean value) {
        this.groupConfigs = value;
    }

    private class ArchiveTable
    extends HashMap {
        private static final long serialVersionUID = -3063402400461435816L;

        public ArchiveTable(int size) {
            super(size);
        }

        public Object get(Object arg0) {
            Object result = super.get(arg0);
            if (result == null) {
                result = "antZip";
            }
            return result;
        }
    }
}

