/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.debug.internal.core.LaunchConfigurationType;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchConfiguration
extends PlatformObject
implements ILaunchConfiguration {
    public static final String ATTR_MAPPED_RESOURCE_PATHS = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".MAPPED_RESOURCE_PATHS";
    public static final String ATTR_MAPPED_RESOURCE_TYPES = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".MAPPED_RESOURCE_TYPES";
    private IPath fLocation;

    protected LaunchConfiguration(IPath location) {
        this.setLocation(location);
    }

    protected LaunchConfiguration(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String localString = root.getAttribute("local");
            String path = root.getAttribute("path");
            String message = null;
            if (path == null) {
                message = DebugCoreMessages.LaunchConfiguration_Invalid_launch_configuration_memento__missing_path_attribute_3;
            } else if (localString == null) {
                message = DebugCoreMessages.LaunchConfiguration_Invalid_launch_configuration_memento__missing_local_attribute_4;
            }
            if (message != null) {
                IStatus s = this.newStatus(message, 5013, null);
                throw new CoreException(s);
            }
            IPath location = null;
            boolean local = Boolean.valueOf(localString);
            location = local ? LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH.append(path) : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path)).getLocation();
            this.setLocation(location);
            if (location == null) {
                IStatus s = this.newStatus(MessageFormat.format(DebugCoreMessages.LaunchConfiguration_Unable_to_restore_location_for_launch_configuration_from_memento___0__1, path), 120, null);
                throw new CoreException(s);
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        IStatus s = this.newStatus(DebugCoreMessages.LaunchConfiguration_Exception_occurred_parsing_memento_5, 5013, ex);
        throw new CoreException(s);
    }

    public boolean contentsEqual(ILaunchConfiguration object) {
        try {
            if (object instanceof LaunchConfiguration) {
                LaunchConfiguration otherConfig = (LaunchConfiguration)object;
                return this.getName().equals(otherConfig.getName()) && this.getType().equals(otherConfig.getType()) && this.getLocation().equals((Object)otherConfig.getLocation()) && this.getInfo().equals(otherConfig.getInfo());
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public ILaunchConfigurationWorkingCopy copy(String name) throws CoreException {
        LaunchConfigurationWorkingCopy copy = new LaunchConfigurationWorkingCopy(this, name);
        return copy;
    }

    public void delete() throws CoreException {
        if (this.exists()) {
            if (this.isLocal()) {
                if (!this.getLocation().toFile().delete()) {
                    throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfiguration_Failed_to_delete_launch_configuration__1, null));
                }
                this.getLaunchManager().launchConfigurationDeleted(this);
            } else {
                IFile file = this.getFile();
                if (file != null) {
                    IStatus status;
                    if (file.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
                        throw new CoreException(status);
                    }
                    file.delete(true, null);
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ILaunchConfiguration) {
            if (this.isWorkingCopy()) {
                return this == object;
            }
            ILaunchConfiguration config = (ILaunchConfiguration)object;
            if (!config.isWorkingCopy()) {
                return config.getLocation().equals((Object)this.getLocation());
            }
        }
        return false;
    }

    public boolean exists() {
        if (this.isLocal()) {
            return this.getLocation().toFile().exists();
        }
        IFile file = this.getFile();
        return file != null && file.exists();
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
        return this.getInfo().getBooleanAttribute(attributeName, defaultValue);
    }

    public int getAttribute(String attributeName, int defaultValue) throws CoreException {
        return this.getInfo().getIntAttribute(attributeName, defaultValue);
    }

    public List getAttribute(String attributeName, List defaultValue) throws CoreException {
        return this.getInfo().getListAttribute(attributeName, defaultValue);
    }

    public Map getAttribute(String attributeName, Map defaultValue) throws CoreException {
        return this.getInfo().getMapAttribute(attributeName, defaultValue);
    }

    public String getAttribute(String attributeName, String defaultValue) throws CoreException {
        return this.getInfo().getStringAttribute(attributeName, defaultValue);
    }

    public Map getAttributes() throws CoreException {
        LaunchConfigurationInfo info = this.getInfo();
        return info.getAttributes();
    }

    public String getCategory() throws CoreException {
        return this.getType().getCategory();
    }

    protected IContainer getContainer() {
        IFile file = this.getFile();
        if (file != null) {
            return file.getParent();
        }
        return null;
    }

    protected ILaunchConfigurationDelegate getDelegate(String mode) throws CoreException {
        return this.getType().getDelegate(mode);
    }

    public IFile getFile() {
        if (this.isLocal()) {
            return null;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(this.getLocation());
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    protected LaunchConfigurationInfo getInfo() throws CoreException {
        return this.getLaunchManager().getInfo(this);
    }

    private String getLastLocationSegment() {
        String name = this.getLocation().lastSegment();
        if (name.length() > "launch".length()) {
            name = name.substring(0, name.length() - ("launch".length() + 1));
        }
        return name;
    }

    protected LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    public IPath getLocation() {
        return this.fLocation;
    }

    public IResource[] getMappedResources() throws CoreException {
        List paths = this.getAttribute(ATTR_MAPPED_RESOURCE_PATHS, (List)null);
        if (paths == null || paths.size() == 0) {
            return null;
        }
        List types = this.getAttribute(ATTR_MAPPED_RESOURCE_TYPES, (List)null);
        if (types == null || types.size() != paths.size()) {
            throw new CoreException(this.newStatus(DebugCoreMessages.LaunchConfiguration_10, 120, null));
        }
        ArrayList<IWorkspaceRoot> list = new ArrayList<IWorkspaceRoot>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < paths.size()) {
            String pathStr = (String)paths.get(i);
            String typeStr = (String)types.get(i);
            int type = -1;
            try {
                type = Integer.decode(typeStr);
            }
            catch (NumberFormatException e) {
                throw new CoreException(this.newStatus(DebugCoreMessages.LaunchConfiguration_10, 120, e));
            }
            IPath path = Path.fromPortableString((String)pathStr);
            IWorkspaceRoot res = null;
            switch (type) {
                case 1: {
                    res = root.getFile(path);
                    break;
                }
                case 4: {
                    res = root.getProject(pathStr);
                    break;
                }
                case 2: {
                    res = root.getFolder(path);
                    break;
                }
                case 8: {
                    res = root;
                    break;
                }
                default: {
                    throw new CoreException(this.newStatus(DebugCoreMessages.LaunchConfiguration_10, 120, null));
                }
            }
            if (res != null) {
                list.add(res);
            }
            ++i;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new IResource[list.size()]);
    }

    public String getMemento() throws CoreException {
        IPath relativePath = null;
        if (this.isLocal()) {
            IPath rootPath = LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH;
            IPath configPath = this.getLocation();
            relativePath = configPath.removeFirstSegments(rootPath.segmentCount());
            relativePath = relativePath.setDevice(null);
        } else {
            IFile file = this.getFile();
            if (file == null) {
                IStatus status = this.newStatus(MessageFormat.format(DebugCoreMessages.LaunchConfiguration_Unable_to_generate_memento_for__0___shared_file_does_not_exist__1, this.getName()), 5013, null);
                throw new CoreException(status);
            }
            relativePath = this.getFile().getFullPath();
        }
        Exception e = null;
        try {
            Document doc = LaunchManager.getDocument();
            Element node = doc.createElement("launchConfiguration");
            doc.appendChild(node);
            node.setAttribute("local", Boolean.valueOf(this.isLocal()).toString());
            node.setAttribute("path", relativePath.toString());
            return LaunchManager.serializeDocument(doc);
        }
        catch (IOException ioe) {
            e = ioe;
        }
        catch (ParserConfigurationException pce) {
            e = pce;
        }
        catch (TransformerException te) {
            e = te;
        }
        IStatus status = this.newStatus(DebugCoreMessages.LaunchConfiguration_Exception_occurred_creating_launch_configuration_memento_9, 5013, e);
        throw new CoreException(status);
    }

    public String getName() {
        return this.getLastLocationSegment();
    }

    public ILaunchConfigurationType getType() throws CoreException {
        return this.getInfo().getType();
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        return new LaunchConfigurationWorkingCopy(this);
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    protected void initializeSourceLocator(ILaunch launch) throws CoreException {
        if (launch.getSourceLocator() == null) {
            String type = this.getAttribute(ATTR_SOURCE_LOCATOR_ID, (String)null);
            if (type == null) {
                type = this.getType().getSourceLocatorId();
            }
            if (type != null) {
                IPersistableSourceLocator locator = this.getLaunchManager().newSourceLocator(type);
                String memento = this.getAttribute(ATTR_SOURCE_LOCATOR_MEMENTO, (String)null);
                if (memento == null) {
                    locator.initializeDefaults(this);
                } else if (locator instanceof IPersistableSourceLocator2) {
                    ((IPersistableSourceLocator2)locator).initializeFromMemento(memento, this);
                } else {
                    locator.initializeFromMemento(memento);
                }
                launch.setSourceLocator(locator);
            }
        }
    }

    public boolean isLocal() {
        IPath localPath = LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH;
        return localPath.isPrefixOf(this.getLocation());
    }

    public boolean isMigrationCandidate() throws CoreException {
        return ((LaunchConfigurationType)this.getType()).isMigrationCandidate(this);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public ILaunch launch(String mode, IProgressMonitor monitor) throws CoreException {
        return this.launch(mode, monitor, false);
    }

    public ILaunch launch(String mode, IProgressMonitor monitor, boolean build) throws CoreException {
        return this.launch(mode, monitor, build, true);
    }

    public ILaunch launch(String mode, IProgressMonitor monitor, boolean build, boolean register) throws CoreException {
        ILaunchConfigurationDelegate delegate = this.getDelegate(mode);
        ILaunchConfigurationDelegate2 delegate2 = null;
        if (delegate instanceof ILaunchConfigurationDelegate2) {
            delegate2 = (ILaunchConfigurationDelegate2)delegate;
        }
        ILaunch launch = null;
        if (delegate2 != null) {
            launch = delegate2.getLaunch(this, mode);
        }
        if (launch == null) {
            launch = new Launch(this, mode, null);
        } else if (!mode.equals(launch.getLaunchMode())) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.LaunchConfiguration_13, mode, launch.getLaunchMode()), null);
            throw new CoreException((IStatus)status);
        }
        boolean captureOutput = this.getAttribute("org.eclipse.debug.core.capture_output", true);
        if (!captureOutput) {
            launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
        } else {
            launch.setAttribute("org.eclipse.debug.core.capture_output", null);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (delegate2 != null && !delegate2.preLaunchCheck(this, mode, monitor)) {
            monitor.setCanceled(true);
            return launch;
        }
        IProgressMonitor subMonitor = monitor;
        if (build) {
            subMonitor = new SubProgressMonitor(monitor, 100);
            if (delegate2 != null) {
                build = delegate2.buildForLaunch(this, mode, subMonitor);
            }
            if (build) {
                ResourcesPlugin.getWorkspace().build(10, subMonitor);
            }
            subMonitor = new SubProgressMonitor(monitor, 100);
        }
        if (delegate2 != null && !delegate2.finalLaunchCheck(this, mode, subMonitor)) {
            monitor.setCanceled(true);
            return launch;
        }
        if (register) {
            this.getLaunchManager().addLaunch(launch);
        }
        try {
            this.initializeSourceLocator(launch);
            delegate.launch(this, mode, launch, subMonitor);
        }
        catch (CoreException e) {
            if (!launch.hasChildren()) {
                this.getLaunchManager().removeLaunch(launch);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            this.getLaunchManager().removeLaunch(launch);
        }
        return launch;
    }

    public void migrate() throws CoreException {
        ((LaunchConfigurationType)this.getType()).migrate(this);
    }

    protected IStatus newStatus(String message, int code, Throwable e) {
        return new Status(4, DebugPlugin.getUniqueIdentifier(), code, message, e);
    }

    private void setLocation(IPath location) {
        this.fLocation = location;
    }

    public boolean supportsMode(String mode) throws CoreException {
        return this.getType().supportsMode(mode);
    }
}

