/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.JavaFileEditorInput;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenExternalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String fFilterPath;

    public OpenExternalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
        this.fFilterPath = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fFilterPath = System.getProperty("user.home");
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4098);
        dialog.setText(TextEditorMessages.OpenExternalFileAction_title);
        dialog.setFilterPath(this.fFilterPath);
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null) {
            this.fFilterPath = dialog.getFilterPath();
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            int i = 0;
            while (i < names.length) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(this.fFilterPath));
                if (!(fileStore = fileStore.getChild(names[i])).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    IEditorInput input = this.createEditorInput(fileStore);
                    String editorId = this.getEditorId(fileStore);
                    IWorkbenchPage page = this.fWindow.getActivePage();
                    try {
                        page.openEditor(input, editorId);
                    }
                    catch (PartInitException e) {
                        EditorsPlugin.log(e.getStatus());
                        String msg = MessageFormat.format(TextEditorMessages.OpenExternalFileAction_message_errorOnOpen, fileStore.getName());
                        MessageDialog.openError((Shell)this.fWindow.getShell(), (String)TextEditorMessages.OpenExternalFileAction_title, (String)msg);
                    }
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(fileStore.getName());
                }
                ++i;
            }
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? TextEditorMessages.OpenExternalFileAction_message_fileNotFound : TextEditorMessages.OpenExternalFileAction_message_filesNotFound;
                String msg = MessageFormat.format(msgFmt, notFound.toString());
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)TextEditorMessages.OpenExternalFileAction_title, (String)msg);
            }
        }
    }

    private String getEditorId(IFileStore file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), this.getContentType(file));
        if (descriptor == null && editorRegistry.isSystemInPlaceEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && editorRegistry.isSystemExternalEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * Unable to fully structure code
     */
    private IContentType getContentType(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        stream = null;
        stream = fileStore.openInputStream(0, null);
        var6_3 = Platform.getContentTypeManager().findContentTypeFor(stream, fileStore.getName());
        var4_4 = null;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException x) {
            EditorsPlugin.log(x);
        }
        return var6_3;
        catch (IOException x) {
            EditorsPlugin.log(x);
lbl21:
            // 2 sources

            while (true) {
                var4_5 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException x) {
                    EditorsPlugin.log(x);
                }
                return null;
            }
        }
        catch (CoreException x) {
            EditorsPlugin.log(x);
            ** continue;
            {
                catch (Throwable var5_12) {
                    var4_6 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException x) {
                        EditorsPlugin.log(x);
                    }
                    throw var5_12;
                }
            }
        }
    }

    private IEditorInput createEditorInput(IFileStore fileStore) {
        IFile workspaceFile = this.getWorkspaceFile(fileStore);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new JavaFileEditorInput(fileStore);
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = workspace.getRoot().findFilesForLocation((IPath)new Path(fileStore.toURI().getPath()));
        if ((files = this.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        return this.selectWorkspaceFile(files);
    }

    private IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    private IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.fWindow.getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setElements((Object[])files);
        dialog.setTitle(TextEditorMessages.OpenExternalFileAction_title_selectWorkspaceFile);
        dialog.setMessage(TextEditorMessages.OpenExternalFileAction_message_fileLinkedToMultiple);
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                return path != null ? path.toString() : "";
            }
            return super.getText(element);
        }
    }
}

