/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.composite.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditVisitor;

public class CleanUpRefactoring
extends Refactoring {
    private static final int BATCH_SIZE = 40;
    private static final RefactoringTickProvider CLEAN_UP_REFACTORING_TICK_PROVIDER = new RefactoringTickProvider(0, 1, 0, 0);
    private List fCleanUps = new ArrayList();
    private Hashtable fProjects = new Hashtable();
    private Change fChange;
    private boolean fLeaveFilesDirty;

    public void addCompilationUnit(ICompilationUnit unit) {
        IJavaProject javaProject = unit.getJavaProject();
        if (!this.fProjects.containsKey(javaProject)) {
            this.fProjects.put(javaProject, new ArrayList());
        }
        List cus = (List)this.fProjects.get(javaProject);
        cus.add(unit);
    }

    public void clearCompilationUnits() {
        this.fProjects.clear();
    }

    public boolean hasCompilationUnits() {
        return !this.fProjects.isEmpty();
    }

    public ICompilationUnit[] getCompilationUnits() {
        ArrayList cus = new ArrayList();
        Iterator iter = this.fProjects.values().iterator();
        while (iter.hasNext()) {
            List pcus = (List)iter.next();
            cus.addAll(pcus);
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    public void addCleanUp(ICleanUp fix) {
        this.fCleanUps.add(fix);
    }

    public void clearCleanUps() {
        this.fCleanUps.clear();
    }

    public boolean hasCleanUps() {
        return !this.fCleanUps.isEmpty();
    }

    public ICleanUp[] getCleanUps() {
        return this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
    }

    public IJavaProject[] getProjects() {
        return this.fProjects.keySet().toArray(new IJavaProject[this.fProjects.keySet().size()]);
    }

    public void setLeaveFilesDirty(boolean leaveFilesDirty) {
        this.fLeaveFilesDirty = leaveFilesDirty;
    }

    public String getName() {
        return FixMessages.CleanUpRefactoring_Refactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return this.fChange;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (this.fProjects.size() == 0 || this.fCleanUps.size() == 0) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            this.fChange = new NullChange();
            return new RefactoringStatus();
        }
        int cuCount = 0;
        Iterator iter = this.fProjects.keySet().iterator();
        while (iter.hasNext()) {
            IJavaProject project = (IJavaProject)iter.next();
            cuCount += ((List)this.fProjects.get(project)).size();
        }
        pm.beginTask("", cuCount * 2 * this.fCleanUps.size() + 4 * this.fCleanUps.size());
        try {
            DynamicValidationStateChange change = new DynamicValidationStateChange(this.getName());
            Iterator projectIter = this.fProjects.keySet().iterator();
            while (projectIter.hasNext()) {
                IJavaProject project = (IJavaProject)projectIter.next();
                List compilationUnits = (List)this.fProjects.get(project);
                ICompilationUnit[] cus = compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]);
                ICleanUp[] cleanUps = this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
                this.cleanUpProject(project, cus, cleanUps, change, pm);
            }
            this.fChange = change;
            RefactoringStatus result = new RefactoringStatus();
            ArrayList files = new ArrayList();
            this.findFilesToBeModified(change, files);
            result.merge(Checks.validateModifiesFiles(files.toArray(new IFile[files.size()]), this.getValidationContext()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                Object var9_10 = null;
                pm.done();
                return refactoringStatus;
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return new RefactoringStatus();
    }

    private void findFilesToBeModified(CompositeChange change, List result) throws JavaModelException {
        Change[] children = change.getChildren();
        int i = 0;
        while (i < children.length) {
            Change child = children[i];
            if (child instanceof CompositeChange) {
                this.findFilesToBeModified((CompositeChange)child, result);
            } else if (child instanceof MultiStateCompilationUnitChange) {
                result.add(((MultiStateCompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            } else if (child instanceof CompilationUnitChange) {
                result.add(((CompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            }
            ++i;
        }
    }

    private void cleanUpProject(IJavaProject project, ICompilationUnit[] compilationUnits, ICleanUp[] cleanUps, CompositeChange result, IProgressMonitor monitor) throws CoreException {
        this.initCleanUps(project, compilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, 4 * cleanUps.length));
        ArrayList<ParseListElement> toGo = new ArrayList<ParseListElement>();
        int i = 0;
        while (i < compilationUnits.length) {
            toGo.add(new ParseListElement(compilationUnits[i], cleanUps));
            ++i;
        }
        Hashtable resultingFixes = new Hashtable();
        Map cleanUpOptions = this.getCleanUpOptions();
        IndexCounter index = new IndexCounter(1, compilationUnits.length);
        int start = 0;
        int end = 0;
        while (end < toGo.size()) {
            end = Math.min(start + 40, toGo.size());
            List toParse = toGo.subList(start, end);
            ASTParser parser = this.createParser(cleanUpOptions, project);
            List redoList = this.parse(toParse, parser, resultingFixes, index, new CleanUpRefactoringProgressMonitor(monitor, toParse.size() * 2 * cleanUps.length));
            toGo.addAll(redoList);
            start = end;
        }
        Iterator iter = resultingFixes.values().iterator();
        while (iter.hasNext()) {
            Change element = (Change)iter.next();
            result.add(element);
        }
        this.endCleanUps();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initCleanUps(IJavaProject javaProject, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        ICleanUp[] cleanUps = this.getCleanUps();
        monitor.beginTask(Messages.format(FixMessages.CleanUpRefactoring_Initialize_message, javaProject.getElementName()), compilationUnits.length * cleanUps.length);
        try {
            int j = 0;
            while (j < cleanUps.length) {
                cleanUps[j].beginCleanUp(javaProject, compilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, compilationUnits.length));
                ++j;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    private void endCleanUps() throws CoreException {
        ICleanUp[] cleanUps = this.getCleanUps();
        int j = 0;
        while (j < cleanUps.length) {
            cleanUps[j].endCleanUp();
            ++j;
        }
    }

    private Map getCleanUpOptions() {
        Hashtable cleanUpOptions = new Hashtable();
        Iterator iter = this.fCleanUps.iterator();
        while (iter.hasNext()) {
            ICleanUp cleanUp = (ICleanUp)iter.next();
            Map currentCleanUpOption = cleanUp.getRequiredOptions();
            if (currentCleanUpOption == null) continue;
            cleanUpOptions.putAll(currentCleanUpOption);
        }
        return cleanUpOptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List parse(List toParse, ASTParser parser, Hashtable solutions, IndexCounter index, CleanUpRefactoringProgressMonitor monitor) throws CoreException {
        Throwable throwable2;
        block11: {
            Iterator iter2;
            List list;
            block10: {
                Iterator iter2;
                ICompilationUnit[] compilationUnits = new ICompilationUnit[toParse.size()];
                ArrayList<ICompilationUnit> workingCopys = new ArrayList<ICompilationUnit>();
                try {
                    SolutionGenerator solutionGenerator;
                    int i = 0;
                    Iterator iter3 = toParse.iterator();
                    while (true) {
                        if (!iter3.hasNext()) {
                            solutionGenerator = new SolutionGenerator(toParse, index, solutions, monitor);
                            try {
                                parser.createASTs(compilationUnits, new String[0], (ASTRequestor)solutionGenerator, (IProgressMonitor)monitor);
                                break;
                            }
                            catch (FixCalculationException e) {
                                throw e.getException();
                            }
                        }
                        ParseListElement element = (ParseListElement)iter3.next();
                        ICompilationUnit compilationUnit = element.getCompilationUnit();
                        if (solutions.containsKey(compilationUnit)) {
                            ICompilationUnit workingCopy;
                            compilationUnits[i] = workingCopy = this.createWorkingCopy(solutions, compilationUnit);
                            workingCopys.add(workingCopy);
                        } else {
                            compilationUnits[i] = compilationUnit;
                        }
                        ++i;
                    }
                    list = solutionGenerator.getResult();
                    Object var13_15 = null;
                    if (workingCopys.isEmpty()) break block10;
                    iter2 = workingCopys.iterator();
                }
                catch (Throwable throwable2) {
                    Object var13_16 = null;
                    if (workingCopys.isEmpty()) break block11;
                    iter2 = workingCopys.iterator();
                }
                while (iter2.hasNext()) {
                    ICompilationUnit cu = (ICompilationUnit)iter2.next();
                    cu.discardWorkingCopy();
                }
            }
            monitor.done();
            return list;
            while (iter2.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iter2.next();
                cu.discardWorkingCopy();
            }
        }
        monitor.done();
        throw throwable2;
    }

    private ICompilationUnit createWorkingCopy(Hashtable solutions, ICompilationUnit compilationUnit) throws JavaModelException, CoreException {
        MultiStateCompilationUnitChange mscuc;
        Change oldChange = (Change)solutions.get(compilationUnit);
        if (!(oldChange instanceof MultiStateCompilationUnitChange)) {
            mscuc = new MultiStateCompilationUnitChange(this.getChangeName(compilationUnit), compilationUnit);
            mscuc.setKeepPreviewEdits(true);
            mscuc.addChange((TextChange)oldChange);
            solutions.remove(compilationUnit);
            solutions.put(compilationUnit, mscuc);
        } else {
            mscuc = (MultiStateCompilationUnitChange)oldChange;
        }
        ICompilationUnit workingCopy = compilationUnit.getWorkingCopy(new WorkingCopyOwner(){}, null, null);
        IBuffer buffer = workingCopy.getBuffer();
        buffer.setContents(mscuc.getPreviewContent(null));
        return workingCopy;
    }

    private String getChangeName(ICompilationUnit compilationUnit) {
        StringBuffer buf = new StringBuffer();
        JavaElementLabels.getCompilationUnitLabel(compilationUnit, JavaElementLabels.ALL_DEFAULT, buf);
        buf.append(JavaElementLabels.CONCAT_STRING);
        StringBuffer buf2 = new StringBuffer();
        JavaElementLabels.getPackageFragmentLabel((IPackageFragment)compilationUnit.getParent(), 0x800000000L, buf2);
        buf.append(buf2.toString().replace('.', '/'));
        return buf.toString();
    }

    private ASTParser createParser(Map cleanUpOptions, IJavaProject javaProject) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(javaProject);
        Map options = RefactoringASTParser.getCompilerOptions((IJavaElement)javaProject);
        options.putAll(cleanUpOptions);
        parser.setCompilerOptions(options);
        return parser;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean intersects(TextEdit edit1, TextEdit edit2) {
        block13: {
            if (!(edit1 instanceof MultiTextEdit) || !(edit2 instanceof MultiTextEdit)) break block13;
            multiTextEdit1 = (MultiTextEdit)edit1;
            children1 = multiTextEdit1.getChildren();
            multiTextEdit2 = (MultiTextEdit)edit2;
            children2 = multiTextEdit2.getChildren();
            i1 = 0;
            i2 = 0;
            ** GOTO lbl22
            {
                if (++i1 >= children1.length) {
                    return false;
                }
                do {
                    if (children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue block0;
                    while (children2[i2].getExclusiveEnd() < children1[i1].getOffset()) {
                        if (++i2 < children2.length) continue;
                        return false;
                    }
                    if (CleanUpRefactoring.intersects(children1[i1], children2[i2])) {
                        return true;
                    }
                    if (children1[i1].getExclusiveEnd() < children2[i2].getExclusiveEnd()) {
                        ++i1;
                        continue;
                    }
                    ++i2;
lbl22:
                    // 3 sources

                } while (i1 < children1.length && i2 < children2.length);
            }
            return false;
        }
        if (edit1 instanceof MultiTextEdit) {
            multiTextEdit1 = (MultiTextEdit)edit1;
            children = multiTextEdit1.getChildren();
            i = 0;
            while (i < children.length) {
                child = children[i];
                if (CleanUpRefactoring.intersects(child, edit2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (edit2 instanceof MultiTextEdit) {
            multiTextEdit2 = (MultiTextEdit)edit2;
            children = multiTextEdit2.getChildren();
            i = 0;
            while (i < children.length) {
                child = children[i];
                if (CleanUpRefactoring.intersects(child, edit1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        start1 = edit1.getOffset();
        end1 = start1 + edit1.getLength();
        start2 = edit2.getOffset();
        end2 = start2 + edit2.getLength();
        if (start1 > end2) {
            return false;
        }
        return start2 <= end1;
    }

    private static void mergeTextChanges(TextChange target, TextChange source) {
        final ArrayList edits = new ArrayList();
        source.getEdit().accept(new TextEditVisitor(){

            public boolean visitNode(TextEdit edit) {
                if (edit instanceof MoveSourceEdit) {
                    return false;
                }
                if (edit instanceof MultiTextEdit) {
                    return true;
                }
                edits.add(edit);
                return super.visitNode(edit);
            }
        });
        if (edits.isEmpty()) {
            return;
        }
        final ArrayList removedEdits = new ArrayList();
        target.getEdit().accept(new TextEditVisitor(){

            public boolean visit(DeleteEdit deleteEdit) {
                int start = deleteEdit.getOffset();
                int end = start + deleteEdit.getLength();
                ArrayList<TextEdit> toRemove = new ArrayList<TextEdit>();
                Iterator iter = edits.iterator();
                while (iter.hasNext()) {
                    TextEdit edit = (TextEdit)iter.next();
                    int offset = edit.getOffset();
                    if (offset < start || offset > end) continue;
                    toRemove.add(edit);
                }
                if (!toRemove.isEmpty()) {
                    edits.removeAll(toRemove);
                    removedEdits.addAll(toRemove);
                }
                return super.visit(deleteEdit);
            }
        });
        Iterator iter = edits.iterator();
        while (iter.hasNext()) {
            TextEdit edit = (TextEdit)iter.next();
            edit.getParent().removeChild(edit);
            TextChangeCompatibility.insert(target.getEdit(), edit);
        }
        TextEditBasedChangeGroup[] changeGroups = source.getChangeGroups();
        int i = 0;
        while (i < changeGroups.length) {
            TextEditGroup textEditGroup = changeGroups[i].getTextEditGroup();
            TextEditGroup newGroup = new TextEditGroup(textEditGroup.getName());
            TextEdit[] textEdits = textEditGroup.getTextEdits();
            int j = 0;
            while (j < textEdits.length) {
                if (!removedEdits.contains(textEdits[j])) {
                    newGroup.addTextEdit(textEdits[j]);
                }
                ++j;
            }
            target.addTextEditGroup(newGroup);
            ++i;
        }
    }

    protected RefactoringTickProvider doGetRefactoringTickProvider() {
        return CLEAN_UP_REFACTORING_TICK_PROVIDER;
    }

    private class FixCalculationException
    extends RuntimeException {
        private static final long serialVersionUID = 3807273310144726165L;
        private final CoreException fException;

        public FixCalculationException(CoreException exception) {
            this.fException = exception;
        }

        public CoreException getException() {
            return this.fException;
        }
    }

    private class ParseListElement {
        private final ICompilationUnit fUnit;
        private List fCleanUpsToGo;
        private ICleanUp[] fCleanUpsArray;

        public ParseListElement(ICompilationUnit unit) {
            this.fUnit = unit;
            this.fCleanUpsToGo = new ArrayList();
            this.fCleanUpsArray = new ICleanUp[0];
        }

        public ParseListElement(ICompilationUnit unit, ICleanUp[] cleanUps) {
            this.fUnit = unit;
            this.fCleanUpsArray = cleanUps;
            this.fCleanUpsToGo = null;
        }

        public void addCleanUp(ICleanUp multiFix) {
            if (this.fCleanUpsToGo == null) {
                this.fCleanUpsToGo = Arrays.asList(this.fCleanUpsArray);
            }
            this.fCleanUpsToGo.add(multiFix);
            this.fCleanUpsArray = null;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fUnit;
        }

        public ICleanUp[] getCleanUps() {
            if (this.fCleanUpsArray == null) {
                this.fCleanUpsArray = this.fCleanUpsToGo.toArray(new ICleanUp[this.fCleanUpsToGo.size()]);
            }
            return this.fCleanUpsArray;
        }
    }

    private class IndexCounter {
        private int fIndex;
        private final int fSize;

        public IndexCounter(int index, int size) {
            this.fIndex = index;
            this.fSize = size;
        }

        public void inc() {
            ++this.fIndex;
        }

        public int value() {
            return this.fIndex;
        }

        public int size() {
            return this.fSize;
        }
    }

    private final class CleanUpRefactoringProgressMonitor
    extends SubProgressMonitor {
        private int worked = 0;

        private CleanUpRefactoringProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks);
        }

        public void worked(int work) {
            this.worked += work;
        }

        public void flush() {
            super.worked(this.worked);
            this.reset();
        }

        public void reset() {
            this.worked = 0;
        }

        public void done() {
        }
    }

    private final class SolutionGenerator
    extends ASTRequestor {
        private final CleanUpRefactoringProgressMonitor fMonitor;
        private final List fResult;
        private final Hashtable fSolutions;
        private final Iterator fToParseIter;
        private ParseListElement fCurElement;
        private IndexCounter fIndex;

        private SolutionGenerator(List toSolve, IndexCounter startIndex, Hashtable solutions, CleanUpRefactoringProgressMonitor monitor) {
            this.fMonitor = monitor;
            this.fResult = new ArrayList();
            this.fSolutions = solutions;
            this.fIndex = startIndex;
            this.fToParseIter = toSolve.iterator();
            this.fCurElement = (ParseListElement)this.fToParseIter.next();
            this.fMonitor.subTask(this.getSubTaskMessage(this.fCurElement.getCompilationUnit(), this.fIndex.value(), this.fIndex.size()));
        }

        public List getResult() {
            return this.fResult;
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            ParseListElement tuple = this.calculateSolution(this.fSolutions, ast, this.fCurElement.getCleanUps());
            if (this.fMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (tuple != null) {
                this.fResult.add(tuple);
                this.fMonitor.reset();
            } else {
                this.fIndex.inc();
                this.fMonitor.flush();
            }
            if (this.fToParseIter.hasNext()) {
                this.fCurElement = (ParseListElement)this.fToParseIter.next();
                this.fMonitor.subTask(this.getSubTaskMessage(this.fCurElement.getCompilationUnit(), this.fIndex.value(), this.fIndex.size()));
            }
        }

        private String getSubTaskMessage(ICompilationUnit cu, int index, int size) {
            String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
            return Messages.format(FixMessages.CleanUpRefactoring_ProcessingCompilationUnit_message, new Object[]{typeName, new Integer(index), new Integer(size)});
        }

        private ParseListElement calculateSolution(Hashtable solutions, CompilationUnit ast, ICleanUp[] cleanUps) {
            TextChange solution = null;
            ParseListElement result = null;
            int i = 0;
            while (i < cleanUps.length) {
                ICleanUp cleanUp = cleanUps[i];
                try {
                    IFix fix = cleanUp.createFix(ast);
                    if (fix != null) {
                        TextChange current = fix.createChange();
                        if (current instanceof TextFileChange && CleanUpRefactoring.this.fLeaveFilesDirty) {
                            ((TextFileChange)current).setSaveMode(4);
                        }
                        if (solution != null) {
                            if (CleanUpRefactoring.intersects(current.getEdit(), solution.getEdit())) {
                                if (result == null) {
                                    result = new ParseListElement((ICompilationUnit)ast.getJavaElement().getPrimaryElement());
                                }
                                result.addCleanUp(cleanUp);
                            } else {
                                CleanUpRefactoring.mergeTextChanges(current, solution);
                                solution = current;
                            }
                        } else {
                            solution = current;
                        }
                    }
                }
                catch (CoreException e) {
                    throw new FixCalculationException(e);
                }
                ++i;
            }
            if (solution != null) {
                if (solutions.containsKey(ast.getJavaElement().getPrimaryElement())) {
                    MultiStateCompilationUnitChange oldChange = (MultiStateCompilationUnitChange)((Object)solutions.get(ast.getJavaElement().getPrimaryElement()));
                    oldChange.addChange(solution);
                } else {
                    solutions.put(ast.getJavaElement(), solution);
                }
            }
            return result;
        }
    }
}

