/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceAnalyzer;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class SourceProvider {
    private IJavaElement fUnit;
    private IDocument fDocument;
    private MethodDeclaration fDeclaration;
    private SourceAnalyzer fAnalyzer;
    private boolean fMustEvalReturnedExpression;
    private boolean fReturnValueNeedsLocalVariable;
    private List fReturnExpressions;
    private IDocument fSource;

    public SourceProvider(IJavaElement unit, MethodDeclaration declaration) {
        this.fUnit = unit;
        this.fDeclaration = declaration;
        List parameters = this.fDeclaration.parameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration element = (SingleVariableDeclaration)iter.next();
            ParameterData data = new ParameterData(element);
            element.setProperty(ParameterData.PROPERTY, (Object)data);
        }
        this.fAnalyzer = new SourceAnalyzer(this.fUnit, this.fDeclaration);
        this.fReturnValueNeedsLocalVariable = true;
        this.fReturnExpressions = new ArrayList();
    }

    public SourceProvider(IJavaElement unit, IDocument source, MethodDeclaration declaration) {
        this(unit, declaration);
        this.fSource = source;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        return this.fAnalyzer.checkActivation();
    }

    public void initialize() throws JavaModelException {
        ASTNode last;
        this.fDocument = this.fSource == null ? new Document(((IOpenable)this.fUnit).getBuffer().getContents()) : this.fSource;
        this.fAnalyzer.initialize();
        if (this.hasReturnValue() && (last = this.getLastStatement()) != null) {
            ReturnAnalyzer analyzer = new ReturnAnalyzer();
            last.accept((ASTVisitor)analyzer);
        }
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fAnalyzer.isExecutionFlowInterrupted();
    }

    public boolean isVariableReferenced(IVariableBinding binding) {
        VariableReferenceFinder finder = new VariableReferenceFinder(binding);
        this.fDeclaration.accept((ASTVisitor)finder);
        return finder.getResult();
    }

    public boolean hasReturnValue() {
        IMethodBinding binding = this.fDeclaration.resolveBinding();
        return binding.getReturnType() != this.fDeclaration.getAST().resolveWellKnownType("void");
    }

    public boolean hasArrayAccess() {
        return this.fAnalyzer.hasArrayAccess();
    }

    public boolean hasSuperMethodInvocation() {
        return this.fAnalyzer.hasSuperMethodInvocation();
    }

    public boolean mustEvaluateReturnedExpression() {
        return this.fMustEvalReturnedExpression;
    }

    public boolean returnValueNeedsLocalVariable() {
        return this.fReturnValueNeedsLocalVariable;
    }

    public int getNumberOfStatements() {
        return this.fDeclaration.getBody().statements().size();
    }

    public boolean isSimpleFunction() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() != 1) {
            return false;
        }
        return statements.get(0) instanceof ReturnStatement;
    }

    public boolean isLastStatementReturn() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() == 0) {
            return false;
        }
        return statements.get(statements.size() - 1) instanceof ReturnStatement;
    }

    public MethodDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String getMethodName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getReturnType() {
        return this.fDeclaration.resolveBinding().getReturnType();
    }

    public List getReturnExpressions() {
        return this.fReturnExpressions;
    }

    public boolean returnTypeMatchesReturnExpressions() {
        ITypeBinding returnType = this.getReturnType();
        Iterator iter = this.fReturnExpressions.iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            if (Bindings.equals((IBinding)returnType, (IBinding)expression.resolveTypeBinding())) continue;
            return false;
        }
        return true;
    }

    public ParameterData getParameterData(int index) {
        SingleVariableDeclaration decl = (SingleVariableDeclaration)this.fDeclaration.parameters().get(index);
        return (ParameterData)decl.getProperty(ParameterData.PROPERTY);
    }

    public IJavaElement getTypeContainerUnit() {
        return this.fUnit;
    }

    public boolean needsReturnedExpressionParenthesis() {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return ASTNodes.needsParentheses(((ReturnStatement)last).getExpression());
        }
        return false;
    }

    public boolean returnsConditionalExpression() {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return ((ReturnStatement)last).getExpression() instanceof ConditionalExpression;
        }
        return false;
    }

    public int getReceiversToBeUpdated() {
        return this.fAnalyzer.getImplicitReceivers().size();
    }

    public boolean isVarargs() {
        return this.fDeclaration.isVarargs();
    }

    public int getVarargIndex() {
        return this.fDeclaration.parameters().size() - 1;
    }

    public TextEdit getDeleteEdit() {
        ASTRewrite rewriter = ASTRewrite.create((AST)this.fDeclaration.getAST());
        rewriter.remove((ASTNode)this.fDeclaration, null);
        return rewriter.rewriteAST(this.fDocument, this.fUnit.getJavaProject().getOptions(true));
    }

    public String[] getCodeBlocks(CallContext context) throws CoreException {
        int split;
        ASTNode last;
        ASTRewrite rewriter = ASTRewrite.create((AST)this.fDeclaration.getAST());
        this.replaceParameterWithExpression(rewriter, context.arguments);
        this.updateImplicitReceivers(rewriter, context);
        this.makeNamesUnique(rewriter, context.scope);
        this.updateTypeReferences(rewriter, context);
        this.updateStaticReferences(rewriter, context);
        this.updateTypeVariables(rewriter, context);
        this.updateMethodTypeVariable(rewriter, context);
        List ranges = null;
        ranges = this.hasReturnValue() ? (context.callMode == 41 ? this.getStatementRanges() : this.getExpressionRanges()) : ((last = this.getLastStatement()) != null && last.getNodeType() == 41 ? this.getReturnStatementRanges() : this.getStatementRanges());
        TextEdit dummy = rewriter.rewriteAST(this.fDocument, this.fUnit.getJavaProject().getOptions(true));
        int size = ranges.size();
        RangeMarker[] markers = new RangeMarker[size];
        int i = 0;
        while (i < markers.length) {
            IRegion range = (IRegion)ranges.get(i);
            markers[i] = new RangeMarker(range.getOffset(), range.getLength());
            ++i;
        }
        if (size <= 1) {
            split = Integer.MAX_VALUE;
        } else {
            IRegion region = (IRegion)ranges.get(0);
            split = region.getOffset() + region.getLength();
        }
        TextEdit[] edits = dummy.removeChildren();
        int i2 = 0;
        while (i2 < edits.length) {
            TextEdit edit = edits[i2];
            int pos = edit.getOffset() >= split ? 1 : 0;
            markers[pos].addChild(edit);
            ++i2;
        }
        MultiTextEdit root = new MultiTextEdit(0, this.fDocument.getLength());
        root.addChildren((TextEdit[])markers);
        try {
            TextEditProcessor processor = new TextEditProcessor(this.fDocument, (TextEdit)root, 3);
            UndoEdit undo = processor.performEdits();
            String[] result = this.getBlocks(markers);
            processor = new TextEditProcessor(this.fDocument, (TextEdit)undo, 2);
            processor.performEdits();
            return result;
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return new String[0];
    }

    private void replaceParameterWithExpression(ASTRewrite rewriter, String[] expressions) {
        int i = 0;
        while (i < expressions.length) {
            String expression = expressions[i];
            ParameterData parameter = this.getParameterData(i);
            List references = parameter.references();
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                ASTNode element = (ASTNode)iter.next();
                ASTNode newNode = rewriter.createStringPlaceholder(expression, element.getNodeType());
                rewriter.replace(element, newNode, null);
            }
            ++i;
        }
    }

    private void makeNamesUnique(ASTRewrite rewriter, CodeScopeBuilder.Scope scope) {
        Collection usedCalleeNames = this.fAnalyzer.getUsedNames();
        Iterator iter = usedCalleeNames.iterator();
        while (iter.hasNext()) {
            SourceAnalyzer.NameData nd = (SourceAnalyzer.NameData)iter.next();
            if (!scope.isInUse(nd.getName())) continue;
            String newName = scope.createName(nd.getName(), true);
            List references = nd.references();
            Iterator refs = references.iterator();
            while (refs.hasNext()) {
                SimpleName element = (SimpleName)refs.next();
                ASTNode newNode = rewriter.createStringPlaceholder(newName, 32);
                rewriter.replace((ASTNode)element, newNode, null);
            }
        }
    }

    private void updateImplicitReceivers(ASTRewrite rewriter, CallContext context) {
        if (context.receiver == null) {
            return;
        }
        List implicitReceivers = this.fAnalyzer.getImplicitReceivers();
        Iterator iter = implicitReceivers.iterator();
        while (iter.hasNext()) {
            Expression receiver;
            IVariableBinding vb;
            ASTNode node = (ASTNode)iter.next();
            if (node instanceof MethodInvocation) {
                MethodInvocation inv = (MethodInvocation)node;
                rewriter.set((ASTNode)inv, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, (IMethodBinding)inv.getName().resolveBinding()), null);
                continue;
            }
            if (node instanceof ClassInstanceCreation) {
                ClassInstanceCreation inst = (ClassInstanceCreation)node;
                rewriter.set((ASTNode)inst, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, inst.resolveConstructorBinding()), null);
                continue;
            }
            if (node instanceof ThisExpression) {
                rewriter.replace(node, rewriter.createStringPlaceholder(context.receiver, 32), null);
                continue;
            }
            if (node instanceof FieldAccess) {
                FieldAccess access = (FieldAccess)node;
                rewriter.set((ASTNode)access, (StructuralPropertyDescriptor)FieldAccess.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, access.resolveFieldBinding()), null);
                continue;
            }
            if (!(node instanceof SimpleName) || !(((SimpleName)node).resolveBinding() instanceof IVariableBinding) || !(vb = (IVariableBinding)((SimpleName)node).resolveBinding()).isField() || (receiver = this.createReceiver(rewriter, context, vb)) == null) continue;
            FieldAccess access = node.getAST().newFieldAccess();
            ASTNode target = rewriter.createMoveTarget(node);
            access.setName((SimpleName)target);
            access.setExpression(receiver);
            rewriter.replace(node, (ASTNode)access, null);
        }
    }

    private void updateTypeReferences(ASTRewrite rewriter, CallContext context) {
        ImportRewrite importer = context.importer;
        Iterator iter = this.fAnalyzer.getTypesToImport().iterator();
        while (iter.hasNext()) {
            Name element = (Name)iter.next();
            ITypeBinding binding = ASTNodes.getTypeBinding(element);
            if (binding == null || binding.isLocal()) continue;
            if (binding.isParameterizedType()) {
                binding = binding.getTypeDeclaration();
            }
            String s = importer.addImport(binding);
            if (ASTNodes.asString((ASTNode)element).equals(s)) continue;
            rewriter.replace((ASTNode)element, rewriter.createStringPlaceholder(s, 42), null);
        }
    }

    private void updateStaticReferences(ASTRewrite rewriter, CallContext context) {
        ImportRewrite importer = context.importer;
        Iterator iter = this.fAnalyzer.getStaticsToImport().iterator();
        while (iter.hasNext()) {
            Name element = (Name)iter.next();
            IBinding binding = element.resolveBinding();
            if (binding == null) continue;
            String s = importer.addStaticImport(binding);
            if (ASTNodes.asString((ASTNode)element).equals(s)) continue;
            rewriter.replace((ASTNode)element, rewriter.createStringPlaceholder(s, 42), null);
        }
    }

    private Expression createReceiver(ASTRewrite rewriter, CallContext context, IMethodBinding method) {
        String receiver = this.getReceiver(context, method.getModifiers());
        if (receiver == null) {
            return null;
        }
        return (Expression)rewriter.createStringPlaceholder(receiver, 32);
    }

    private Expression createReceiver(ASTRewrite rewriter, CallContext context, IVariableBinding field) {
        String receiver = this.getReceiver(context, field.getModifiers());
        if (receiver == null) {
            return null;
        }
        return (Expression)rewriter.createStringPlaceholder(receiver, 42);
    }

    private String getReceiver(CallContext context, int modifiers) {
        String receiver = context.receiver;
        ITypeBinding invocationType = ASTNodes.getEnclosingType(context.invocation);
        ITypeBinding sourceType = this.fDeclaration.resolveBinding().getDeclaringClass();
        if (!context.receiverIsStatic && Modifier.isStatic((int)modifiers)) {
            receiver = "this".equals(receiver) && invocationType != null && Bindings.equals((IBinding)invocationType, (IBinding)sourceType) ? null : context.importer.addImport(sourceType);
        }
        return receiver;
    }

    private void updateTypeVariables(ASTRewrite rewriter, CallContext context) {
        ITypeBinding type = context.getReceiverType();
        if (type == null) {
            return;
        }
        this.rewriteReferences(rewriter, type.getTypeArguments(), this.fAnalyzer.getTypeParameterReferences());
    }

    private void updateMethodTypeVariable(ASTRewrite rewriter, CallContext context) {
        IMethodBinding method = Invocations.resolveBinding(context.invocation);
        if (method == null) {
            return;
        }
        this.rewriteReferences(rewriter, method.getTypeArguments(), this.fAnalyzer.getMethodTypeParameterReferences());
    }

    private void rewriteReferences(ASTRewrite rewriter, ITypeBinding[] typeArguments, List typeParameterReferences) {
        if (typeArguments.length == 0) {
            return;
        }
        Assert.isTrue(typeArguments.length == typeParameterReferences.size());
        int i = 0;
        while (i < typeArguments.length) {
            SourceAnalyzer.NameData refData = (SourceAnalyzer.NameData)typeParameterReferences.get(i);
            List references = refData.references();
            String newName = typeArguments[i].getName();
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                SimpleName name = (SimpleName)iter.next();
                rewriter.replace((ASTNode)name, rewriter.createStringPlaceholder(newName, 42), null);
            }
            ++i;
        }
    }

    private ASTNode getLastStatement() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.isEmpty()) {
            return null;
        }
        return (ASTNode)statements.get(statements.size() - 1);
    }

    private List getReturnStatementRanges() {
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size <= 1) {
            return result;
        }
        result.add(this.createRange(statements, size - 2));
        return result;
    }

    private List getStatementRanges() {
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size == 0) {
            return result;
        }
        result.add(this.createRange(statements, size - 1));
        return result;
    }

    private List getExpressionRanges() {
        ArrayList<Object> result = new ArrayList<Object>(2);
        List statements = this.fDeclaration.getBody().statements();
        ReturnStatement rs = null;
        int size = statements.size();
        switch (size) {
            case 0: {
                return result;
            }
            case 1: {
                ASTNode node = (ASTNode)statements.get(0);
                if (node.getNodeType() == 41) {
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(new Region(node.getStartPosition(), node.getLength()));
                break;
            }
            default: {
                ASTNode node = (ASTNode)statements.get(size - 1);
                if (node.getNodeType() == 41) {
                    result.add(this.createRange(statements, size - 2));
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(this.createRange(statements, size - 1));
            }
        }
        if (rs != null) {
            Expression exp = rs.getExpression();
            result.add(new Region(exp.getStartPosition(), exp.getLength()));
        }
        return result;
    }

    private IRegion createRange(List statements, int end) {
        ASTNode first = (ASTNode)statements.get(0);
        ASTNode root = first.getRoot();
        if (root instanceof CompilationUnit) {
            CompilationUnit unit = (CompilationUnit)root;
            int start = unit.getExtendedStartPosition(first);
            ASTNode last = (ASTNode)statements.get(end);
            int length = unit.getExtendedStartPosition(last) - start + unit.getExtendedLength(last);
            Region range = new Region(start, length);
            return range;
        }
        int start = first.getStartPosition();
        ASTNode last = (ASTNode)statements.get(end);
        int length = last.getStartPosition() - start + last.getLength();
        Region range = new Region(start, length);
        return range;
    }

    private String[] getBlocks(RangeMarker[] markers) throws BadLocationException {
        String[] result = new String[markers.length];
        int i = 0;
        while (i < markers.length) {
            RangeMarker marker = markers[i];
            String content = this.fDocument.get(marker.getOffset(), marker.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, this.fUnit.getJavaProject(), false);
            result[i] = Strings.concatenate(lines, TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument));
            ++i;
        }
        return result;
    }

    private class ReturnAnalyzer
    extends ASTVisitor {
        private ReturnAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            Expression expression = node.getExpression();
            if (!ASTNodes.isLiteral(expression) && !(expression instanceof Name)) {
                SourceProvider.this.fMustEvalReturnedExpression = true;
            }
            if (Invocations.isInvocation((ASTNode)expression) || expression instanceof ClassInstanceCreation) {
                SourceProvider.this.fReturnValueNeedsLocalVariable = false;
            }
            SourceProvider.this.fReturnExpressions.add(expression);
            return false;
        }
    }

    static class VariableReferenceFinder
    extends ASTVisitor {
        private boolean fResult;
        private IVariableBinding fBinding;

        public VariableReferenceFinder(IVariableBinding binding) {
            this.fBinding = binding;
        }

        public boolean getResult() {
            return this.fResult;
        }

        public boolean visit(SimpleName node) {
            if (!this.fResult) {
                this.fResult = Bindings.equals((IBinding)this.fBinding, node.resolveBinding());
            }
            return false;
        }
    }
}

