/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.delegates;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.deprecation.CreateDeprecationFixChange;
import org.eclipse.jdt.internal.corext.refactoring.deprecation.DeprecationRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public abstract class DelegateCreator {
    public static final GroupCategorySet CATEGORY_DELEGATE = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.delegates.delegate", RefactoringCoreMessages.DelegateCreator_change_category_title, RefactoringCoreMessages.DelegateCreator_change_category_description));
    private CompilationUnitRewrite fOriginalRewrite;
    private CompilationUnitRewrite fDelegateRewrite;
    private boolean fIsMoveToAnotherFile;
    private boolean fCopy = true;
    private boolean fDeclareDeprecated = true;
    private boolean fInsertBefore = false;
    private BodyDeclaration fDeclaration;
    private String fNewElementName;
    private ITypeBinding fDestinationTypeBinding;
    private Type fDestinationType;
    private ITrackedNodePosition fTrackedPosition;
    private String fDeprecationScript;
    private CodeGenerationSettings fPreferences;

    public void setSourceRewrite(CompilationUnitRewrite rewrite) {
        this.fOriginalRewrite = rewrite;
        this.fPreferences = JavaPreferencesSettings.getCodeGenerationSettings(rewrite.getCu().getJavaProject());
        this.fDelegateRewrite = new CompilationUnitRewrite(rewrite.getCu(), rewrite.getRoot());
    }

    public void setDeclaration(BodyDeclaration declaration) {
        this.fDeclaration = declaration;
    }

    public void setNewElementName(String newName) {
        this.fNewElementName = newName;
    }

    public void setNewLocation(ITypeBinding binding) {
        this.fDestinationTypeBinding = binding;
    }

    public void setCopy(boolean isCopy) {
        this.fCopy = isCopy;
    }

    public void setDeclareDeprecated(boolean declareDeprecated) {
        this.fDeclareDeprecated = declareDeprecated;
    }

    public void setInsertBefore(boolean insertBefore) {
        this.fInsertBefore = insertBefore;
    }

    protected abstract void initialize();

    protected abstract String createRefactoringScript();

    protected abstract ASTNode createBody(BodyDeclaration var1) throws JavaModelException;

    protected abstract ASTNode createDocReference(BodyDeclaration var1) throws JavaModelException;

    protected abstract ASTNode getBodyHead(BodyDeclaration var1);

    protected abstract ChildPropertyDescriptor getJavaDocProperty();

    protected abstract ChildPropertyDescriptor getBodyProperty();

    protected boolean isMoveToAnotherFile() {
        return this.fIsMoveToAnotherFile;
    }

    protected AST getAst() {
        return this.fDelegateRewrite.getAST();
    }

    protected BodyDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    protected String getNewElementName() {
        return this.fNewElementName;
    }

    public void prepareDelegate() throws JavaModelException {
        Assert.isNotNull(this.fDelegateRewrite);
        Assert.isNotNull(this.fDeclaration);
        this.initialize();
        if (this.fDestinationTypeBinding != null) {
            this.fDestinationType = this.fOriginalRewrite.getImportRewrite().addImport(this.fDestinationTypeBinding, this.getAst());
            this.fIsMoveToAnotherFile = true;
        } else {
            this.fIsMoveToAnotherFile = false;
        }
        this.fTrackedPosition = this.fDelegateRewrite.getASTRewrite().track((ASTNode)this.fDeclaration);
        ASTNode delegateBody = this.createBody(this.fDeclaration);
        if (delegateBody != null) {
            this.fDelegateRewrite.getASTRewrite().set(this.getBodyHead(this.fDeclaration), (StructuralPropertyDescriptor)this.getBodyProperty(), (Object)delegateBody, null);
        }
        if (this.fDeclareDeprecated) {
            this.fDeprecationScript = this.createRefactoringScript();
            this.createJavadoc();
        }
    }

    protected abstract String getRefactoringScriptName();

    private void createJavadoc() throws JavaModelException {
        TagElement tag = this.getDelegateJavadocTag(this.fDeclaration);
        Javadoc comment = this.fDeclaration.getJavadoc();
        if (comment == null) {
            comment = this.getAst().newJavadoc();
            comment.tags().add(tag);
            this.fDelegateRewrite.getASTRewrite().set((ASTNode)this.fDeclaration, (StructuralPropertyDescriptor)this.getJavaDocProperty(), (Object)comment, null);
        } else {
            this.fDelegateRewrite.getASTRewrite().getListRewrite((ASTNode)comment, Javadoc.TAGS_PROPERTY).insertLast((ASTNode)tag, null);
        }
    }

    public void createEdit() throws JavaModelException {
        try {
            Document document = new Document(this.fDelegateRewrite.getCu().getBuffer().getContents());
            TextEdit edit = this.fDelegateRewrite.getASTRewrite().rewriteAST((IDocument)document, this.fDelegateRewrite.getCu().getJavaProject().getOptions(true));
            edit.apply((IDocument)document, 2);
            String newSource = Strings.trimIndentation(document.get(this.fTrackedPosition.getStartPosition(), this.fTrackedPosition.getLength()), this.fPreferences.tabWidth, this.fPreferences.indentWidth, false);
            ASTNode placeholder = this.fOriginalRewrite.getASTRewrite().createStringPlaceholder(newSource, this.fDeclaration.getNodeType());
            CategorizedTextEditGroup groupDescription = this.fOriginalRewrite.createCategorizedGroupDescription(this.getTextEditGroupLabel(), CATEGORY_DELEGATE);
            ListRewrite bodyDeclarationsListRewrite = this.fOriginalRewrite.getASTRewrite().getListRewrite(this.fDeclaration.getParent(), this.getTypeBodyDeclarationsProperty());
            if (this.fCopy) {
                if (this.fInsertBefore) {
                    bodyDeclarationsListRewrite.insertBefore(placeholder, (ASTNode)this.fDeclaration, (TextEditGroup)groupDescription);
                } else {
                    bodyDeclarationsListRewrite.insertAfter(placeholder, (ASTNode)this.fDeclaration, (TextEditGroup)groupDescription);
                }
            } else {
                bodyDeclarationsListRewrite.replace((ASTNode)this.fDeclaration, placeholder, (TextEditGroup)groupDescription);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    protected abstract String getTextEditGroupLabel();

    public Change createChange() {
        IPath path;
        String name;
        Assert.isNotNull(this.fDelegateRewrite);
        if (this.fDeprecationScript != null && (name = this.getRefactoringScriptName()) != null && (path = DeprecationRefactorings.getRefactoringScriptFile(this.fDelegateRewrite.getCu().getJavaProject(), name).getFullPath()) != null) {
            return new CreateDeprecationFixChange(path, this.fDeprecationScript, BindingLabelProvider.getBindingLabel(this.getDeclarationBinding(), JavaElementLabels.ALL_DEFAULT));
        }
        return null;
    }

    protected abstract IBinding getDeclarationBinding();

    public CompilationUnitRewrite getDelegateRewrite() {
        return this.fDelegateRewrite;
    }

    private TagElement getDelegateJavadocTag(BodyDeclaration declaration) throws JavaModelException {
        Assert.isNotNull(declaration);
        String msg = RefactoringCoreMessages.DelegateCreator_use_member_instead;
        int firstParam = msg.indexOf("{0}");
        Assert.isTrue(firstParam != -1);
        ArrayList<Object> fragments = new ArrayList<Object>();
        TextElement text = this.getAst().newTextElement();
        text.setText(msg.substring(0, firstParam).trim());
        fragments.add(text);
        fragments.add(this.createJavadocMemberReferenceTag(declaration, this.getAst()));
        text = this.getAst().newTextElement();
        text.setText(msg.substring(firstParam + 3).trim());
        fragments.add(text);
        TagElement tag = this.getAst().newTagElement();
        tag.setTagName("@deprecated");
        tag.fragments().addAll(fragments);
        return tag;
    }

    private TagElement createJavadocMemberReferenceTag(BodyDeclaration declaration, AST ast) throws JavaModelException {
        Assert.isNotNull(ast);
        Assert.isNotNull(declaration);
        ASTNode javadocReference = this.createDocReference(declaration);
        TagElement element = ast.newTagElement();
        element.setTagName("@link");
        element.fragments().add(javadocReference);
        return element;
    }

    protected Expression getAccess() {
        return this.isMoveToAnotherFile() ? this.createDestinationTypeName() : null;
    }

    protected Name createDestinationTypeName() {
        return ASTNodeFactory.newName(this.getAst(), ASTNodes.asString((ASTNode)this.fDestinationType));
    }

    private ChildListPropertyDescriptor getTypeBodyDeclarationsProperty() {
        ASTNode parent = this.fDeclaration.getParent();
        if (parent instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)parent).getBodyDeclarationsProperty();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue(false);
        return null;
    }
}

