/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.delegates;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateCreator;
import org.eclipse.jdt.internal.corext.refactoring.deprecation.DeprecationRefactorings;

public class DelegateFieldCreator
extends DelegateCreator {
    private VariableDeclarationFragment fOldFieldFragment;

    protected void initialize() {
        Assert.isTrue(this.getDeclaration() instanceof FieldDeclaration);
        Assert.isTrue(((FieldDeclaration)this.getDeclaration()).fragments().size() == 1);
        this.fOldFieldFragment = (VariableDeclarationFragment)((FieldDeclaration)this.getDeclaration()).fragments().get(0);
        if (this.getNewElementName() == null) {
            this.setNewElementName(this.fOldFieldFragment.getName().getIdentifier());
        }
        this.setInsertBefore(false);
    }

    protected ASTNode createBody(BodyDeclaration fd) throws JavaModelException {
        FieldDeclaration result = (FieldDeclaration)fd;
        Expression initializer = this.createDelegateFieldInitializer(result);
        return initializer;
    }

    protected ASTNode createDocReference(BodyDeclaration declaration) {
        MemberRef ref = this.getAst().newMemberRef();
        ref.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            ref.setQualifier(this.createDestinationTypeName());
        }
        return ref;
    }

    protected ASTNode getBodyHead(BodyDeclaration result) {
        return this.fOldFieldFragment;
    }

    protected ChildPropertyDescriptor getJavaDocProperty() {
        return FieldDeclaration.JAVADOC_PROPERTY;
    }

    protected ChildPropertyDescriptor getBodyProperty() {
        return VariableDeclarationFragment.INITIALIZER_PROPERTY;
    }

    protected IBinding getDeclarationBinding() {
        return this.fOldFieldFragment.resolveBinding();
    }

    protected String createRefactoringScript() {
        IVariableBinding binding = this.fOldFieldFragment.resolveBinding();
        if (binding != null && binding.isField()) {
            return DeprecationRefactorings.createInlineDeprecationScript((IBinding)binding);
        }
        return null;
    }

    protected String getRefactoringScriptName() {
        IVariableBinding binding = this.fOldFieldFragment.resolveBinding();
        if (binding != null) {
            return DeprecationRefactorings.getFieldScriptName(binding);
        }
        return null;
    }

    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateFieldCreator_text_edit_group_label;
    }

    private Expression createDelegateFieldInitializer(FieldDeclaration declaration) throws JavaModelException {
        Assert.isNotNull(declaration);
        Expression qualification = this.getAccess();
        if (qualification != null) {
            FieldAccess access = this.getAst().newFieldAccess();
            access.setExpression(qualification);
            access.setName(this.getAst().newSimpleName(this.getNewElementName()));
            return access;
        }
        SimpleName access = this.getAst().newSimpleName(this.getNewElementName());
        return access;
    }
}

