/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.composite.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;

public final class ExtractSupertypeProcessor
extends PullUpRefactoringProcessor {
    private static final String ATTRIBUTE_TYPES = "types";
    private static final String ID_EXTRACT_SUPERTYPE = "org.eclipse.jdt.ui.extract.supertype";
    private static final GroupCategorySet SET_EXTRACT_SUPERTYPE = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.extractSupertype", RefactoringCoreMessages.ExtractSupertypeProcessor_category_name, RefactoringCoreMessages.ExtractSupertypeProcessor_category_description));
    private final Map fLayerChanges = new HashMap();
    private IType[] fPossibleCandidates = new IType[0];
    private String fSuperSource;
    private String fTypeName = "";
    private IType[] fTypesToExtract = new IType[0];

    public ExtractSupertypeProcessor(IMember[] members, CodeGenerationSettings settings) {
        super(members, settings, true);
        IType declaring;
        if (members != null && (declaring = this.getDeclaringType()) != null) {
            this.fTypesToExtract = new IType[]{declaring};
        }
    }

    protected final RefactoringStatus checkDeclaringSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkExtractedCompilationUnit() {
        RefactoringStatus status = new RefactoringStatus();
        ICompilationUnit cu = this.getDeclaringType().getCompilationUnit();
        if (this.fTypeName == null || "".equals(this.fTypeName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        status.merge(Checks.checkTypeName(this.fTypeName));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitName(JavaModelUtil.getRenamedCUName(cu, this.fTypeName)));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitNewName(cu, this.fTypeName));
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        block3: {
            RefactoringStatus refactoringStatus;
            RefactoringStatus status = new RefactoringStatus();
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_checking);
                status.merge(this.checkExtractedCompilationUnit());
                if (!status.hasFatalError()) break block3;
                refactoringStatus = status;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1), context);
        Object var4_7 = null;
        monitor.done();
        return refactoringStatus;
    }

    public IType computeExtractedType(String name) {
        if (name != null && !name.equals("")) {
            IType declaring = this.getDeclaringType();
            try {
                ICompilationUnit[] units = declaring.getPackageFragment().getCompilationUnits(this.fOwner);
                String newName = JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), name);
                ICompilationUnit result = null;
                int index = 0;
                while (index < units.length) {
                    if (units[index].getElementName().equals(newName)) {
                        result = units[index];
                    }
                    ++index;
                }
                if (result != null) {
                    IType type = result.getType(name);
                    this.setDestinationType(type);
                    return type;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        return null;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            DynamicValidationStateChange change = new DynamicValidationStateChange(RefactoringCoreMessages.ExtractSupertypeProcessor_extract_supertype, (Change[])this.fChangeManager.getAllChanges()){

                public final ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String project = null;
                    IType declaring = ExtractSupertypeProcessor.this.getDeclaringType();
                    IJavaProject javaProject = declaring.getJavaProject();
                    if (javaProject != null) {
                        project = javaProject.getElementName();
                    }
                    int flags = 589830;
                    try {
                        if (declaring.isLocal() || declaring.isAnonymous()) {
                            flags |= 0x40000;
                        }
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                    }
                    JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ExtractSupertypeProcessor.ID_EXTRACT_SUPERTYPE, project, Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)ExtractSupertypeProcessor.this.fDestinationType, JavaElementLabels.ALL_DEFAULT), JavaElementLabels.getElementLabel((IJavaElement)ExtractSupertypeProcessor.this.fCachedDeclaringType, JavaElementLabels.ALL_FULLY_QUALIFIED)}), ExtractSupertypeProcessor.this.getComment(), arguments, flags);
                    arguments.put("input", descriptor.elementToHandle((IJavaElement)ExtractSupertypeProcessor.this.fDestinationType));
                    arguments.put("replace", Boolean.valueOf(ExtractSupertypeProcessor.this.fReplace).toString());
                    arguments.put("instanceof", Boolean.valueOf(ExtractSupertypeProcessor.this.fInstanceOf).toString());
                    if (ExtractSupertypeProcessor.this.fCachedDeclaringType != null) {
                        arguments.put("element1", descriptor.elementToHandle((IJavaElement)ExtractSupertypeProcessor.this.fCachedDeclaringType));
                    }
                    arguments.put("name", ExtractSupertypeProcessor.this.fTypeName);
                    arguments.put("pull", new Integer(ExtractSupertypeProcessor.this.fMembersToMove.length).toString());
                    int offset = 0;
                    while (offset < ExtractSupertypeProcessor.this.fMembersToMove.length) {
                        arguments.put("element" + (offset + 2), descriptor.elementToHandle((IJavaElement)ExtractSupertypeProcessor.this.fMembersToMove[offset]));
                        ++offset;
                    }
                    arguments.put("delete", new Integer(ExtractSupertypeProcessor.this.fDeletedMethods.length).toString());
                    offset = 0;
                    while (offset < ExtractSupertypeProcessor.this.fDeletedMethods.length) {
                        arguments.put("element" + (offset + ExtractSupertypeProcessor.this.fMembersToMove.length + 2), descriptor.elementToHandle((IJavaElement)ExtractSupertypeProcessor.this.fDeletedMethods[offset]));
                        ++offset;
                    }
                    arguments.put("abstract", new Integer(ExtractSupertypeProcessor.this.fAbstractMethods.length).toString());
                    offset = 0;
                    while (offset < ExtractSupertypeProcessor.this.fAbstractMethods.length) {
                        arguments.put("element" + (offset + ExtractSupertypeProcessor.this.fMembersToMove.length + ExtractSupertypeProcessor.this.fDeletedMethods.length + 2), descriptor.elementToHandle((IJavaElement)ExtractSupertypeProcessor.this.fAbstractMethods[offset]));
                        ++offset;
                    }
                    arguments.put(ExtractSupertypeProcessor.ATTRIBUTE_TYPES, new Integer(ExtractSupertypeProcessor.this.fTypesToExtract.length).toString());
                    offset = 0;
                    while (offset < ExtractSupertypeProcessor.this.fTypesToExtract.length) {
                        arguments.put("element" + (offset + ExtractSupertypeProcessor.this.fMembersToMove.length + ExtractSupertypeProcessor.this.fDeletedMethods.length + ExtractSupertypeProcessor.this.fAbstractMethods.length + 2), descriptor.elementToHandle((IJavaElement)ExtractSupertypeProcessor.this.fTypesToExtract[offset]));
                        ++offset;
                    }
                    arguments.put("stubs", Boolean.valueOf(ExtractSupertypeProcessor.this.fCreateMethodStubs).toString());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
                }
            };
            IType declaring = this.getDeclaringType();
            IFile file = ResourceUtil.getFile(declaring.getCompilationUnit());
            if (this.fSuperSource != null && this.fSuperSource.length() > 0) {
                change.add(new CreateCompilationUnitChange(declaring.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), this.fTypeName)), this.fSuperSource, file.getCharset(false)));
            }
            dynamicValidationStateChange = change;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            this.clearCaches();
            this.clearWorkingCopies();
            throw throwable;
        }
        monitor.done();
        this.clearCaches();
        this.clearWorkingCopies();
        return dynamicValidationStateChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RefactoringStatus createExtractedSuperType(IType superType, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 20);
            this.fSuperSource = null;
            ICompilationUnit extractedWorkingCopy = null;
            try {
                IType declaring = this.getDeclaringType();
                CompilationUnitRewrite declaringRewrite = new CompilationUnitRewrite(this.fOwner, declaring.getCompilationUnit());
                AbstractTypeDeclaration declaringDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(declaring, declaringRewrite.getRoot());
                if (declaringDeclaration != null) {
                    extractedWorkingCopy = declaring.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), this.fTypeName)).getWorkingCopy(this.fOwner, null, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    this.fSuperSource = this.createSuperTypeSource(extractedWorkingCopy, superType, declaringDeclaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    if (this.fSuperSource != null) {
                        extractedWorkingCopy.getBuffer().setContents(this.fSuperSource);
                        JavaModelUtil.reconcile(extractedWorkingCopy);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.fWorkingCopies.add(extractedWorkingCopy);
                throw throwable;
            }
            {
                Object var8_10 = null;
                this.fWorkingCopies.add(extractedWorkingCopy);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        monitor.done();
        return status;
    }

    protected final void createModifiedSubType(ICompilationUnit unit, CompilationUnit root, IType extractedType, ITypeBinding extractedBinding, AbstractTypeDeclaration subDeclaration, RefactoringStatus status) {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)subDeclaration);
        Assert.isNotNull((Object)extractedType);
        try {
            ICompilationUnit copy;
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fOwner, unit, root);
            this.createTypeSignature(rewrite, subDeclaration, extractedType, extractedBinding, (IProgressMonitor)new NullProgressMonitor());
            Document document = new Document(unit.getBuffer().getContents());
            CompilationUnitChange change = rewrite.createChange();
            if (change != null) {
                this.fLayerChanges.put(unit.getPrimary(), change);
                TextEdit edit = change.getEdit();
                if (edit != null) {
                    TextEditCopier copier = new TextEditCopier(edit);
                    TextEdit copy2 = copier.perform();
                    copy2.apply((IDocument)document, 0);
                }
            }
            if ((copy = unit.findWorkingCopy(this.fOwner)) == null) {
                copy = unit.getWorkingCopy(this.fOwner, null, (IProgressMonitor)new NullProgressMonitor());
                this.fWorkingCopies.add(copy);
            }
            copy.getBuffer().setContents(document.get());
            JavaModelUtil.reconcile(copy);
        }
        catch (CoreException exception) {
            JavaPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
    }

    protected final void createNecessaryConstructors(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration targetDeclaration, RefactoringStatus status) {
        ITypeBinding binding;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)targetDeclaration);
        if (superType != null && (binding = targetDeclaration.resolveBinding()) != null && binding.isClass()) {
            IMethodBinding[] bindings = StubUtility2.getVisibleConstructors(binding, true, true);
            int deprecationCount = 0;
            int i = 0;
            while (i < bindings.length) {
                if (bindings[i].isDeprecated()) {
                    ++deprecationCount;
                }
                ++i;
            }
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            if (rewrite != null) {
                boolean createDeprecated = deprecationCount == bindings.length;
                int i2 = 0;
                while (i2 < bindings.length) {
                    IMethodBinding curr = bindings[i2];
                    if (!curr.isDeprecated() || createDeprecated) {
                        try {
                            MethodDeclaration stub = StubUtility2.createConstructorStub(targetRewrite.getCu(), targetRewrite.getASTRewrite(), targetRewrite.getImportRewrite(), curr, binding.getName(), 1, false, false, this.fSettings);
                            if (stub != null) {
                                rewrite.insertLast((ASTNode)stub, null);
                            }
                        }
                        catch (CoreException exception) {
                            JavaPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                        }
                    }
                    ++i2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String createSuperTypeSource(ICompilationUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)extractedWorkingCopy);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        String source = null;
        try {
            monitor.beginTask("", 2);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
            IType declaring = this.getDeclaringType();
            String delimiter = StubUtility.getLineDelimiterUsed(extractedWorkingCopy.getJavaProject());
            String typeComment = null;
            String fileComment = null;
            if (this.fSettings.createComments) {
                ITypeParameter[] parameters = declaring.getTypeParameters();
                String[] names = new String[parameters.length];
                int index = 0;
                while (true) {
                    if (index >= parameters.length) {
                        typeComment = CodeGeneration.getTypeComment(extractedWorkingCopy, this.fTypeName, names, delimiter);
                        fileComment = CodeGeneration.getFileComment(extractedWorkingCopy, delimiter);
                        break;
                    }
                    names[index] = parameters[index].getElementName();
                    ++index;
                }
            }
            StringBuffer buffer = new StringBuffer(64);
            this.createTypeDeclaration(extractedWorkingCopy, superType, declaringDeclaration, typeComment, buffer, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            String imports = this.createTypeImports(extractedWorkingCopy, monitor);
            source = this.createTypeTemplate(extractedWorkingCopy, imports, fileComment, "", buffer.toString());
            if (source == null) {
                if (!declaring.getPackageFragment().isDefaultPackage()) {
                    if (imports.length() > 0) {
                        buffer.insert(0, imports);
                    }
                    buffer.insert(0, "package " + declaring.getPackageFragment().getElementName() + ";");
                }
                source = buffer.toString();
            }
            Document document = new Document(source);
            TextEdit edit = CodeFormatterUtil.format2(8, source, 0, delimiter, extractedWorkingCopy.getJavaProject().getOptions(true));
            if (edit != null) {
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                }
                source = document.get();
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var16_20 = null;
        }
        monitor.done();
        return source;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createTypeDeclaration(ICompilationUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, String comment, StringBuffer buffer, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)extractedWorkingCopy);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)buffer);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
            IJavaProject project = extractedWorkingCopy.getJavaProject();
            String delimiter = StubUtility.getLineDelimiterUsed(project);
            if (comment != null && !"".equals(comment)) {
                buffer.append(comment);
                buffer.append(delimiter);
            }
            buffer.append("public");
            buffer.append(' ');
            buffer.append("class ");
            buffer.append(this.fTypeName);
            if (superType != null) {
                buffer.append(' ');
                if (superType.isInterface()) {
                    buffer.append("implements ");
                } else {
                    buffer.append("extends ");
                }
                buffer.append(superType.getElementName());
            }
            buffer.append(" {");
            buffer.append(delimiter);
            buffer.append(delimiter);
            buffer.append('}');
            String string = buffer.toString();
            extractedWorkingCopy.getBuffer().setContents(string);
            Document document = new Document(string);
            CompilationUnitRewrite targetRewrite = new CompilationUnitRewrite(this.fOwner, extractedWorkingCopy);
            AbstractTypeDeclaration targetDeclaration = (AbstractTypeDeclaration)targetRewrite.getRoot().types().get(0);
            this.createTypeParameters(targetRewrite, superType, declaringDeclaration, targetDeclaration);
            this.createTypeSignature(targetRewrite, superType, declaringDeclaration, targetDeclaration);
            this.createNecessaryConstructors(targetRewrite, superType, targetDeclaration, status);
            TextEdit edit = targetRewrite.createChange().getEdit();
            try {
                edit.apply((IDocument)document, 2);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            buffer.setLength(0);
            buffer.append(document.get());
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var16_19 = null;
        }
        monitor.done();
    }

    protected final void createTypeParameters(CompilationUnitRewrite targetRewrite, IType subType, AbstractTypeDeclaration sourceDeclaration, AbstractTypeDeclaration targetDeclaration) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)sourceDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (sourceDeclaration instanceof TypeDeclaration) {
            TypeParameter parameter = null;
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            Iterator iterator = ((TypeDeclaration)sourceDeclaration).typeParameters().iterator();
            while (iterator.hasNext()) {
                parameter = (TypeParameter)iterator.next();
                ASTNode node = ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)parameter);
                rewrite.insertLast(node, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createTypeSignature(CompilationUnitRewrite subRewrite, AbstractTypeDeclaration declaration, IType extractedType, ITypeBinding extractedBinding, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)subRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)extractedType);
        Assert.isNotNull((Object)monitor);
        try {
            ITypeParameter[] parameters;
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 10);
            AST ast = subRewrite.getAST();
            Type type = null;
            if (extractedBinding != null) {
                type = subRewrite.getImportRewrite().addImport(extractedBinding, ast);
            } else {
                subRewrite.getImportRewrite().addImport(extractedType.getFullyQualifiedName('.'));
                type = ast.newSimpleType((Name)ast.newSimpleName(extractedType.getElementName()));
            }
            subRewrite.getImportRemover().registerAddedImport(extractedType.getFullyQualifiedName('.'));
            if (type != null && (parameters = extractedType.getTypeParameters()).length > 0) {
                ParameterizedType parameterized = ast.newParameterizedType(type);
                int index = 0;
                while (index < parameters.length) {
                    parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getElementName())));
                    ++index;
                }
                type = parameterized;
            }
            ASTRewrite rewriter = subRewrite.getASTRewrite();
            if (type != null && declaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)declaration;
                Type superClass = extended.getSuperclassType();
                if (superClass != null) {
                    rewriter.replace((ASTNode)superClass, (ASTNode)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                } else {
                    rewriter.set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                }
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected final void createTypeSignature(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration declaringDeclaration, AbstractTypeDeclaration targetDeclaration) {
        TypeDeclaration declaration;
        Type superclassType;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (declaringDeclaration instanceof TypeDeclaration && (superclassType = (declaration = (TypeDeclaration)declaringDeclaration).getSuperclassType()) != null) {
            Type type = null;
            ITypeBinding binding = superclassType.resolveBinding();
            if (binding != null) {
                type = targetRewrite.getImportRewrite().addImport(binding, targetRewrite.getAST());
                targetRewrite.getImportRemover().registerAddedImports(type);
            }
            if (type != null && targetDeclaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)targetDeclaration;
                Type targetSuperType = extended.getSuperclassType();
                if (targetSuperType != null) {
                    targetRewrite.getASTRewrite().replace((ASTNode)targetSuperType, (ASTNode)type, null);
                } else {
                    targetRewrite.getASTRewrite().set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, null);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus createWorkingCopyLayer(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        if (this.fWorkingCopiesCreated) {
            return new RefactoringStatus();
        }
        RefactoringStatus status = new RefactoringStatus();
        try {
            try {
                AbstractTypeDeclaration extractDeclaration;
                monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 70);
                status.merge(super.createWorkingCopyLayer((IProgressMonitor)new SubProgressMonitor(monitor, 10)));
                IType declaring = this.getDeclaringType();
                status.merge(this.createExtractedSuperType(this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 10)).getSuperclass(declaring), (IProgressMonitor)new SubProgressMonitor(monitor, 10)));
                if (status.hasFatalError()) {
                    RefactoringStatus refactoringStatus = status;
                    Object var24_6 = null;
                    this.fWorkingCopiesCreated = true;
                    monitor.done();
                    return refactoringStatus;
                }
                IType extractedType = this.computeExtractedType(this.fTypeName);
                this.setDestinationType(extractedType);
                ArrayList<IType> subTypes = new ArrayList<IType>(Arrays.asList(this.fTypesToExtract));
                if (!subTypes.contains(declaring)) {
                    subTypes.add(declaring);
                }
                HashMap<ICompilationUnit, ArrayList<IType>> unitToTypes = new HashMap<ICompilationUnit, ArrayList<IType>>(subTypes.size());
                HashSet<ICompilationUnit> units = new HashSet<ICompilationUnit>(subTypes.size());
                int index = 0;
                while (index < subTypes.size()) {
                    IType type = (IType)subTypes.get(index);
                    ICompilationUnit unit = type.getCompilationUnit();
                    units.add(unit);
                    ArrayList<IType> collection = (ArrayList<IType>)unitToTypes.get(unit);
                    if (collection == null) {
                        collection = new ArrayList<IType>(2);
                        unitToTypes.put(unit, collection);
                    }
                    collection.add(type);
                    ++index;
                }
                HashMap<IJavaProject, ArrayList<ICompilationUnit>> projectToUnits = new HashMap<IJavaProject, ArrayList<ICompilationUnit>>();
                Collection collection = null;
                IJavaProject project = null;
                ICompilationUnit current = null;
                Iterator iterator = units.iterator();
                while (iterator.hasNext()) {
                    current = (ICompilationUnit)iterator.next();
                    project = current.getJavaProject();
                    collection = (ArrayList<ICompilationUnit>)projectToUnits.get(project);
                    if (collection == null) {
                        collection = new ArrayList<ICompilationUnit>();
                        projectToUnits.put(project, (ArrayList<ICompilationUnit>)collection);
                    }
                    collection.add(current);
                }
                ITypeBinding[] extractBindings = new ITypeBinding[1];
                ASTParser extractParser = ASTParser.newParser((int)3);
                extractParser.setWorkingCopyOwner(this.fOwner);
                extractParser.setResolveBindings(true);
                extractParser.setProject(project);
                extractParser.setSource(extractedType.getCompilationUnit());
                CompilationUnit extractUnit = (CompilationUnit)extractParser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (extractUnit != null && (extractDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(extractedType, extractUnit)) != null) {
                    extractBindings[0] = extractDeclaration.resolveBinding();
                }
                ASTParser parser = ASTParser.newParser((int)3);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
                try {
                    Set keySet = projectToUnits.keySet();
                    subMonitor.beginTask("", keySet.size());
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                    Iterator iterator2 = keySet.iterator();
                    while (iterator2.hasNext()) {
                        Object var20_26;
                        project = (IJavaProject)iterator2.next();
                        collection = (Collection)projectToUnits.get(project);
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                        try {
                            subsubMonitor.beginTask("", collection.size());
                            subsubMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                            parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, unitToTypes, extractedType, extractBindings, status){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                private final /* synthetic */ Map val$unitToTypes;
                                private final /* synthetic */ IType val$extractedType;
                                private final /* synthetic */ ITypeBinding[] val$extractBindings;
                                private final /* synthetic */ RefactoringStatus val$status;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                    this.val$unitToTypes = map;
                                    this.val$extractedType = iType;
                                    this.val$extractBindings = iTypeBindingArray;
                                    this.val$status = refactoringStatus;
                                }

                                /*
                                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                    try {
                                        try {
                                            Collection types = (Collection)this.val$unitToTypes.get(unit);
                                            if (types != null) {
                                                Iterator innerIterator = types.iterator();
                                                while (innerIterator.hasNext()) {
                                                    IType currentType = (IType)innerIterator.next();
                                                    AbstractTypeDeclaration currentDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(currentType, node);
                                                    if (currentDeclaration == null) continue;
                                                    ExtractSupertypeProcessor.this.createModifiedSubType(unit, node, this.val$extractedType, this.val$extractBindings[0], currentDeclaration, this.val$status);
                                                }
                                            }
                                        }
                                        catch (CoreException exception) {
                                            JavaPlugin.log(exception);
                                            this.val$status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_9 = null;
                                        this.val$subsubMonitor.worked(1);
                                        throw throwable;
                                    }
                                    {
                                        Object var7_10 = null;
                                    }
                                    this.val$subsubMonitor.worked(1);
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)subsubMonitor);
                            var20_26 = null;
                        }
                        catch (Throwable throwable) {
                            var20_26 = null;
                            subsubMonitor.done();
                            throw throwable;
                        }
                        subsubMonitor.done();
                    }
                    Object var22_30 = null;
                    subMonitor.done();
                }
                catch (Throwable throwable) {
                    Object var22_29 = null;
                    subMonitor.done();
                    throw throwable;
                }
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            Object var24_8 = null;
            this.fWorkingCopiesCreated = true;
        }
        catch (Throwable throwable) {
            Object var24_7 = null;
            this.fWorkingCopiesCreated = true;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroyWorkingCopyLayer() {
        try {
            this.fLayerChanges.clear();
            Iterator iterator = this.fWorkingCopies.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit unit = (ICompilationUnit)iterator.next();
                try {
                    unit.discardWorkingCopy();
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fSuperSource = null;
            this.fWorkingCopies.clear();
            this.fWorkingCopiesCreated = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.fSuperSource = null;
            this.fWorkingCopies.clear();
            this.fWorkingCopiesCreated = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IType[] getCandidateTypes(RefactoringStatus status, IProgressMonitor monitor) {
        IType declaring;
        Assert.isNotNull((Object)monitor);
        if (this.fPossibleCandidates != null) {
            if (this.fPossibleCandidates.length != 0) return this.fPossibleCandidates;
        }
        if ((declaring = this.getDeclaringType()) == null) return this.fPossibleCandidates;
        try {
            try {
                monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_computing_possible_types, 10);
                IType superType = this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).getSuperclass(declaring);
                if (superType != null) {
                    this.fPossibleCandidates = superType.newTypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 9, 2)).getSubtypes(superType);
                    LinkedList<IType> list = new LinkedList<IType>(Arrays.asList(this.fPossibleCandidates));
                    HashSet<String> names = new HashSet<String>();
                    Iterator iterator = list.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.fPossibleCandidates = list.toArray(new IType[list.size()]);
                        }
                        IType type = (IType)iterator.next();
                        if (type.isReadOnly() || type.isBinary() || type.isAnonymous() || !type.isClass() || names.contains(type.getFullyQualifiedName())) {
                            iterator.remove();
                            continue;
                        }
                        names.add(type.getFullyQualifiedName());
                    }
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        monitor.done();
        return this.fPossibleCandidates;
    }

    public IType getExtractedType() {
        return this.getDestinationType();
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public IType[] getTypesToExtract() {
        return this.fTypesToExtract;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof JavaRefactoringArguments)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void registerChanges(TextEditBasedChangeManager manager) throws CoreException {
        try {
            int index;
            ICompilationUnit[] units;
            ICompilationUnit extractedUnit = this.getExtractedType().getCompilationUnit().getPrimary();
            ICompilationUnit unit = null;
            CompilationUnitRewrite rewrite = null;
            Iterator<Object> iterator = this.fCompilationUnitRewrites.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                unit = (ICompilationUnit)iterator.next();
                if (unit.getPrimary().equals(extractedUnit) || (rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit)) == null) continue;
                CompilationUnitChange layerChange = (CompilationUnitChange)((Object)this.fLayerChanges.get(unit.getPrimary()));
                CompilationUnitChange rewriteChange = rewrite.createChange();
                if (rewriteChange != null && layerChange != null) {
                    MultiStateCompilationUnitChange change = new MultiStateCompilationUnitChange(rewriteChange.getName(), unit);
                    change.addChange((TextChange)layerChange);
                    change.addChange((TextChange)rewriteChange);
                    this.fLayerChanges.remove(unit.getPrimary());
                    manager.manage(unit, (TextEditBasedChange)change);
                    continue;
                }
                if (layerChange != null) {
                    manager.manage(unit, (TextEditBasedChange)layerChange);
                    this.fLayerChanges.remove(unit.getPrimary());
                    continue;
                }
                if (rewriteChange == null) continue;
                manager.manage(unit, (TextEditBasedChange)rewriteChange);
            }
            iterator = this.fLayerChanges.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    units = manager.getAllCompilationUnits();
                    index = 0;
                    break;
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                manager.manage((ICompilationUnit)entry.getKey(), (TextEditBasedChange)entry.getValue());
            }
            while (index < units.length) {
                if (units[index].getPath().equals((Object)extractedUnit.getPath())) {
                    manager.remove(units[index]);
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.fLayerChanges.clear();
            throw throwable;
        }
        {
            Object var9_12 = null;
            this.fLayerChanges.clear();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void rewriteTypeOccurrences(final TextEditBasedChangeManager manager, final CompilationUnitRewrite sourceRewrite, ICompilationUnit copy, final Set replacements, final RefactoringStatus status, final IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 20);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_checking);
            final IType declaring = this.getDeclaringType();
            final ICompilationUnit destinationUnit = this.getDestinationType().getCompilationUnit();
            IJavaProject project = declaring.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setWorkingCopyOwner(this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
            parser.createASTs(new ICompilationUnit[]{copy}, new String[0], new ASTRequestor(){

                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                    block8: {
                        try {
                            TextEdit edit;
                            TextEditBasedChange change;
                            ITypeBinding subBinding;
                            IType subType = (IType)JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)declaring);
                            AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subType, node);
                            if (subDeclaration == null || (subBinding = subDeclaration.resolveBinding()) == null) break block8;
                            String name = null;
                            ITypeBinding superBinding = null;
                            ITypeBinding[] superBindings = Bindings.getAllSuperTypes(subBinding);
                            int index = 0;
                            while (index < superBindings.length) {
                                name = superBindings[index].getName();
                                if (name.startsWith(ExtractSupertypeProcessor.this.fDestinationType.getElementName())) {
                                    superBinding = superBindings[index];
                                }
                                ++index;
                            }
                            if (superBinding == null) break block8;
                            ExtractSupertypeProcessor.this.solveSuperTypeConstraints(unit, node, subType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 14), status);
                            if (!status.hasFatalError()) {
                                ExtractSupertypeProcessor.this.rewriteTypeOccurrences(manager, this, sourceRewrite, unit, node, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                            }
                            if (!manager.containsChangesIn(destinationUnit) || !((change = manager.get(destinationUnit)) instanceof TextChange) || (edit = ((TextChange)change).getEdit()) == null) break block8;
                            Document document = new Document(destinationUnit.getBuffer().getContents());
                            try {
                                edit.apply((IDocument)document, 2);
                            }
                            catch (MalformedTreeException exception) {
                                JavaPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception));
                            }
                            catch (BadLocationException exception) {
                                JavaPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception));
                            }
                            ExtractSupertypeProcessor.this.fSuperSource = document.get();
                            manager.remove(destinationUnit);
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception));
                        }
                    }
                }

                public final void acceptBinding(String key, IBinding binding) {
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        monitor.done();
    }

    public void setTypeName(String name) {
        Assert.isNotNull((Object)name);
        this.fTypeName = name;
    }

    public void setTypesToExtract(IType[] types) {
        Assert.isNotNull((Object)types);
        this.fTypesToExtract = types;
    }
}

