/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ISourceConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.TextEditGroup;

public final class UseSuperTypeProcessor
extends SuperTypeRefactoringProcessor {
    public static final String ID_USE_SUPERTYPE = "org.eclipse.jdt.ui.use.supertype";
    private static final String IDENTIFIER = "org.eclipse.jdt.ui.useSuperTypeProcessor";
    private TextEditBasedChangeManager fChangeManager = null;
    private int fChanges = 0;
    private IType fSubType;
    private IType fSuperType = null;

    protected static ITypeBinding findTypeInHierarchy(ITypeBinding type, String name) {
        ITypeBinding result;
        if (type.isArray() || type.isPrimitive()) {
            return null;
        }
        if (name.equals(type.getTypeDeclaration().getQualifiedName())) {
            return type;
        }
        ITypeBinding binding = type.getSuperclass();
        if (binding != null && (result = UseSuperTypeProcessor.findTypeInHierarchy(binding, name)) != null) {
            return result;
        }
        ITypeBinding[] bindings = type.getInterfaces();
        int index = 0;
        while (index < bindings.length) {
            ITypeBinding result2 = UseSuperTypeProcessor.findTypeInHierarchy(bindings[index], name);
            if (result2 != null) {
                return result2;
            }
            ++index;
        }
        return null;
    }

    public UseSuperTypeProcessor(IType subType) {
        super(null);
        this.fSubType = subType;
    }

    public UseSuperTypeProcessor(IType subType, IType superType) {
        super(null);
        this.fSubType = subType;
        this.fSuperType = superType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status;
        block3: {
            RefactoringStatus refactoringStatus;
            Assert.isNotNull(monitor);
            Assert.isNotNull(context);
            status = new RefactoringStatus();
            this.fChangeManager = new TextEditBasedChangeManager();
            try {
                RefactoringStatus validation;
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_checking);
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                if (status.hasFatalError() || (validation = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext())).isOK()) break block3;
                refactoringStatus = validation;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return refactoringStatus;
        }
        Object var5_8 = null;
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull(monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_checking);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        block3: {
            DynamicValidationStateChange dynamicValidationStateChange;
            Assert.isNotNull(monitor);
            try {
                this.fChanges = 0;
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                TextEditBasedChange[] changes = this.fChangeManager.getAllChanges();
                if (changes == null || changes.length == 0) break block3;
                this.fChanges = changes.length;
                dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.UseSupertypeWherePossibleRefactoring_name, (Change[])this.fChangeManager.getAllChanges()){

                    public final ChangeDescriptor getDescriptor() {
                        HashMap<String, String> arguments = new HashMap<String, String>();
                        IJavaProject project = null;
                        if (!UseSuperTypeProcessor.this.fSubType.isBinary()) {
                            project = UseSuperTypeProcessor.this.fSubType.getJavaProject();
                        }
                        int flags = 589830;
                        try {
                            if (UseSuperTypeProcessor.this.fSubType.isLocal() || UseSuperTypeProcessor.this.fSubType.isAnonymous()) {
                                flags |= 0x40000;
                            }
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                        }
                        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(UseSuperTypeProcessor.ID_USE_SUPERTYPE, project != null ? project.getElementName() : null, Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)UseSuperTypeProcessor.this.fSuperType, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)UseSuperTypeProcessor.this.fSubType, JavaElementLabels.ALL_FULLY_QUALIFIED)}), UseSuperTypeProcessor.this.getComment(), arguments, flags);
                        arguments.put("input", descriptor.elementToHandle((IJavaElement)UseSuperTypeProcessor.this.fSubType));
                        arguments.put("element1", descriptor.elementToHandle((IJavaElement)UseSuperTypeProcessor.this.fSuperType));
                        arguments.put("instanceof", Boolean.valueOf(UseSuperTypeProcessor.this.fInstanceOf).toString());
                        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
                    }
                };
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return dynamicValidationStateChange;
        }
        Object var3_6 = null;
        monitor.done();
        return null;
    }

    protected final TextEditBasedChangeManager createChangeManager(final IProgressMonitor monitor, final RefactoringStatus status) throws JavaModelException, CoreException {
        TextEditBasedChangeManager textEditBasedChangeManager;
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        try {
            monitor.beginTask("", 3);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_creating);
            final TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            IJavaProject project = this.fSubType.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setWorkingCopyOwner(this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
            if (this.fSubType.isBinary() || this.fSubType.isReadOnly()) {
                IBinding[] bindings = parser.createBindings(new IJavaElement[]{this.fSubType, this.fSuperType}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (bindings != null && bindings.length == 2 && bindings[0] instanceof ITypeBinding && bindings[1] instanceof ITypeBinding) {
                    this.solveSuperTypeConstraints(null, null, this.fSubType, (ITypeBinding)bindings[0], (ITypeBinding)bindings[1], (IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                    if (!status.hasFatalError()) {
                        this.rewriteTypeOccurrences(manager, null, null, null, null, new HashSet(), status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
            } else {
                parser.createASTs(new ICompilationUnit[]{this.fSubType.getCompilationUnit()}, new String[0], new ASTRequestor(){

                    public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                        try {
                            ITypeBinding superBinding;
                            ITypeBinding subBinding;
                            CompilationUnitRewrite subRewrite = new CompilationUnitRewrite(UseSuperTypeProcessor.this.fOwner, unit, node);
                            AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(UseSuperTypeProcessor.this.fSubType, subRewrite.getRoot());
                            if (subDeclaration != null && (subBinding = subDeclaration.resolveBinding()) != null && (superBinding = UseSuperTypeProcessor.findTypeInHierarchy(subBinding, UseSuperTypeProcessor.this.fSuperType.getFullyQualifiedName('.'))) != null) {
                                UseSuperTypeProcessor.this.solveSuperTypeConstraints(subRewrite.getCu(), subRewrite.getRoot(), UseSuperTypeProcessor.this.fSubType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                                if (!status.hasFatalError()) {
                                    UseSuperTypeProcessor.this.rewriteTypeOccurrences(manager, this, subRewrite, subRewrite.getCu(), subRewrite.getRoot(), new HashSet(), status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    CompilationUnitChange change = subRewrite.createChange();
                                    if (change != null) {
                                        manager.manage(subRewrite.getCu(), (TextEditBasedChange)change);
                                    }
                                }
                            }
                        }
                        catch (CoreException exception) {
                            JavaPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.UseSuperTypeProcessor_internal_error));
                        }
                    }

                    public final void acceptBinding(String key, IBinding binding) {
                    }
                }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            textEditBasedChangeManager = manager;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textEditBasedChangeManager;
    }

    protected final SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new SuperTypeConstraintsSolver(model);
    }

    public final int getChanges() {
        return this.fChanges;
    }

    public final Object[] getElements() {
        return new Object[]{this.fSubType};
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_name, new String[]{this.fSubType.getElementName(), this.fSuperType.getElementName()});
    }

    public final IType getSubType() {
        return this.fSubType;
    }

    public final IType getSuperType() {
        return this.fSuperType;
    }

    public final RefactoringStatus initialize(RefactoringArguments arguments) {
        String instance;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle);
                if (element == null || element.getElementType() != 7) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_input_not_exists, ID_USE_SUPERTYPE));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fSubType = (IType)element;
            handle = extended.getAttribute("element1");
            if (handle != null) {
                element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle);
                if (element == null || element.getElementType() != 7) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_input_not_exists, ID_USE_SUPERTYPE));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "element1"));
            }
            this.fSuperType = (IType)element;
            instance = extended.getAttribute("instanceof");
            if (instance == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fInstanceOf = Boolean.valueOf(instance);
        return new RefactoringStatus();
    }

    public final boolean isApplicable() throws CoreException {
        return Checks.isAvailable((IJavaElement)this.fSubType) && Checks.isAvailable((IJavaElement)this.fSuperType) && !this.fSubType.isAnonymous() && !this.fSubType.isAnnotation() && !this.fSuperType.isAnonymous() && !this.fSuperType.isAnnotation() && !this.fSuperType.isEnum();
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected final void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set replacements) throws CoreException {
        Collection collection = (Collection)this.fTypeOccurrences.get(unit);
        if (collection != null && !collection.isEmpty()) {
            CompilationUnitChange change;
            TType estimate = null;
            ISourceConstraintVariable variable = null;
            CompilationUnitRewrite currentRewrite = null;
            ICompilationUnit sourceUnit = rewrite.getCu();
            currentRewrite = sourceUnit.equals(unit) ? rewrite : new CompilationUnitRewrite(unit, node);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ASTNode result;
                variable = (ISourceConstraintVariable)iterator.next();
                estimate = (TType)variable.getData("te");
                if (estimate == null || !(variable instanceof ITypeConstraintVariable) || (result = NodeFinder.perform((ASTNode)node, ((ITypeConstraintVariable)variable).getRange().getSourceRange())) == null) continue;
                this.rewriteTypeOccurrence(estimate, currentRewrite, result, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
            }
            if (!sourceUnit.equals(unit) && (change = currentRewrite.createChange()) != null) {
                manager.manage(unit, (TextEditBasedChange)change);
            }
        }
    }

    public final void setSuperType(IType type) {
        Assert.isNotNull(type);
        this.fSuperType = type;
    }
}

