/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.History;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoFactory;
import org.eclipse.jdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.w3c.dom.Element;

public class OpenTypeHistory
extends History {
    private boolean fNeedsConsistencyCheck;
    private final IElementChangedListener fDeltaListener;
    private UpdateJob fUpdateJob;
    private final TypeInfoFactory fTypeInfoFactory;
    private final UpdateJobListener fListener = new UpdateJobListener();
    private static final String FILENAME = "OpenTypeHistory.xml";
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_NAME = "name";
    private static final String NODE_PACKAGE = "package";
    private static final String NODE_ENCLOSING_NAMES = "enclosingTypes";
    private static final String NODE_PATH = "path";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final char[][] EMPTY_ENCLOSING_NAMES = new char[0][0];
    private static OpenTypeHistory fgInstance;

    public static synchronized OpenTypeHistory getInstance() {
        if (fgInstance == null) {
            fgInstance = new OpenTypeHistory();
        }
        return fgInstance;
    }

    public static void shutdown() {
        if (fgInstance == null) {
            return;
        }
        fgInstance.doShutdown();
    }

    private OpenTypeHistory() {
        super(FILENAME, NODE_ROOT, NODE_TYPE_INFO);
        this.fTypeInfoFactory = new TypeInfoFactory();
        this.load();
        this.fNeedsConsistencyCheck = true;
        this.fDeltaListener = new TypeHistoryDeltaListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fDeltaListener);
    }

    public synchronized void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new UpdateJob();
        this.fUpdateJob.setPriority(20);
        this.fUpdateJob.setRule(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getSchedulingRule());
        this.fUpdateJob.addJobChangeListener((IJobChangeListener)this.fListener);
        this.fUpdateJob.schedule();
    }

    public synchronized boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        OpenTypeHistory openTypeHistory = this;
        synchronized (openTypeHistory) {
            if (!this.fNeedsConsistencyCheck) {
                return;
            }
        }
        if (this.hasUpdateJob()) {
            try {
                Platform.getJobManager().join((Object)UpdateJob.FAMILY, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        openTypeHistory = this;
        synchronized (openTypeHistory) {
            if (!this.fNeedsConsistencyCheck) {
                return;
            }
            this.internalCheckConsistency(monitor);
        }
    }

    public synchronized boolean contains(TypeInfo type) {
        return super.contains(type);
    }

    public synchronized void accessed(TypeInfo info) {
        super.accessed(info);
    }

    public synchronized TypeInfo remove(TypeInfo info) {
        return (TypeInfo)super.remove(info);
    }

    public synchronized TypeInfo[] getTypeInfos() {
        Collection values = this.getValues();
        int size = values.size();
        TypeInfo[] result = new TypeInfo[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (TypeInfo)iter.next();
            --i;
        }
        return result;
    }

    public synchronized TypeInfo[] getFilteredTypeInfos(TypeInfoFilter filter) {
        Collection values = this.getValues();
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            TypeInfo type = (TypeInfo)iter.next();
            if (filter != null && !filter.matchesHistoryElement(type) || TypeFilter.isFiltered(type.getFullyQualifiedName())) continue;
            result.add(type);
        }
        Collections.reverse(result);
        return result.toArray(new TypeInfo[result.size()]);
    }

    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        ArrayList keys = new ArrayList(this.getKeys());
        monitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, keys.size());
        monitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            TypeInfo type = (TypeInfo)iter.next();
            try {
                IType jType = type.resolveType(scope);
                if (jType == null || !jType.exists()) {
                    this.remove(type);
                } else {
                    type.setModifiers(jType.getFlags());
                }
            }
            catch (JavaModelException javaModelException) {
                this.remove(type);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        monitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    private synchronized void clearUpdateJob(Job toClear) {
        if (this.fUpdateJob == toClear) {
            this.fUpdateJob = null;
        }
    }

    private synchronized boolean hasUpdateJob() {
        return this.fUpdateJob != null;
    }

    private void doShutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fDeltaListener);
    }

    protected Object createFromElement(Element type) {
        String name = type.getAttribute(NODE_NAME);
        String pack = type.getAttribute(NODE_PACKAGE);
        char[][] enclosingNames = this.getEnclosingNames(type);
        String path = type.getAttribute(NODE_PATH);
        int modifiers = 0;
        try {
            modifiers = Integer.parseInt(type.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {}
        TypeInfo info = this.fTypeInfoFactory.create(pack.toCharArray(), name.toCharArray(), enclosingNames, modifiers, path);
        return info;
    }

    protected void setAttributes(Object object, Element typeElement) {
        TypeInfo type = (TypeInfo)object;
        typeElement.setAttribute(NODE_NAME, type.getTypeName());
        typeElement.setAttribute(NODE_PACKAGE, type.getPackageName());
        typeElement.setAttribute(NODE_ENCLOSING_NAMES, type.getEnclosingName());
        typeElement.setAttribute(NODE_PATH, type.getPath());
        typeElement.setAttribute(NODE_MODIFIERS, Integer.toString(type.getModifiers()));
    }

    private char[][] getEnclosingNames(Element type) {
        String enclosingNames = type.getAttribute(NODE_ENCLOSING_NAMES);
        if (enclosingNames.length() == 0) {
            return EMPTY_ENCLOSING_NAMES;
        }
        StringTokenizer tokenizer = new StringTokenizer(enclosingNames, ".");
        ArrayList<char[]> names = new ArrayList<char[]>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            names.add(name.toCharArray());
        }
        return (char[][])names.toArray((T[])new char[names.size()][]);
    }

    private static class TypeHistoryDeltaListener
    implements IElementChangedListener {
        private TypeHistoryDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.processDelta(event.getDelta())) {
                OpenTypeHistory.getInstance().markAsInconsistent();
            }
        }

        private boolean processDelta(IJavaElementDelta delta) {
            IJavaElement elem = delta.getElement();
            boolean isChanged = delta.getKind() == 4;
            boolean isRemoved = delta.getKind() == 2;
            switch (elem.getElementType()) {
                case 2: {
                    if (isRemoved || isChanged && (delta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 3: {
                    if (isRemoved || isChanged && ((delta.getFlags() & 0x8000) != 0 || (delta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 7: {
                    if (isChanged && (delta.getFlags() & 2) != 0) {
                        return true;
                    }
                }
                case 1: 
                case 4: 
                case 6: {
                    if (isRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!JavaModelUtil.isPrimary((ICompilationUnit)elem)) {
                        return false;
                    }
                    if (isRemoved || isChanged && this.isUnknownStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int flags) {
            if ((flags & 1) == 0) {
                return false;
            }
            return (flags & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class UpdateJob
    extends Job {
        public static final String FAMILY;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.util.OpenTypeHistory$UpdateJob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            FAMILY = clazz.getName();
        }

        public UpdateJob() {
            super(CorextMessages.TypeInfoHistory_consistency_check);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            history.internalCheckConsistency(monitor);
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return FAMILY.equals(family);
        }
    }

    private static class UpdateJobListener
    extends JobChangeAdapter {
        private UpdateJobListener() {
        }

        public void done(IJobChangeEvent event) {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            event.getJob().removeJobChangeListener((IJobChangeListener)this);
            history.clearUpdateJob(event.getJob());
        }
    }
}

