/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class CategoryFilterActionGroup
extends ActionGroup {
    private static int COUNTER = 0;
    private static final String FILTER_CATEGORY_ACTION_ID = "FilterCategoryActionId";
    private final String CATEGORY_MENU_GROUP_NAME = "CategoryMenuGroup" + COUNTER++;
    private static final int MAX_NUMBER_OF_CATEGORIES_IN_MENU = 5;
    private final StructuredViewer fViewer;
    private final String fViewerId;
    private final CategoryFilter fFilter;
    private final HashSet fFilteredCategories;
    private IJavaElement[] fInputElement;
    private final CategoryFilterMenuAction fMenuAction;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;

    public CategoryFilterActionGroup(StructuredViewer viewer, String viewerId, IJavaElement[] input) {
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        Assert.isLegal((viewerId != null ? 1 : 0) != 0);
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.fViewer = viewer;
        this.fViewerId = viewerId;
        this.fInputElement = input;
        this.fFilter = new CategoryFilter();
        this.fFilteredCategories = new HashSet();
        this.loadFilteredCategories();
        this.fMenuAction = new CategoryFilterMenuAction();
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    public void setInput(IJavaElement[] input) {
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.fInputElement = input;
    }

    private void loadFilteredCategories() {
        this.fFilteredCategories.clear();
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        String string = store.getString(this.getPreferenceKey());
        if (string != null) {
            String[] categories = string.split(";");
            int i = 0;
            while (i < categories.length) {
                this.fFilteredCategories.add(categories[i]);
                ++i;
            }
        }
    }

    private void storeFilteredCategories() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        if (this.fFilteredCategories.size() == 0) {
            store.setValue(this.getPreferenceKey(), "");
        } else {
            StringBuffer buf = new StringBuffer();
            Iterator iter = this.fFilteredCategories.iterator();
            String element = (String)iter.next();
            buf.append(element);
            while (iter.hasNext()) {
                element = (String)iter.next();
                buf.append(';');
                buf.append(element);
            }
            store.setValue(this.getPreferenceKey(), buf.toString());
        }
    }

    public void contributeToViewMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator(this.CATEGORY_MENU_GROUP_NAME));
        menuManager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)this.fMenuAction);
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!manager.isVisible()) {
                    return;
                }
                CategoryFilterActionGroup.this.updateMenu(manager);
            }
        };
        menuManager.addMenuListener(this.fMenuListener);
        this.fMenuManager = menuManager;
    }

    public void dispose() {
        super.dispose();
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
            this.fMenuManager = null;
            this.fMenuListener = null;
        }
    }

    private void updateMenu(IMenuManager manager) {
        IContributionItem[] items = manager.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if (item != null && item.getId() != null && item.getId().equals(FILTER_CATEGORY_ACTION_ID)) {
                    manager.remove(item);
                }
                ++i;
            }
        }
        HashSet categories = new HashSet();
        int i = 0;
        while (i < this.fInputElement.length) {
            this.collectCategories(this.fInputElement[i], categories);
            ++i;
        }
        ArrayList sortedCategories = new ArrayList(categories);
        Collections.sort(sortedCategories, new Comparator(){

            public int compare(Object o1, Object o2) {
                return -Collator.getInstance().compare(o1, o2);
            }
        });
        int count = 0;
        Iterator iter = sortedCategories.iterator();
        while (iter.hasNext() && count < 5) {
            String category = (String)iter.next();
            manager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)new CategoryFilterAction(category));
            ++count;
        }
    }

    private void collectCategories(IJavaElement element, HashSet result) {
        try {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                String[] categories = member.getCategories();
                int i = 0;
                while (i < categories.length) {
                    result.add(categories[i]);
                    ++i;
                }
                this.processChildren(member.getChildren(), result);
            } else if (element instanceof ICompilationUnit) {
                this.processChildren(((ICompilationUnit)element).getChildren(), result);
            } else if (element instanceof IClassFile) {
                this.processChildren(((IClassFile)element).getChildren(), result);
            } else if (element instanceof IJavaModel) {
                this.processChildren(((IJavaModel)element).getChildren(), result);
            } else if (element instanceof IJavaProject) {
                this.processChildren(((IJavaProject)element).getChildren(), result);
            } else if (element instanceof IPackageFragment) {
                this.processChildren(((IPackageFragment)element).getChildren(), result);
            } else if (element instanceof IPackageFragmentRoot) {
                this.processChildren(((IPackageFragmentRoot)element).getChildren(), result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private void processChildren(IJavaElement[] children, HashSet result) {
        int i = 0;
        while (i < children.length) {
            this.collectCategories(children[i], result);
            ++i;
        }
    }

    private void fireSelectionChange() {
        this.fViewer.getControl().setRedraw(false);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CategoryFilterActionGroup.this.fViewer.refresh();
            }
        });
        this.fViewer.getControl().setRedraw(true);
    }

    private String getPreferenceKey() {
        return "CategoryFilterActionGroup." + this.fViewerId;
    }

    private void showCategorySelectionDialog(IJavaElement[] input) {
        HashSet categories = new HashSet();
        int i = 0;
        while (i < input.length) {
            this.collectCategories(input[i], categories);
            ++i;
        }
        CategoryFilterSelectionDialog dialog = new CategoryFilterSelectionDialog(this.fViewer.getControl().getShell(), new ArrayList(categories), new ArrayList(this.fFilteredCategories));
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            Iterator iter = categories.iterator();
            while (iter.hasNext()) {
                String category = (String)iter.next();
                if (this.contains(selected, category)) {
                    this.fFilteredCategories.remove(category);
                    continue;
                }
                this.fFilteredCategories.add(category);
            }
            this.storeFilteredCategories();
            this.fireSelectionChange();
        }
    }

    private boolean contains(Object[] selected, String category) {
        int i = 0;
        while (i < selected.length) {
            if (selected[i].equals(category)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class CategoryFilter
    extends ViewerFilter {
        private CategoryFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IMember)) return true;
            IMember member = (IMember)element;
            try {
                String[] categories = member.getCategories();
                int i = 0;
                while (true) {
                    if (i >= categories.length) {
                        return true;
                    }
                    if (CategoryFilterActionGroup.this.fFilteredCategories.contains(categories[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return true;
        }
    }

    private class CategoryFilterSelectionDialog
    extends SelectionStatusDialog
    implements IListAdapter {
        private static final int SELECT_ALL = 0;
        private static final int DESELECT_ALL = 1;
        private final CheckedListDialogField fCategoryList;

        public CategoryFilterSelectionDialog(Shell parent, List categories, List selectedCategories) {
            super(parent);
            this.setTitle(ActionMessages.CategoryFilterActionGroup_JavaCategoryFilter_title);
            String[] buttons = new String[]{ActionMessages.CategoryFilterActionGroup_SelectAllCategories, ActionMessages.CategoryFilterActionGroup_DeselectAllCategories};
            this.fCategoryList = new CheckedListDialogField(this, buttons, new ILabelProvider(this){
                final /* synthetic */ CategoryFilterSelectionDialog this$1;
                {
                    this.this$1 = categoryFilterSelectionDialog;
                }

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return (String)element;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.fCategoryList.addElements(categories);
            this.fCategoryList.setViewerSorter(new ViewerSorter());
            this.fCategoryList.setLabelText(ActionMessages.CategoryFilterActionGroup_SelectCategoriesDescription);
            this.fCategoryList.checkAll(true);
            Iterator iter = selectedCategories.iterator();
            while (iter.hasNext()) {
                String selected = (String)iter.next();
                this.fCategoryList.setChecked(selected, false);
            }
            if (categories.size() == 0) {
                this.fCategoryList.setEnabled(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setFont(parent.getFont());
            Composite list = new Composite(composite, 0);
            list.setFont(composite.getFont());
            LayoutUtil.doDefaultLayout(list, new DialogField[]{this.fCategoryList}, true);
            LayoutUtil.setHorizontalGrabbing(this.fCategoryList.getListControl(null));
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void computeResult() {
            this.setResult(this.fCategoryList.getCheckedElements());
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                this.fCategoryList.checkAll(true);
                this.fCategoryList.refresh();
            } else if (index == 1) {
                this.fCategoryList.checkAll(false);
                this.fCategoryList.refresh();
            }
        }

        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            if (selectedElements.size() == 1) {
                Object selected;
                this.fCategoryList.setChecked(selected, !this.fCategoryList.isChecked(selected = selectedElements.get(0)));
            }
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private class CategoryFilterMenuAction
    extends Action {
        public CategoryFilterMenuAction() {
            this.setDescription(ActionMessages.CategoryFilterActionGroup_ShowCategoriesActionDescription);
            this.setToolTipText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesToolTip);
            this.setText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesLabel);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "category_menu.gif");
        }

        public void run() {
            CategoryFilterActionGroup.this.showCategorySelectionDialog(CategoryFilterActionGroup.this.fInputElement);
        }
    }

    private class CategoryFilterAction
    extends Action {
        private final String fCategory;

        public CategoryFilterAction(String category) {
            this.fCategory = category;
            this.setText(this.fCategory);
            this.setChecked(!CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory));
            this.setId(CategoryFilterActionGroup.FILTER_CATEGORY_ACTION_ID);
        }

        public void run() {
            super.run();
            if (CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory)) {
                CategoryFilterActionGroup.this.fFilteredCategories.remove(this.fCategory);
            } else {
                CategoryFilterActionGroup.this.fFilteredCategories.add(this.fCategory);
            }
            CategoryFilterActionGroup.this.storeFilteredCategories();
            CategoryFilterActionGroup.this.fireSelectionChange();
        }
    }
}

