/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;

final class JarPackageRefactoringPage
extends WizardPage
implements IJarPackageWizardPage {
    private static final String PAGE_NAME = "jarRefactoringsWizardPage";
    private static final String STORE_EXPORT_STRUCTURAL_ONLY = "jarRefactoringsWizardPage.EXPORT_STRUCTURAL_ONLY";
    private static final String STORE_EXPORT_DEPRECATION_INFO = "jarRefactoringsWizardPage.EXPORT_DEPRECATION_INFO";
    private final JarPackageData fJarPackageData;
    private CheckboxTableViewer fTableViewer;
    static /* synthetic */ Class class$0;

    public JarPackageRefactoringPage(JarPackageData data) {
        super(PAGE_NAME);
        Assert.isNotNull(data);
        this.fJarPackageData = data;
        this.setTitle(JarPackagerMessages.JarPackageRefactoringPage_title);
        this.setDescription(JarPackagerMessages.JarPackageRefactoringPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fJarPackageData.setExportStructuralOnly(settings.getBoolean(STORE_EXPORT_STRUCTURAL_ONLY));
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        Label label = new Label(composite, 0);
        label.setText(JarPackagerMessages.JarPackageRefactoringPage_viewer_caption);
        this.createProjectTable(composite);
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_options_label);
        this.createOptionsGroup(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_refactoring_wizard_page_context");
    }

    protected void createOptionsGroup(Composite parent) {
        Assert.isNotNull(parent);
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        final Button structural = new Button(group, 16416);
        structural.setText(JarPackagerMessages.JarPackageRefactoringPage_export_structural_only);
        structural.setSelection(this.fJarPackageData.isExportStructuralOnly());
        structural.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JarPackageRefactoringPage.this.fJarPackageData.setExportStructuralOnly(structural.getSelection());
            }
        });
        final Button deprecations = new Button(group, 16416);
        deprecations.setText(JarPackagerMessages.JarPackageRefactoringPage_include_deprecation_info0);
        deprecations.setSelection(this.fJarPackageData.isDeprecationAware());
        deprecations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JarPackageRefactoringPage.this.fJarPackageData.setDeprecationAware(deprecations.getSelection());
            }
        });
    }

    protected Label createPlainLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.verticalIndent = 4;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void createProjectTable(Composite parent) {
        Assert.isNotNull(parent);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2816);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 150;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new JavaUILabelProvider(), (ILabelDecorator)new ProblemsLabelDecorator()));
        this.fTableViewer.setContentProvider((IContentProvider)new RefactoringProjectContentProvider());
        this.fTableViewer.setSorter((ViewerSorter)new JavaElementSorter());
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public final void checkStateChanged(CheckStateChangedEvent event) {
                List<Object> collection = Arrays.asList(JarPackageRefactoringPage.this.fTableViewer.getCheckedElements());
                JarPackageRefactoringPage.this.fJarPackageData.setRefactoringProjects(collection.toArray(new IProject[collection.size()]));
            }
        });
        this.handleProjectsChanged();
    }

    public void finish() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_EXPORT_STRUCTURAL_ONLY, this.fJarPackageData.isExportStructuralOnly());
            settings.put(STORE_EXPORT_DEPRECATION_INFO, this.fJarPackageData.isDeprecationAware());
        }
    }

    protected IProject[] getAvailableProjects() {
        HashSet<IProject> set = new HashSet<IProject>(32);
        Object[] elements = this.fJarPackageData.getElements();
        int index = 0;
        while (index < elements.length) {
            Object element = elements[index];
            if (element instanceof IAdaptable) {
                IProject project;
                IResource resource;
                IAdaptable adaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) != null && (project = resource.getProject()) != null) {
                    set.add(project);
                }
            }
            ++index;
        }
        IProject[] projects = new IProject[set.size()];
        set.toArray(projects);
        return projects;
    }

    protected void handleProjectsChanged() {
        Object[] projects = this.getAvailableProjects();
        this.fTableViewer.setInput((Object)projects);
        Object[] checked = this.fJarPackageData.getRefactoringProjects();
        if (checked != null && checked.length > 0) {
            this.fTableViewer.setCheckedElements(checked);
        } else {
            this.fTableViewer.setCheckedElements(projects);
            this.fJarPackageData.setRefactoringProjects((IProject[])projects);
        }
    }

    public void setVisible(boolean visible) {
        this.handleProjectsChanged();
        super.setVisible(visible);
    }

    private static class RefactoringProjectContentProvider
    extends WorkbenchContentProvider {
        private static final Object[] NO_CHILDREN = new Object[0];

        private RefactoringProjectContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof IProject[]) {
                return (Object[])element;
            }
            return NO_CHILDREN;
        }
    }
}

