/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.navigator.CommonLayoutActionGroup;
import org.eclipse.jdt.internal.ui.navigator.OpenAndExpand;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class PackageExplorerActionProvider
extends CommonActionProvider {
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    private static final String TAG_LAYOUT = "layout";
    private CommonLayoutActionGroup fLayoutActionGroup;
    private boolean fHasFilledViewMenu = false;
    private IExtensionStateModel fStateModel;
    private IAction fOpenAndExpand;
    private OpenEditorActionGroup fOpenGroup;
    private CCPActionGroup fCCPGroup;
    private RefactorActionGroup fRefactorGroup;
    private JavaSearchActionGroup fSearchGroup;
    private GenerateBuildPathActionGroup fBuildPathGroup;
    private GenerateActionGroup fGenerateGroup;
    private boolean fInViewPart = false;

    public void fillActionBars(IActionBars actionBars) {
        if (!this.fHasFilledViewMenu) {
            this.fLayoutActionGroup.fillActionBars(actionBars);
            this.fHasFilledViewMenu = true;
        }
        if (this.fInViewPart) {
            this.fOpenGroup.fillActionBars(actionBars);
            this.fCCPGroup.fillActionBars(actionBars);
            this.fBuildPathGroup.fillActionBars(actionBars);
            this.fGenerateGroup.fillActionBars(actionBars);
            this.fRefactorGroup.fillActionBars(actionBars);
            this.fRefactorGroup.retargetFileMenuActions(actionBars);
            this.fSearchGroup.fillActionBars(actionBars);
            if (this.fOpenAndExpand == null && this.fOpenGroup.getOpenAction().isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.fOpenGroup.getOpenAction());
            } else if (this.fOpenAndExpand.isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.fOpenAndExpand);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fInViewPart) {
            this.fCCPGroup.fillContextMenu(menu);
            this.fBuildPathGroup.fillContextMenu(menu);
            this.fGenerateGroup.fillContextMenu(menu);
            this.fRefactorGroup.fillContextMenu(menu);
            this.fSearchGroup.fillContextMenu(menu);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        this.fStateModel = site.getExtensionStateModel();
        this.fLayoutActionGroup = new CommonLayoutActionGroup(site.getStructuredViewer(), this.fStateModel);
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.fOpenGroup = new OpenEditorActionGroup(viewPart);
            this.fCCPGroup = new CCPActionGroup(viewPart);
            this.fRefactorGroup = new RefactorActionGroup(viewPart);
            this.fGenerateGroup = new GenerateActionGroup(viewPart);
            this.fSearchGroup = new JavaSearchActionGroup(viewPart);
            this.fBuildPathGroup = new GenerateBuildPathActionGroup(viewPart);
            if (site.getStructuredViewer() instanceof TreeViewer) {
                this.fOpenAndExpand = new OpenAndExpand((IWorkbenchSite)workbenchSite.getSite(), (OpenAction)this.fOpenGroup.getOpenAction(), (TreeViewer)site.getStructuredViewer());
            }
            this.fInViewPart = true;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.fInViewPart) {
            this.fOpenGroup.setContext(context);
            this.fCCPGroup.setContext(context);
            this.fRefactorGroup.setContext(context);
            this.fGenerateGroup.setContext(context);
            this.fSearchGroup.setContext(context);
            this.fBuildPathGroup.setContext(context);
        }
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.restoreLayoutState(memento);
    }

    private void restoreLayoutState(IMemento memento) {
        boolean isCurrentLayoutFlat = true;
        Integer state = null;
        if (memento != null) {
            state = memento.getInteger(TAG_LAYOUT);
        }
        if (state == null) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            state = new Integer(store.getInt(TAG_LAYOUT));
        }
        if (state == 2) {
            isCurrentLayoutFlat = true;
        } else if (state == 1) {
            isCurrentLayoutFlat = false;
        }
        this.fStateModel.setBooleanProperty("isLayoutFlat", isCurrentLayoutFlat);
        this.fLayoutActionGroup.setFlatLayout(isCurrentLayoutFlat);
    }
}

