/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

final class CodeAssistConfigurationBlockInProgress
extends OptionsConfigurationBlock {
    private static final int LIMIT = 65535;
    private static final String COLON = ":";
    private static final String SEPARATOR = "\u0000";
    private static final String DASH = "-";
    private static final OptionsConfigurationBlock.Key PREF_EXCLUDED_CATEGORIES = CodeAssistConfigurationBlockInProgress.getJDTUIKey("content_assist_disabled_computers");
    private static final OptionsConfigurationBlock.Key PREF_CATEGORY_ORDER = CodeAssistConfigurationBlockInProgress.getJDTUIKey("content_assist_category_order");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC = CodeAssistConfigurationBlockInProgress.getJDTCoreKey("org.eclipse.jdt.core.timeoutForParameterNameFromAttachedJavadoc");
    private final Comparator fCategoryComparator = new Comparator(){

        private int getRank(Object o) {
            return ((ModelElement)o).getRank();
        }

        public int compare(Object o1, Object o2) {
            return this.getRank(o1) - this.getRank(o2);
        }
    };
    private final List fModel;
    private final Map fImages = new HashMap();
    private TableViewer fViewer;
    private Button fInclusionButton;
    private Button fUpButton;
    private Button fDownButton;
    private final Separator fSeparator = new Separator();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_EXCLUDED_CATEGORIES, PREF_CATEGORY_ORDER, PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC};
    }

    CodeAssistConfigurationBlockInProgress(IStatusChangeListener statusListener, IWorkbenchPreferenceContainer container) {
        super(statusListener, null, CodeAssistConfigurationBlockInProgress.getAllKeys(), container);
        this.fModel = this.fillModel();
    }

    private List fillModel() {
        CompletionProposalComputerRegistry registry = CompletionProposalComputerRegistry.getDefault();
        List categories = registry.getProposalCategories();
        ArrayList<ModelElement> model = new ArrayList<ModelElement>();
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory category = (CompletionProposalCategory)it.next();
            if (!category.hasComputers()) continue;
            model.add(new Category(category));
        }
        model.add(this.fSeparator);
        return model;
    }

    protected Control createContents(Composite parent) {
        ICommandService commandSvc;
        Command command;
        ParameterizedCommand pCmd;
        String key;
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite composite = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((key = this.getKeyboardShortcut(pCmd = new ParameterizedCommand(command = (commandSvc = (ICommandService)iWorkbench.getAdapter((Class)clazz)).getCommand("org.eclipse.ui.edit.text.contentAssist.proposals"), null))) == null) {
            key = PreferencesMessages.CodeAssistConfigurationBlockInProgress_no_shortcut;
        }
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        int width = pixelConverter.convertWidthInCharsToPixels(40);
        Label label = new Label(composite, 64);
        label.setText(Messages.format(PreferencesMessages.CodeAssistConfigurationBlockInProgress_computer_description, new Object[]{key}));
        GridData gd = new GridData(4, 4, false, false, 2, 1);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
        this.createControls(composite);
        Link link = new Link(composite, 64);
        link.setText(PreferencesMessages.CodeAssistConfigurationBlockInProgress_computer_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)CodeAssistConfigurationBlockInProgress.this.getShell(), (String)e.text, null, null);
            }
        });
        gd = new GridData(4, 4, false, false, 2, 1);
        gd.widthHint = width;
        link.setLayoutData((Object)gd);
        this.updateControls();
        if (this.fModel.size() > 0) {
            this.fViewer.getTable().select(0);
            this.handleTableSelection();
        }
        this.createParameterTimeoutControl(composite);
        scrolled.setContent((Control)composite);
        scrolled.setMinSize(composite.computeSize(-1, -1));
        return scrolled;
    }

    private void createParameterTimeoutControl(Composite composite) {
        Label filler = new Label(composite, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Composite timeoutComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        timeoutComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, false, false, 2, 1);
        timeoutComposite.setLayoutData((Object)gd);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        String str = PreferencesMessages.CodeAssistConfigurationBlockInProgress_parameterNameFromAttachedJavadoc_timeout;
        this.addTextField(timeoutComposite, str, PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC, 0, pixelConverter.convertWidthInCharsToPixels(7));
        Label ms = new Label(timeoutComposite, 0);
        gd = new GridData();
        ms.setLayoutData((Object)gd);
        ms.setText(PreferencesMessages.CodeAssistConfigurationBlockInProgress_parameterNameFromAttachedJavadoc_timeout_ms);
    }

    private void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.createViewer(composite);
        this.createButtonList(composite);
    }

    private void createViewer(Composite composite) {
        this.fViewer = new TableViewer(composite, 2052);
        Table table = this.fViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn nameColumn = new TableColumn(table, 0);
        TableColumn keyColumn = new TableColumn(table, 0);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ComputerLabelProvider labelProvider = new ComputerLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fViewer.setInput((Object)this.fModel);
        int minNameWidth = 100;
        int minKeyWidth = 5;
        int i = 0;
        while (i < this.fModel.size()) {
            minNameWidth = Math.max(minNameWidth, this.computeWidth((Control)table, labelProvider.getColumnText(this.fModel.get(i), 0)) + 20);
            minKeyWidth = Math.max(minKeyWidth, this.computeWidth((Control)table, labelProvider.getColumnText(this.fModel.get(i), 1)));
            ++i;
        }
        String separatorLabel = PreferencesMessages.CodeAssistConfigurationBlockInProgress_separator;
        int baseLabelWidth = this.computeWidth((Control)table, separatorLabel);
        StringBuffer buf = new StringBuffer(separatorLabel);
        int dashWidth = this.computeWidth((Control)table, DASH);
        int additionalDashes = (minNameWidth - baseLabelWidth) / dashWidth;
        int i2 = 0;
        while (i2 < additionalDashes) {
            buf.insert(0, DASH);
            buf.append(DASH);
            ++i2;
        }
        this.fSeparator.setLabel(buf.toString());
        nameColumn.setWidth(minNameWidth);
        keyColumn.setWidth(minKeyWidth);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistConfigurationBlockInProgress.this.handleTableSelection();
            }
        });
    }

    private void createButtonList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createUpDownControls(composite);
        this.createButtons(composite);
    }

    private void createUpDownControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.fUpButton = new Button(composite, 0x1000008);
        this.fUpButton.setText(PreferencesMessages.CodeAssistConfigurationBlockInProgress_Up);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistConfigurationBlockInProgress.this.getSelectionIndex();
                if (index > 0) {
                    Object item = CodeAssistConfigurationBlockInProgress.this.fModel.remove(index);
                    CodeAssistConfigurationBlockInProgress.this.fModel.add(index - 1, item);
                    CodeAssistConfigurationBlockInProgress.this.fViewer.refresh();
                    CodeAssistConfigurationBlockInProgress.this.handleTableSelection();
                    CodeAssistConfigurationBlockInProgress.this.writeOrderPreference();
                }
            }
        });
        this.fUpButton.setLayoutData((Object)new GridData());
        this.fDownButton = new Button(composite, 0x1000008);
        this.fDownButton.setText(PreferencesMessages.CodeAssistConfigurationBlockInProgress_Down);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistConfigurationBlockInProgress.this.getSelectionIndex();
                if (index < CodeAssistConfigurationBlockInProgress.this.fModel.size() - 1) {
                    Object item = CodeAssistConfigurationBlockInProgress.this.fModel.remove(index);
                    CodeAssistConfigurationBlockInProgress.this.fModel.add(index + 1, item);
                    CodeAssistConfigurationBlockInProgress.this.fViewer.refresh();
                    CodeAssistConfigurationBlockInProgress.this.handleTableSelection();
                    CodeAssistConfigurationBlockInProgress.this.writeOrderPreference();
                }
            }
        });
        this.fDownButton.setLayoutData((Object)new GridData());
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.fInclusionButton = new Button(composite, 32);
        this.fInclusionButton.setText(PreferencesMessages.CodeAssistConfigurationBlockInProgress_include);
        this.fInclusionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelElement item = CodeAssistConfigurationBlockInProgress.this.getSelectedItem();
                if (item != null) {
                    item.setIncluded(CodeAssistConfigurationBlockInProgress.this.fInclusionButton.getSelection());
                }
            }
        });
    }

    private void handleTableSelection() {
        ModelElement item = this.getSelectedItem();
        if (item != null) {
            this.fInclusionButton.setEnabled(item.isRealCategory());
            this.fInclusionButton.setSelection(item.getIncluded());
            this.fUpButton.setEnabled(this.getSelectionIndex() > 0);
            this.fDownButton.setEnabled(this.getSelectionIndex() < this.fModel.size() - 1);
        } else {
            this.fInclusionButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        }
    }

    private void writeInclusionPreference(ModelElement changed, boolean value) {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.fModel.iterator();
        while (it.hasNext()) {
            boolean included;
            ModelElement item = (ModelElement)it.next();
            if (!item.isRealCategory()) continue;
            boolean bl = included = changed == item ? value : item.getIncluded();
            if (included) continue;
            buf.append(String.valueOf(item.getId()) + SEPARATOR);
        }
        String newValue = buf.toString();
        String oldValue = this.setValue(PREF_EXCLUDED_CATEGORIES, newValue);
        this.validateSettings(PREF_EXCLUDED_CATEGORIES, oldValue, newValue);
    }

    private void writeOrderPreference() {
        StringBuffer buf = new StringBuffer();
        int plus = 0;
        int i = 0;
        Iterator it = this.fModel.iterator();
        while (it.hasNext()) {
            ModelElement item = (ModelElement)it.next();
            if (item.isRealCategory()) {
                int rank = i + plus;
                buf.append(String.valueOf(item.getId()) + COLON + rank + SEPARATOR);
            } else {
                plus = 65535;
            }
            ++i;
        }
        String newValue = buf.toString();
        String oldValue = this.setValue(PREF_CATEGORY_ORDER, newValue);
        this.validateSettings(PREF_CATEGORY_ORDER, oldValue, newValue);
    }

    private boolean readInclusionPreference(CompletionProposalCategory cat) {
        String[] ids = this.getTokens(this.getValue(PREF_EXCLUDED_CATEGORIES), SEPARATOR);
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(cat.getId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int readOrderPreference(CompletionProposalCategory cat) {
        String[] sortOrderIds = this.getTokens(this.getValue(PREF_CATEGORY_ORDER), SEPARATOR);
        int i = 0;
        while (i < sortOrderIds.length) {
            String[] idAndRank = this.getTokens(sortOrderIds[i], COLON);
            if (idAndRank[0].equals(cat.getId())) {
                return Integer.parseInt(idAndRank[1]);
            }
            ++i;
        }
        return 65536;
    }

    private ModelElement getSelectedItem() {
        return (ModelElement)((IStructuredSelection)this.fViewer.getSelection()).getFirstElement();
    }

    private int getSelectionIndex() {
        return this.fViewer.getTable().getSelectionIndex();
    }

    protected void updateControls() {
        super.updateControls();
        Collections.sort(this.fModel, this.fCategoryComparator);
        this.fViewer.refresh();
        this.handleTableSelection();
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        Iterator it = this.fModel.iterator();
        while (it.hasNext()) {
            ModelElement item = (ModelElement)it.next();
            item.update();
        }
        return super.processChanges(container);
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (changedKey == PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC) {
            StatusInfo status = new StatusInfo();
            if (newValue.length() == 0) {
                status.setError(PreferencesMessages.CodeAssistConfigurationBlockInProgress_parameterNameFromAttachedJavadoc_timeout_emptyInput);
            } else {
                try {
                    int number = Integer.parseInt(newValue);
                    int min = 0;
                    int max = 5000;
                    if (number < min || number > max) {
                        String msgFormat = PreferencesMessages.CodeAssistConfigurationBlockInProgress_parameterNameFromAttachedJavadoc_timeout_invalidRange;
                        String msg = Messages.format(msgFormat, new Object[]{new Integer(min), new Integer(max)});
                        status.setError(msg);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String msgFormat = PreferencesMessages.CodeAssistConfigurationBlockInProgress_parameterNameFromAttachedJavadoc_timeout_invalidInput;
                    String msg = Messages.format(msgFormat, newValue);
                    status.setError(msg);
                }
            }
            this.fContext.statusChanged(status);
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    public void dispose() {
        Iterator it = this.fImages.values().iterator();
        while (it.hasNext()) {
            Image image = (Image)it.next();
            image.dispose();
        }
        super.dispose();
    }

    private int computeWidth(Control control, String name) {
        int n;
        if (name == null) {
            return 0;
        }
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            n = gc.stringExtent((String)name).x + 10;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return n;
    }

    private String getKeyboardShortcut(ParameterizedCommand command) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBindingService bindingSvc = (IBindingService)iWorkbench.getAdapter((Class)clazz);
        Binding[] bindings = bindingSvc.getBindings();
        int i = 0;
        while (i < bindings.length) {
            Binding binding = bindings[i];
            if (command.equals((Object)binding.getParameterizedCommand())) {
                TriggerSequence triggers = binding.getTriggerSequence();
                return triggers.format();
            }
            ++i;
        }
        return null;
    }

    private Image getImage(ImageDescriptor imgDesc) {
        if (imgDesc == null) {
            return null;
        }
        Image img = (Image)this.fImages.get(imgDesc);
        if (img == null) {
            img = imgDesc.createImage(false);
            this.fImages.put(imgDesc, img);
        }
        return img;
    }

    private final class ComputerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ComputerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return ((ModelElement)element).getColumnImage(columnIndex);
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((ModelElement)element).getColumnLabel(columnIndex);
        }
    }

    private static abstract class ModelElement {
        private ModelElement() {
        }

        String getColumnLabel(int column) {
            return null;
        }

        abstract int getRank();

        Image getColumnImage(int column) {
            return null;
        }

        boolean getIncluded() {
            return false;
        }

        boolean isRealCategory() {
            return false;
        }

        void setIncluded(boolean selection) {
        }

        String getId() {
            return null;
        }

        void update() {
        }

        void setLabel(String label) {
        }
    }

    private final class Category
    extends ModelElement {
        private final CompletionProposalCategory fCategory;
        private final Command fCommand;
        private final IParameter fParam;
        static /* synthetic */ Class class$0;

        Category(CompletionProposalCategory category) {
            IParameter type;
            this.fCategory = category;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ICommandService commandSvc = (ICommandService)iWorkbench.getAdapter((Class)clazz);
            this.fCommand = commandSvc.getCommand("org.eclipse.jdt.ui.specific_content_assist.command");
            try {
                type = this.fCommand.getParameters()[0];
            }
            catch (NotDefinedException notDefinedException) {
                Assert.isTrue((boolean)false);
                type = null;
            }
            this.fParam = type;
        }

        Image getColumnImage(int column) {
            if (column == 0) {
                return CodeAssistConfigurationBlockInProgress.this.getImage(this.fCategory.getImageDescriptor());
            }
            return super.getColumnImage(column);
        }

        String getColumnLabel(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.fCategory.getName().replaceAll("&", "");
                }
                case 1: {
                    Parameterization[] params = new Parameterization[]{new Parameterization(this.fParam, this.fCategory.getId())};
                    ParameterizedCommand pCmd = new ParameterizedCommand(this.fCommand, params);
                    String key = CodeAssistConfigurationBlockInProgress.this.getKeyboardShortcut(pCmd);
                    return key;
                }
            }
            return super.getColumnLabel(columnIndex);
        }

        boolean isRealCategory() {
            return true;
        }

        boolean getIncluded() {
            return CodeAssistConfigurationBlockInProgress.this.readInclusionPreference(this.fCategory);
        }

        void setIncluded(boolean included) {
            CodeAssistConfigurationBlockInProgress.this.writeInclusionPreference(this, included);
        }

        String getId() {
            return this.fCategory.getId();
        }

        int getRank() {
            return CodeAssistConfigurationBlockInProgress.this.readOrderPreference(this.fCategory);
        }

        void update() {
            this.fCategory.setIncluded(this.getIncluded());
            int rank = this.getRank();
            this.fCategory.setSortOrder(rank);
            this.fCategory.setSeparateCommand(rank < 65535);
        }
    }

    private static final class Separator
    extends ModelElement {
        private String fLabel = PreferencesMessages.CodeAssistConfigurationBlockInProgress_separator;

        private Separator() {
        }

        String getColumnLabel(int index) {
            if (index == 0) {
                return this.fLabel;
            }
            return super.getColumnLabel(index);
        }

        int getRank() {
            return 65535;
        }

        void setLabel(String label) {
            this.fLabel = label;
        }
    }
}

