/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResultRequestor;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class NLSSearchQuery
implements ISearchQuery {
    private static final StringMatcher fgGetClassNameMatcher = new StringMatcher("*.class.getName()*", false, false);
    private NLSSearchResult fResult;
    private IJavaElement[] fWrapperClass;
    private IFile[] fPropertiesFile;
    private IJavaSearchScope fScope;
    private String fScopeDescription;

    public NLSSearchQuery(IJavaElement wrapperClass, IFile propertiesFile, IJavaSearchScope scope, String scopeDescription) {
        this(new IJavaElement[]{wrapperClass}, new IFile[]{propertiesFile}, scope, scopeDescription);
    }

    public NLSSearchQuery(IJavaElement[] wrapperClass, IFile[] propertiesFile, IJavaSearchScope scope, String scopeDescription) {
        this.fWrapperClass = wrapperClass;
        this.fPropertiesFile = propertiesFile;
        this.fScope = scope;
        this.fScopeDescription = scopeDescription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        block14: {
            IStatus iStatus;
            block12: {
                IStatus iStatus2;
                block11: {
                    monitor.beginTask("", 5 * this.fWrapperClass.length);
                    try {
                        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
                        textResult.removeAll();
                        int i = 0;
                        while (i < this.fWrapperClass.length) {
                            IJavaElement wrapperClass = this.fWrapperClass[i];
                            IFile propertieFile = this.fPropertiesFile[i];
                            if (!wrapperClass.exists()) {
                                iStatus2 = JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_wrapperNotExists, wrapperClass.getElementName()), null);
                                Object var14_17 = null;
                                break block11;
                            }
                            if (!wrapperClass.exists()) {
                                iStatus = JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_propertiesNotExists, propertieFile.getName()), null);
                                break block12;
                            }
                            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)wrapperClass, (int)2, (int)24);
                            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                            NLSSearchResultRequestor requestor = new NLSSearchResultRequestor(propertieFile, this.fResult);
                            try {
                                SearchEngine engine = new SearchEngine();
                                engine.search(pattern, participants, this.fScope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                                IField[] fields = ((IType)wrapperClass).getFields();
                                int j = 0;
                                while (true) {
                                    if (j >= fields.length) {
                                        requestor.reportUnusedPropertyNames((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        break;
                                    }
                                    IField field = fields[j];
                                    String source = field.getSource();
                                    if (!fgGetClassNameMatcher.match(source) && source.indexOf("NLS.initializeMessages") == -1 && !requestor.hasPropertyKey(field.getElementName())) {
                                        this.fResult.addMatch(new Match((Object)field, field.getSourceRange().getOffset(), field.getSourceRange().getLength()));
                                    }
                                    ++j;
                                }
                            }
                            catch (CoreException e) {
                                JavaPlugin.log(e);
                            }
                            ++i;
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return iStatus2;
            }
            Object var14_18 = null;
            monitor.done();
            return iStatus;
        }
        Object var14_20 = null;
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return NLSSearchMessages.NLSSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        if (this.fWrapperClass.length == 1) {
            if (nMatches == 1) {
                Object[] args = new String[]{this.fWrapperClass[0].getElementName(), this.fScopeDescription};
                return Messages.format(NLSSearchMessages.SearchOperation_singularLabelPostfix, args);
            }
            Object[] args = new String[]{this.fWrapperClass[0].getElementName(), String.valueOf(nMatches), this.fScopeDescription};
            return Messages.format(NLSSearchMessages.SearchOperation_pluralLabelPatternPostfix, args);
        }
        if (nMatches == 1) {
            return Messages.format(NLSSearchMessages.NLSSearchQuery_oneProblemInScope_description, this.fScopeDescription);
        }
        return Messages.format(NLSSearchMessages.NLSSearchQuery_xProblemsInScope_description, new Object[]{String.valueOf(nMatches), this.fScopeDescription});
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new NLSSearchResult(this);
        }
        return this.fResult;
    }
}

