/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.Arrays;
import org.eclipse.jdt.internal.ui.text.Symbols;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;

public final class JavaHeuristicScanner
implements Symbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char QUESTIONMARK = '?';
    private static final char EQUAL = '=';
    private static final char LANGLE = '<';
    private static final char RANGLE = '>';
    private final IDocument fDocument;
    private final String fPartitioning;
    private final String fPartition;
    private char fChar;
    private int fPos;
    private ITypedRegion fCachedPartition = new TypedRegion(-1, 0, "__no_partition_at_all");
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition fNonWS = new NonWhitespace();
    private final StopCondition fNonIdent = new NonJavaIdentifierPartDefaultPartition();

    public JavaHeuristicScanner(IDocument document, String partitioning, String partition) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        Assert.isLegal((partitioning != null ? 1 : 0) != 0);
        Assert.isLegal((partition != null ? 1 : 0) != 0);
        this.fDocument = document;
        this.fPartitioning = partitioning;
        this.fPartition = partition;
    }

    public JavaHeuristicScanner(IDocument document) {
        this(document, "___java_partitioning", "__dftl_partition_content_type");
    }

    public int getPosition() {
        return this.fPos;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int from = pos;
            int to = (pos = this.scanForward(pos + 1, bound, this.fNonIdent)) == -1 ? (bound == -2 ? this.fDocument.getLength() : bound) : pos;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 8;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                return 9;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int to = pos + 1;
            int from = (pos = this.scanBackward(pos - 1, bound, this.fNonIdent)) == -1 ? (bound == -2 ? 0 : bound + 1) : pos + 1;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 8;
    }

    private int getToken(String s) {
        Assert.isNotNull((Object)s);
        switch (s.length()) {
            case 2: {
                if ("if".equals(s)) {
                    return 109;
                }
                if (!"do".equals(s)) break;
                return 1010;
            }
            case 3: {
                if ("for".equals(s)) {
                    return 1011;
                }
                if ("try".equals(s)) {
                    return 1012;
                }
                if (!"new".equals(s)) break;
                return 1025;
            }
            case 4: {
                if ("case".equals(s)) {
                    return 1013;
                }
                if ("else".equals(s)) {
                    return 1014;
                }
                if ("enum".equals(s)) {
                    return 1028;
                }
                if (!"goto".equals(s)) break;
                return 1023;
            }
            case 5: {
                if ("break".equals(s)) {
                    return 1015;
                }
                if ("catch".equals(s)) {
                    return 1016;
                }
                if ("class".equals(s)) {
                    return 1026;
                }
                if (!"while".equals(s)) break;
                return 1017;
            }
            case 6: {
                if ("return".equals(s)) {
                    return 1018;
                }
                if ("static".equals(s)) {
                    return 1019;
                }
                if (!"switch".equals(s)) break;
                return 1020;
            }
            case 7: {
                if ("default".equals(s)) {
                    return 1024;
                }
                if (!"finally".equals(s)) break;
                return 1021;
            }
            case 9: {
                if (!"interface".equals(s)) break;
                return 1027;
            }
            case 12: {
                if (!"synchronized".equals(s)) break;
                return 1022;
            }
        }
        return 2000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findClosingPeer(int start, char openingPeer, char closingPeer) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        try {
            int depth = 1;
            --start;
            do {
                if ((start = this.scanForward(start + 1, -2, new CharacterMatch(new char[]{openingPeer, closingPeer}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == openingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findOpeningPeer(int start, char openingPeer, char closingPeer) {
        Assert.isLegal((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            int depth = 1;
            ++start;
            do {
                if ((start = this.scanBackward(start - 1, -2, new CharacterMatch(new char[]{openingPeer, closingPeer}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == closingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion findSurroundingBlock(int offset) {
        if (offset < 1 || offset >= this.fDocument.getLength()) {
            return null;
        }
        int begin = this.findOpeningPeer(offset - 1, '{', '}');
        int end = this.findClosingPeer(offset, '{', '}');
        if (begin == -1 || end == -1) {
            return null;
        }
        return new Region(begin, end + 1 - begin);
    }

    public int findNonWhitespaceForward(int position, int bound) {
        return this.scanForward(position, bound, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, fNonWS);
    }

    public int findNonWhitespaceBackward(int position, int bound) {
        return this.scanBackward(position, bound, this.fNonWSDefaultPart);
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        if (bound == -2) {
            bound = this.fDocument.getLength();
        }
        Assert.isLegal((bound <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos < bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int position, int bound, char ch) {
        return this.scanForward(position, bound, new CharacterMatch(ch));
    }

    public int scanForward(int position, int bound, char[] chars) {
        return this.scanForward(position, bound, new CharacterMatch(chars));
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        Assert.isLegal((bound >= -1 ? 1 : 0) != 0);
        Assert.isLegal((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos > bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, false);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int position, int bound, char ch) {
        return this.scanBackward(position, bound, new CharacterMatch(ch));
    }

    public int scanBackward(int position, int bound, char[] chars) {
        return this.scanBackward(position, bound, new CharacterMatch(chars));
    }

    public boolean isDefaultPartition(int position) {
        return this.fPartition.equals(this.getPartition(position).getType());
    }

    private ITypedRegion getPartition(int position) {
        if (!this.contains((IRegion)this.fCachedPartition, position)) {
            Assert.isTrue((position >= 0 ? 1 : 0) != 0);
            Assert.isTrue((position <= this.fDocument.getLength() ? 1 : 0) != 0);
            try {
                this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)position, (boolean)false);
            }
            catch (BadLocationException badLocationException) {
                this.fCachedPartition = new TypedRegion(position, 0, "__no_partition_at_all");
            }
        }
        return this.fCachedPartition;
    }

    private boolean contains(IRegion region, int position) {
        int offset = region.getOffset();
        return offset <= position && position < offset + region.getLength();
    }

    public boolean isBracelessBlockStart(int position, int bound) {
        if (position < 1) {
            return false;
        }
        switch (this.previousToken(position, bound)) {
            case 1010: 
            case 1014: {
                return true;
            }
            case 6: {
                position = this.findOpeningPeer(this.fPos, '(', ')');
                if (position <= 0) break;
                switch (this.previousToken(position - 1, bound)) {
                    case 109: 
                    case 1011: 
                    case 1017: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static abstract class StopCondition {
        private StopCondition() {
        }

        public abstract boolean stop(char var1, int var2, boolean var3);

        public int nextPosition(int position, boolean forward) {
            return forward ? position + 1 : position - 1;
        }
    }

    private static class NonWhitespace
    extends StopCondition {
        private NonWhitespace() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }

        /* synthetic */ NonWhitespace(NonWhitespace nonWhitespace, NonWhitespace nonWhitespace2) {
            this();
        }
    }

    private final class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
            super(null, null);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && JavaHeuristicScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = JavaHeuristicScanner.this.getPartition(position);
            if (JavaHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static class NonJavaIdentifierPart
    extends StopCondition {
        private NonJavaIdentifierPart() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isJavaIdentifierPart(ch);
        }
    }

    private final class NonJavaIdentifierPartDefaultPartition
    extends NonJavaIdentifierPart {
        private NonJavaIdentifierPartDefaultPartition() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !JavaHeuristicScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = JavaHeuristicScanner.this.getPartition(position);
            if (JavaHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private final class CharacterMatch
    extends StopCondition {
        private final char[] fChars;

        public CharacterMatch(char ch) {
            this(new char[]{ch});
        }

        public CharacterMatch(char[] chars) {
            Assert.isNotNull((Object)chars);
            Assert.isTrue((chars.length > 0 ? 1 : 0) != 0);
            this.fChars = chars;
            Arrays.sort(chars);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return Arrays.binarySearch(this.fChars, ch) >= 0 && JavaHeuristicScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = JavaHeuristicScanner.this.getPartition(position);
            if (JavaHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }
}

