/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.corext.refactoring.changes.AddToClasspathChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectMainTypeNameProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectPackageDeclarationProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;

public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return;
        }
        String currTypeName = buffer.getText(problem.getOffset(), problem.getLength());
        String newTypeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        if (!JavaConventions.validateJavaTypeName((String)newTypeName).matches(4)) {
            proposals.add(new CorrectMainTypeNameProposal(cu, context, currTypeName, newTypeName, 5));
        }
        String newCUName = JavaModelUtil.getRenamedCUName(cu, currTypeName);
        ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
        if (!(newCU.exists() || isLinked || JavaConventions.validateCompilationUnitName((String)newCUName).matches(4))) {
            RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName, null);
            String label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renamecu_description, newCUName);
            proposals.add(new ChangeCorrectionProposal(label, change, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif")));
        }
    }

    public static void getWrongPackageDeclNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        int relevance = cu.getPackageDeclarations().length == 0 ? 7 : 5;
        proposals.add(new CorrectPackageDeclarationProposal(cu, problem, relevance));
        IPackageDeclaration[] packDecls = cu.getPackageDeclarations();
        String newPackName = packDecls.length > 0 ? packDecls[0].getElementName() : "";
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
        IPackageFragment newPack = root.getPackageFragment(newPackName);
        ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
        if (!newCU.exists() && !isLinked) {
            String label = newPack.isDefaultPackage() ? Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_default_description, cu.getElementName()) : Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_description, new Object[]{cu.getElementName(), newPack.getElementName()});
            CompositeChange composite = new CompositeChange(label);
            composite.add((Change)new CreatePackageChange(newPack));
            composite.add((Change)new MoveCompilationUnitChange(cu, newPack));
            proposals.add(new ChangeCorrectionProposal(label, (Change)composite, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_move.gif")));
        }
    }

    public static void removeImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        UnusedCodeFix fix = UnusedCodeFix.createRemoveUnusedImportFix(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_delete_import.gif");
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new UnusedCodeCleanUp(1), 6, image, context);
            proposals.add(proposal);
        }
        final ICompilationUnit cu = context.getCompilationUnit();
        String name = CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description;
        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(name, null, 5, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif")){

            public void apply(IDocument document) {
                FileEditorInput input = new FileEditorInput((IFile)cu.getResource());
                IWorkbenchPage p = JavaPlugin.getActivePage();
                if (p == null) {
                    return;
                }
                IEditorPart part = p.findEditor((IEditorInput)input);
                if (part instanceof JavaEditor) {
                    OrganizeImportsAction action = new OrganizeImportsAction((JavaEditor)part);
                    action.run(cu);
                }
            }
        };
        proposals.add(proposal);
    }

    public static void importNotFoundProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        IJavaProject project = cu.getJavaProject();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode != null) {
            char[] packageName;
            ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent(selectedNode, 26);
            if (importDeclaration == null) {
                return;
            }
            String name = ASTNodes.asString((ASTNode)importDeclaration.getName());
            char[] typeName = null;
            if (importDeclaration.isOnDemand()) {
                packageName = name.toCharArray();
            } else {
                packageName = Signature.getQualifier((String)name).toCharArray();
                typeName = Signature.getSimpleName((String)name).toCharArray();
            }
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            ArrayList res = new ArrayList();
            TypeInfoRequestor requestor = new TypeInfoRequestor(res);
            new SearchEngine().searchAllTypeNames(packageName, typeName, 8, 0, scope, (TypeNameRequestor)requestor, 3, null);
            if (res.isEmpty()) {
                return;
            }
            HashSet<Object> addedClaspaths = new HashSet<Object>();
            int i = 0;
            while (i < res.size()) {
                IPackageFragmentRoot root;
                IClasspathEntry entry;
                TypeInfo curr = (TypeInfo)res.get(i);
                IType type = curr.resolveType(scope);
                if (type != null && (entry = (root = (IPackageFragmentRoot)type.getAncestor(3)).getRawClasspathEntry()) != null) {
                    AddToClasspathChange change;
                    String label;
                    IJavaProject other = root.getJavaProject();
                    int entryKind = entry.getEntryKind();
                    if ((entry.isExported() || entryKind == 3) && addedClaspaths.add(other)) {
                        Object[] args = new String[]{other.getElementName(), project.getElementName()};
                        String label2 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_project_description, args);
                        IClasspathEntry newEntry = JavaCore.newProjectEntry((IPath)other.getPath());
                        AddToClasspathChange change2 = new AddToClasspathChange(project, newEntry);
                        if (!change2.entryAlreadyExists()) {
                            ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label2, change2, 8, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
                            proposals.add(proposal);
                        }
                    }
                    if ((entryKind == 1 || entryKind == 4 || entryKind == 5) && addedClaspaths.add(entry) && (label = ReorgCorrectionsSubProcessor.getAddClasspathLabel(entry, root, project)) != null && !(change = new AddToClasspathChange(project, entry)).entryAlreadyExists()) {
                        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label, change, 7, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
                        proposals.add(proposal);
                    }
                }
                ++i;
            }
        }
    }

    private static String getAddClasspathLabel(IClasspathEntry entry, IPackageFragmentRoot root, IJavaProject project) {
        switch (entry.getEntryKind()) {
            case 1: {
                if (root.isArchive()) {
                    Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0L), project.getElementName()};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_archive_description, args);
                }
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0L), project.getElementName()};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_classfolder_description, args);
            }
            case 4: {
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0L), project.getElementName()};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_variable_description, args);
            }
            case 5: {
                try {
                    Object[] args = new String[]{JavaElementLabels.getContainerEntryLabel(entry.getPath(), root.getJavaProject()), project.getElementName()};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_library_description, args);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return null;
    }

    public static void getNeed50ComplianceProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        String label1 = CorrectionMessages.ReorgCorrectionsSubProcessor_50_project_compliance_description;
        proposals.add(new ChangeTo50Compliance(label1, project, false, 5));
        if (project.getOption("org.eclipse.jdt.core.compiler.compliance", false) == null) {
            String label2 = CorrectionMessages.ReorgCorrectionsSubProcessor_50_workspace_compliance_description;
            proposals.add(new ChangeTo50Compliance(label2, project, true, 6));
        }
    }

    public static void getIncorrectBuildPathProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IProject project = context.getCompilationUnit().getJavaProject().getProject();
        String label = CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label;
        OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, null);
        proposals.add(proposal);
    }

    public static void getAccessRulesProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ITypeBinding referencedElement = null;
        ASTNode node = problem.getCoveredNode(context.getASTRoot());
        if (node instanceof Type) {
            referencedElement = ((Type)node).resolveBinding();
        } else if (node instanceof Name) {
            referencedElement = ((Name)node).resolveBinding();
        }
        IProject project = context.getCompilationUnit().getJavaProject().getProject();
        String label = CorrectionMessages.ReorgCorrectionsSubProcessor_accessrules_description;
        OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, (IBinding)referencedElement);
        proposals.add(proposal);
    }

    private static final class OpenBuildPathCorrectionProposal
    extends ChangeCorrectionProposal {
        private final IProject fProject;
        private final IBinding fReferencedType;

        private OpenBuildPathCorrectionProposal(IProject project, String label, int relevance, IBinding referencedType) {
            super(label, null, relevance, null);
            this.fProject = project;
            this.fReferencedType = referencedType;
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.access_restriction_attrib.gif"));
        }

        public void apply(IDocument document) {
            IPackageFragmentRoot root;
            IJavaElement elem;
            HashMap<Object, Object> data = null;
            if (this.fReferencedType != null && (elem = this.fReferencedType.getJavaElement()) != null && (root = (IPackageFragmentRoot)elem.getAncestor(3)) != null) {
                try {
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    if (entry != null) {
                        data = new HashMap<Object, Object>(1);
                        data.put(BuildPathsPropertyPage.DATA_REVEAL_ENTRY, entry);
                        if (entry.getEntryKind() != 5) {
                            data.put(BuildPathsPropertyPage.DATA_REVEAL_ATTRIBUTE_KEY, "accessrules");
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            PreferencesUtil.createPropertyDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (IAdaptable)this.fProject, (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, data).open();
        }

        public String getAdditionalProposalInfo() {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_description, this.fProject.getName());
        }
    }

    private static final class ChangeTo50Compliance
    extends ChangeCorrectionProposal
    implements IWorkspaceRunnable {
        private final IJavaProject fProject;
        private final boolean fChangeOnWorkspace;
        private Job fUpdateJob;
        private boolean f50JREFound;

        public ChangeTo50Compliance(String name, IJavaProject project, boolean changeOnWorkspace, int relevance) {
            super(name, null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            this.fProject = project;
            this.fChangeOnWorkspace = changeOnWorkspace;
            this.fUpdateJob = null;
            this.f50JREFound = false;
        }

        private boolean is50orGreaterVMInstall(IVMInstall install) {
            if (install instanceof IVMInstall2) {
                String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)install, "1.3");
                return JavaModelUtil.is50OrHigher(compliance);
            }
            return false;
        }

        private IVMInstall find50OrGreaterVMInstall() {
            IVMInstallType[] installTypes = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installTypes.length) {
                IVMInstall[] installs = installTypes[i].getVMInstalls();
                int k = 0;
                while (k < installs.length) {
                    if (this.is50orGreaterVMInstall(installs[k])) {
                        return installs[k];
                    }
                    ++k;
                }
                ++i;
            }
            return null;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            boolean needsBuild = this.updateJRE(monitor);
            if (needsBuild) {
                this.fUpdateJob = CoreUtility.getBuildJob(this.fChangeOnWorkspace ? null : this.fProject.getProject());
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean updateJRE(IProgressMonitor monitor) throws CoreException, JavaModelException {
            block8: {
                block9: {
                    block10: {
                        try {
                            vm50Install = this.find50OrGreaterVMInstall();
                            v0 = this.f50JREFound = vm50Install != null;
                            if (vm50Install == null) break block8;
                            install = JavaRuntime.getVMInstall((IJavaProject)this.fProject);
                            if (this.fChangeOnWorkspace) {
                                monitor.beginTask(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_operation, 4);
                                defaultVM = JavaRuntime.getDefaultVMInstall();
                                if (defaultVM != null && !defaultVM.equals(install)) {
                                    newPath = new Path(JavaRuntime.JRE_CONTAINER);
                                    this.updateClasspath((IPath)newPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                } else {
                                    monitor.worked(1);
                                }
                                if (defaultVM != null && this.is50orGreaterVMInstall(defaultVM)) break block9;
                                JavaRuntime.setDefaultVMInstall((IVMInstall)vm50Install, (IProgressMonitor)new SubProgressMonitor(monitor, 3), (boolean)true);
lbl17:
                                // 2 sources

                                while (true) {
                                    var6_7 = null;
                                    break block10;
                                    break;
                                }
                            }
                            if (install == null || !this.is50orGreaterVMInstall(install)) {
                                newPath = new Path(JavaRuntime.JRE_CONTAINER).append(vm50Install.getVMInstallType().getId()).append(vm50Install.getName());
                                this.updateClasspath(newPath, monitor);
                                ** continue;
                            }
                            break block8;
                        }
                        catch (Throwable var7_11) {
                            var6_9 = null;
                            monitor.done();
                            throw var7_11;
                        }
                    }
                    monitor.done();
                    return false;
                }
                var6_8 = null;
                monitor.done();
                return true;
            }
            var6_10 = null;
            monitor.done();
            return true;
        }

        private void updateClasspath(IPath newPath, IProgressMonitor monitor) throws JavaModelException {
            IClasspathEntry[] classpath = this.fProject.getRawClasspath();
            Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry curr = classpath[i];
                if (curr.getEntryKind() == 5 && curr.getPath().matchingFirstSegments((IPath)jreContainerPath) > 0) {
                    classpath[i] = JavaCore.newContainerEntry((IPath)newPath, (IAccessRule[])curr.getAccessRules(), (IClasspathAttribute[])curr.getExtraAttributes(), (boolean)curr.isExported());
                }
                ++i;
            }
            this.fProject.setRawClasspath(classpath, monitor);
        }

        public String getAdditionalProposalInfo() {
            StringBuffer message = new StringBuffer();
            if (this.fChangeOnWorkspace) {
                message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeworkspace_description);
            } else {
                message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeproject_description);
            }
            IVMInstall vm50Install = this.find50OrGreaterVMInstall();
            if (vm50Install != null) {
                try {
                    IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.fProject);
                    if (this.fChangeOnWorkspace) {
                        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
                        if (defaultVM != null && !defaultVM.equals(install)) {
                            message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJREToDefault_description);
                        }
                        if (defaultVM == null || !this.is50orGreaterVMInstall(defaultVM)) {
                            message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeWorkspaceJRE_description, vm50Install.getName()));
                        }
                    } else if (install == null || !this.is50orGreaterVMInstall(install)) {
                        message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJRE_description, vm50Install.getName()));
                    }
                }
                catch (CoreException coreException) {}
            }
            return message.toString();
        }

        public void apply(IDocument document) {
            Map map;
            if (this.fChangeOnWorkspace) {
                map = JavaCore.getOptions();
                JavaModelUtil.set50CompilanceOptions(map);
                JavaCore.setOptions((Hashtable)map);
            } else {
                map = this.fProject.getOptions(false);
                JavaModelUtil.set50CompilanceOptions(map);
                this.fProject.setOptions(map);
            }
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(this));
            }
            catch (InvocationTargetException e) {
                JavaPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.fUpdateJob != null) {
                this.fUpdateJob.schedule();
            }
            if (!this.f50JREFound) {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)CorrectionMessages.ReorgCorrectionsSubProcessor_no_50jre_title, (String)CorrectionMessages.ReorgCorrectionsSubProcessor_no_50jre_message);
            }
        }
    }
}

