/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class LazyJavaCompletionProposal
extends AbstractJavaCompletionProposal {
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String COMMA = ",";
    protected static final String SPACE = " ";
    private boolean fDisplayStringComputed;
    private boolean fReplacementStringComputed;
    private boolean fReplacementOffsetComputed;
    private boolean fReplacementLengthComputed;
    private boolean fCursorPositionComputed;
    private boolean fImageComputed;
    private boolean fContextInformationComputed;
    private boolean fProposalInfoComputed;
    private boolean fTriggerCharactersComputed;
    private boolean fSortStringComputed;
    private boolean fRelevanceComputed;
    private FormatterPrefs fFormatterPrefs;
    protected final CompletionProposal fProposal;
    protected final JavaContentAssistInvocationContext fInvocationContext;

    public LazyJavaCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        Assert.isNotNull((Object)proposal);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)context.getCoreContext());
        this.fInvocationContext = context;
        this.fProposal = proposal;
    }

    public final char[] getTriggerCharacters() {
        if (!this.fTriggerCharactersComputed) {
            this.setTriggerCharacters(this.computeTriggerCharacters());
        }
        return super.getTriggerCharacters();
    }

    protected char[] computeTriggerCharacters() {
        return new char[0];
    }

    public final void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharactersComputed = true;
        super.setTriggerCharacters(triggerCharacters);
    }

    public final void setProposalInfo(ProposalInfo proposalInfo) {
        this.fProposalInfoComputed = true;
        super.setProposalInfo(proposalInfo);
    }

    protected final ProposalInfo getProposalInfo() {
        if (!this.fProposalInfoComputed) {
            this.setProposalInfo(this.computeProposalInfo());
        }
        return super.getProposalInfo();
    }

    protected ProposalInfo computeProposalInfo() {
        return null;
    }

    public final void setCursorPosition(int cursorPosition) {
        this.fCursorPositionComputed = true;
        super.setCursorPosition(cursorPosition);
    }

    protected final int getCursorPosition() {
        if (!this.fCursorPositionComputed) {
            this.setCursorPosition(this.computeCursorPosition());
        }
        return super.getCursorPosition();
    }

    protected int computeCursorPosition() {
        return this.getReplacementString().length();
    }

    protected final boolean isInJavadoc() {
        return this.fInvocationContext.getCoreContext().isInJavadoc();
    }

    public final IContextInformation getContextInformation() {
        if (!this.fContextInformationComputed) {
            this.setContextInformation(this.computeContextInformation());
        }
        return super.getContextInformation();
    }

    protected IContextInformation computeContextInformation() {
        return null;
    }

    public final void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformationComputed = true;
        super.setContextInformation(contextInformation);
    }

    public final String getDisplayString() {
        if (!this.fDisplayStringComputed) {
            this.setDisplayString(this.computeDisplayString());
        }
        return super.getDisplayString();
    }

    protected final void setDisplayString(String string) {
        this.fDisplayStringComputed = true;
        super.setDisplayString(string);
    }

    protected String computeDisplayString() {
        return this.fInvocationContext.getLabelProvider().createLabel(this.fProposal);
    }

    public final String getAdditionalProposalInfo() {
        return super.getAdditionalProposalInfo();
    }

    public final int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public final int getReplacementOffset() {
        if (!this.fReplacementOffsetComputed) {
            this.setReplacementOffset(this.fProposal.getReplaceStart());
        }
        return super.getReplacementOffset();
    }

    public final void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffsetComputed = true;
        super.setReplacementOffset(replacementOffset);
    }

    public final int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.fProposal.getReplaceEnd() - this.fProposal.getReplaceStart());
        }
        return super.getReplacementLength();
    }

    public final void setReplacementLength(int replacementLength) {
        this.fReplacementLengthComputed = true;
        super.setReplacementLength(replacementLength);
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    protected String computeReplacementString() {
        return String.valueOf(this.fProposal.getCompletion());
    }

    public final void setReplacementString(String replacementString) {
        this.fReplacementStringComputed = true;
        super.setReplacementString(replacementString);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getReplacementString();
    }

    public final Image getImage() {
        if (!this.fImageComputed) {
            this.setImage(this.computeImage());
        }
        return super.getImage();
    }

    protected Image computeImage() {
        return JavaPlugin.getImageDescriptorRegistry().get(this.fInvocationContext.getLabelProvider().createImageDescriptor(this.fProposal));
    }

    public final void setImage(Image image) {
        this.fImageComputed = true;
        super.setImage(image);
    }

    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        if (this.fProposal.getKind() == 12) {
            StringBuffer buf = new StringBuffer();
            buf.append(Signature.toCharArray((char[])this.fProposal.getDeclarationSignature()));
            buf.append('.');
            buf.append(this.getDisplayString());
            return this.isPrefix(prefix, buf.toString());
        }
        return false;
    }

    public final int getRelevance() {
        if (!this.fRelevanceComputed) {
            this.setRelevance(this.computeRelevance());
        }
        return super.getRelevance();
    }

    public final void setRelevance(int relevance) {
        this.fRelevanceComputed = true;
        super.setRelevance(relevance);
    }

    protected int computeRelevance() {
        int baseRelevance = this.fProposal.getRelevance() * 16;
        switch (this.fProposal.getKind()) {
            case 8: {
                return baseRelevance + 0;
            }
            case 4: {
                return baseRelevance + 1;
            }
            case 3: {
                return baseRelevance + 2;
            }
            case 1: 
            case 9: {
                return baseRelevance + 3;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                return baseRelevance + 4;
            }
            case 11: {
                return baseRelevance + 4;
            }
            case 2: {
                return baseRelevance + 5;
            }
            case 5: 
            case 10: {
                return baseRelevance + 6;
            }
        }
        return baseRelevance;
    }

    public final String getSortString() {
        if (!this.fSortStringComputed) {
            this.setSortString(this.computeSortString());
        }
        return super.getSortString();
    }

    protected final void setSortString(String string) {
        this.fSortStringComputed = true;
        super.setSortString(string);
    }

    protected String computeSortString() {
        return this.getDisplayString();
    }

    protected FormatterPrefs getFormatterPrefs() {
        if (this.fFormatterPrefs == null) {
            ICompilationUnit cu = this.fInvocationContext.getCompilationUnit();
            this.fFormatterPrefs = new FormatterPrefs(cu == null ? null : cu.getJavaProject());
        }
        return this.fFormatterPrefs;
    }

    protected static final class FormatterPrefs {
        public final boolean beforeOpeningParen;
        public final boolean afterOpeningParen;
        public final boolean beforeComma;
        public final boolean afterComma;
        public final boolean beforeClosingParen;
        public final boolean inEmptyList;
        public final boolean beforeOpeningBracket;
        public final boolean afterOpeningBracket;
        public final boolean beforeTypeArgumentComma;
        public final boolean afterTypeArgumentComma;
        public final boolean beforeClosingBracket;

        FormatterPrefs(IJavaProject project) {
            this.beforeOpeningParen = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", false);
            this.afterOpeningParen = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", false);
            this.beforeComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", false);
            this.afterComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", true);
            this.beforeClosingParen = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", false);
            this.inEmptyList = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", false);
            this.beforeOpeningBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", false);
            this.afterOpeningBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", false);
            this.beforeTypeArgumentComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", false);
            this.afterTypeArgumentComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", true);
            this.beforeClosingBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", false);
        }

        protected final boolean getCoreOption(IJavaProject project, String key, boolean def) {
            String option = this.getCoreOption(project, key);
            if ("insert".equals(option)) {
                return true;
            }
            if ("do not insert".equals(option)) {
                return false;
            }
            return def;
        }

        protected final String getCoreOption(IJavaProject project, String key) {
            if (project == null) {
                return JavaCore.getOption((String)key);
            }
            return project.getOption(key, true);
        }
    }
}

