/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class OthersWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.jdt.internal.ui.OthersWorkingSet";
    private IWorkingSet fWorkingSet;
    private WorkingSetModel fWorkingSetModel;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fWorkingSetListener;
    private IElementChangedListener fJavaElementChangeListener;
    static /* synthetic */ Class class$0;

    public void add(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == null && this.fWorkingSetModel != null ? 1 : 0) != 0);
        this.fWorkingSet = workingSet;
    }

    public boolean remove(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == workingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.fWorkingSet == workingSet;
    }

    public void init(WorkingSetModel model) {
        this.fWorkingSetModel = model;
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fWorkingSetListener = new WorkingSetListener();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetListener);
        this.fJavaElementChangeListener = new JavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fJavaElementChangeListener, (int)1);
    }

    public void dispose() {
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
        if (this.fJavaElementChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fJavaElementChangeListener);
        }
    }

    public void updateElements() {
        Assert.isTrue((this.fWorkingSet != null && this.fWorkingSetModel != null ? 1 : 0) != 0);
        IWorkingSet[] activeWorkingSets = this.fWorkingSetModel.getActiveWorkingSets();
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<IResource> projects = new HashSet<IResource>();
        int i = 0;
        while (i < activeWorkingSets.length) {
            if (activeWorkingSets[i] != this.fWorkingSet) {
                IAdaptable[] elements = activeWorkingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IResource resource;
                    IAdaptable element = elements[j];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)element.getAdapter((Class)clazz)) != null && resource.getType() == 4) {
                        projects.add(resource);
                    }
                    ++j;
                }
            }
            ++i;
        }
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IJavaProject[] jProjects = model.getJavaProjects();
            int i2 = 0;
            while (i2 < jProjects.length) {
                if (!projects.contains(jProjects[i2].getProject())) {
                    result.add(jProjects[i2]);
                }
                ++i2;
            }
            Object[] rProjects = model.getNonJavaResources();
            int i3 = 0;
            while (i3 < rProjects.length) {
                if (!projects.contains(rProjects[i3])) {
                    result.add(rProjects[i3]);
                }
                ++i3;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        this.fWorkingSet.setElements(result.toArray(new IAdaptable[result.size()]));
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (OthersWorkingSetUpdater.this.fWorkingSet == null) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(3, 4);
            if (affectedChildren.length > 0) {
                OthersWorkingSetUpdater.this.updateElements();
            } else {
                affectedChildren = delta.getAffectedChildren(4, 4);
                int i = 0;
                while (i < affectedChildren.length) {
                    IResourceDelta projectDelta = affectedChildren[i];
                    if ((projectDelta.getFlags() & 0x80000) != 0) {
                        OthersWorkingSetUpdater.this.updateElements();
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private class WorkingSetListener
    implements IPropertyChangeListener {
        private WorkingSetListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet changedWorkingSet;
            if ("workingSetContentChange".equals(event.getProperty()) && (changedWorkingSet = (IWorkingSet)event.getNewValue()) != OthersWorkingSetUpdater.this.fWorkingSet && OthersWorkingSetUpdater.this.fWorkingSetModel.isActiveWorkingSet(changedWorkingSet)) {
                OthersWorkingSetUpdater.this.updateElements();
            }
        }
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        private JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (OthersWorkingSetUpdater.this.fWorkingSet == null) {
                return;
            }
            this.processJavaDelta(new ArrayList<IAdaptable>(Arrays.asList(OthersWorkingSetUpdater.this.fWorkingSet.getElements())), event.getDelta());
        }

        private void processJavaDelta(List elements, IJavaElementDelta delta) {
            IJavaElement jElement = delta.getElement();
            int type = jElement.getElementType();
            if (type == 2) {
                int index = elements.indexOf(jElement);
                int kind = delta.getKind();
                int flags = delta.getFlags();
                if (kind == 4) {
                    if (index != -1 && (flags & 0x400) != 0) {
                        elements.set(index, ((IJavaProject)jElement).getProject());
                        OthersWorkingSetUpdater.this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
                    } else if ((flags & 0x200) != 0 && (index = elements.indexOf(((IJavaProject)jElement).getProject())) != -1) {
                        elements.set(index, jElement);
                        OthersWorkingSetUpdater.this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
                    }
                }
                return;
            }
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.processJavaDelta(elements, children[i]);
                ++i;
            }
        }
    }
}

