/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;

public class JavadocContentAccess {
    private JavadocContentAccess() {
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws JavaModelException {
        JavaDocCommentReader reader;
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange != null && !JavadocContentAccess.containsOnlyInheritDoc(reader = new JavaDocCommentReader(buf, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1), javadocRange.getLength())) {
            reader.reset();
            return reader;
        }
        if (allowInherited && member.getElementType() == 9) {
            IMethod method = (IMethod)member;
            return JavadocContentAccess.findDocInHierarchy(method.getDeclaringType(), method.getElementName(), method.getParameterTypes(), method.isConstructor());
        }
        return null;
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int length) {
        char[] content = new char[length];
        try {
            reader.read(content, 0, length);
        }
        catch (IOException iOException) {
            return false;
        }
        return new String(content).trim().equals("{@inheritDoc}");
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws JavaModelException {
        String s;
        Reader contentReader = JavadocContentAccess.getContentReader(member, allowInherited);
        if (contentReader != null) {
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        if (useAttachedJavadoc && member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(null)) != null) {
            return new StringReader(s);
        }
        return null;
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited) throws JavaModelException {
        return JavadocContentAccess.getHTMLContentReader(member, allowInherited, false);
    }

    private static Reader findDocInHierarchy(IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            Reader reader;
            IMethod method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (method != null && (reader = JavadocContentAccess.getContentReader((IMember)method, false)) != null) {
                return reader;
            }
            ++i;
        }
        return null;
    }
}

