/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class ConvertingSelectionProvider
implements ISelectionProvider {
    private final ISelectionProvider fProvider;
    private SelectionChangedListener fListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConvertingSelectionProvider(ISelectionProvider provider) {
        Assert.isNotNull(provider);
        this.fProvider = provider;
    }

    public ISelection convertFrom(ISelection viewerSelection) {
        return this.convertFromUsingDefaultMechanism(viewerSelection);
    }

    private ISelection convertFromUsingDefaultMechanism(ISelection viewerSelection) {
        if (!(viewerSelection instanceof IStructuredSelection)) {
            return viewerSelection;
        }
        IStructuredSelection selection = (IStructuredSelection)viewerSelection;
        ArrayList result = new ArrayList(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IResource || element instanceof IJavaElement) {
                result.add(element);
                continue;
            }
            if (element instanceof IAdaptable) {
                IResource resource;
                IJavaElement jElement;
                IAdaptable adaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((jElement = (IJavaElement)adaptable.getAdapter((Class)clazz)) != null) {
                    result.add(jElement);
                    continue;
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null) {
                    result.add(resource);
                    continue;
                }
                result.add(element);
                continue;
            }
            result.add(element);
        }
        return new StructuredSelection(result);
    }

    public ISelection convertTo(ISelection selection) {
        return selection;
    }

    public final ISelection getSelection() {
        return this.convertFrom(this.fProvider.getSelection());
    }

    public final void setSelection(ISelection selection) {
        this.fProvider.setSelection(this.convertTo(selection));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fListener == null) {
            this.fListener = new SelectionChangedListener();
            this.fProvider.addSelectionChangedListener((ISelectionChangedListener)this.fListener);
        }
        this.fListener.addListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fListener == null) {
            return;
        }
        this.fListener.removeListener(listener);
        if (this.fListener.isEmpty()) {
            this.fProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fListener);
            this.fListener = null;
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        ListenerList fListeners = new ListenerList();

        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = ConvertingSelectionProvider.this.convertFrom(event.getSelection());
            SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)ConvertingSelectionProvider.this, selection);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(newEvent);
                ++i;
            }
        }

        public void addListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public void removeListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public boolean isEmpty() {
            return this.fListeners.isEmpty();
        }
    }
}

