/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    static /* synthetic */ Class class$0;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_action");
    }

    public OpenAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false) != null);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof ISourceReference || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection selection) {
        if (!this.isProcessable()) {
            return;
        }
        try {
            IJavaElement element = SelectionConverter.codeResolve(this.fEditor, false, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element);
            if (element == null) {
                IEditorStatusLine statusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((statusLine = (IEditorStatusLine)this.fEditor.getAdapter(clazz)) != null) {
                    statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            int type = element.getElementType();
            if (type == 2 || type == 3 || type == 4) {
                element = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
            }
            this.run(new Object[]{element});
        }
        catch (JavaModelException e) {
            this.showError((CoreException)((Object)e));
        }
    }

    private boolean isProcessable() {
        IJavaElement je;
        if (this.fEditor != null && (je = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false)) instanceof ICompilationUnit && !JavaModelUtil.isPrimary((ICompilationUnit)je)) {
            return true;
        }
        return ActionUtil.isProcessable(this.getShell(), this.fEditor);
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            block10: {
                Object element = elements[i];
                try {
                    element = this.getElementToOpen(element);
                    boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open(element, activateOnOpen);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, ActionMessages.OpenAction_error_message, (Throwable)e));
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_messageProblems, (IStatus)e.getStatus());
                }
                catch (PartInitException x) {
                    String name = null;
                    if (element instanceof IJavaElement) {
                        name = ((IJavaElement)element).getElementName();
                    } else if (element instanceof IStorage) {
                        name = ((IStorage)element).getName();
                    } else if (element instanceof IResource) {
                        name = ((IResource)element).getName();
                    }
                    if (name == null) break block10;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)Messages.format(ActionMessages.OpenAction_error_messageArgs, new String[]{name, x.getMessage()}));
                }
            }
            ++i;
        }
    }

    public Object getElementToOpen(Object object) throws JavaModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }

    private void showError(CoreException e) {
        ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
    }
}

