/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ReplaceInvocationsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ReplaceInvocationsAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public ReplaceInvocationsAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ReplaceInvocationsAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.replace_invocations_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue(first instanceof IMethod);
            IMethod method = (IMethod)first;
            if (ActionUtil.isProcessable(this.getShell(), method)) {
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(method, this.getShell());
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
    }

    private void handleException(CoreException e) {
        ExceptionHandler.handle(e, RefactoringMessages.ReplaceInvocationsAction_dialog_title, RefactoringMessages.ReplaceInvocationsAction_unavailable);
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement editorInput = SelectionConverter.getInput(this.fEditor);
            if ((editorInput instanceof ICompilationUnit || editorInput instanceof IClassFile) && ActionUtil.isProcessable(this.getShell(), editorInput)) {
                IJavaElement unit = editorInput;
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(unit, selection.getOffset(), selection.getLength(), this.getShell());
            }
        }
        catch (JavaModelException e) {
            this.handleException((CoreException)((Object)e));
        }
    }
}

