/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.ui.internal.preferences.Messages;
import org.eclipse.jdt.apt.ui.internal.util.ExceptionHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class BaseConfigurationBlock {
    private static final String SETTINGS_EXPANDED = "expanded";
    protected final Key[] fAllKeys;
    private boolean fOriginallyHadProjectSettings;
    private Map<Key, String> fDisabledProjectSettings;
    protected IScopeContext[] fLookupOrder;
    protected final IWorkingCopyManager fManager;
    protected final ArrayList<Button> fCheckBoxes;
    protected final ArrayList<Combo> fComboBoxes;
    protected final ArrayList<ExpandableComposite> fExpandedComposites;
    protected final HashMap<Scrollable, Label> fLabels;
    protected final ArrayList<Text> fTextBoxes;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    private SelectionListener fSelectionListener;
    protected final IProject fProject;
    protected final AptProject fAptProject;
    private IWorkbenchPreferenceContainer fContainer;
    private Shell fShell;
    private Control fBlockControl;

    protected static Key getKey(String plugin, String name) {
        return new Key(plugin, name);
    }

    public BaseConfigurationBlock(IStatusChangeListener context, IProject project, Key[] keys, IWorkbenchPreferenceContainer container) {
        this.fContext = context;
        this.fProject = project;
        this.fAllKeys = keys;
        this.fContainer = container;
        this.fManager = new WorkingCopyManager();
        if (this.fProject != null) {
            this.fLookupOrder = new IScopeContext[]{new ProjectScope(this.fProject), new InstanceScope(), new DefaultScope()};
            this.fAptProject = AptPlugin.getAptProject((IJavaProject)JavaCore.create((IProject)this.fProject));
        } else {
            this.fLookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            this.fAptProject = null;
        }
        this.testIfOptionsComplete(keys);
        if (this.fProject == null || this.hasProjectSpecificOptionsNoCache(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new IdentityHashMap<Key, String>();
            int i = 0;
            while (i < keys.length) {
                Key curr = keys[i];
                this.fDisabledProjectSettings.put(curr, curr.getStoredValue(this.fLookupOrder, false, this.fManager));
                ++i;
            }
        }
        this.settingsUpdated();
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fLabels = new HashMap();
        this.fExpandedComposites = new ArrayList();
    }

    protected Button addCheckBox(Composite parent, String label, Key key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)checkBox);
        String currValue = this.getValue(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected Combo addComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(256));
        this.fLabels.put((Scrollable)comboBox, labelControl);
        return comboBox;
    }

    protected Combo addInversedComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(composite, key, values, valueLabels);
        comboBox.setFont(JFaceResources.getDialogFont());
        comboBox.setLayoutData((Object)new GridData(256));
        Label labelControl = new Label(composite, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        this.fLabels.put((Scrollable)comboBox, labelControl);
        return comboBox;
    }

    protected Text addTextField(Composite parent, String label, Key key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        this.makeScrollableCompositeAware((Control)textBox);
        this.fLabels.put((Scrollable)textBox, labelControl);
        String currValue = this.getValue(key);
        if (currValue != null) {
            textBox.setText(currValue);
        }
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        }
        data.horizontalIndent = indent;
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    protected boolean checkValue(Key key, String value) {
        return value.equals(this.getValue(key));
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String oldValue = this.setValue(data.getKey(), newValue);
        this.validateSettings(data.getKey(), oldValue, newValue);
    }

    public final Control createPreferenceContent(Composite parent) {
        this.fBlockControl = this.createContents(parent);
        if (this.fBlockControl != null) {
            this.cacheOriginalValues();
            this.initContents();
        }
        return this.fBlockControl;
    }

    protected abstract Control createContents(Composite var1);

    protected void cacheOriginalValues() {
        this.fOriginallyHadProjectSettings = this.hasProjectSpecificOptionsNoCache(this.fProject);
    }

    protected void initContents() {
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BaseConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandedComposites.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    public void dispose() {
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    protected Control findControl(Key key) {
        Combo comboBox = this.getComboBox(key);
        if (comboBox != null) {
            return comboBox;
        }
        Button checkBox = this.getCheckBox(key);
        if (checkBox != null) {
            return checkBox;
        }
        Text text = this.getTextControl(key);
        if (text != null) {
            return text;
        }
        return null;
    }

    protected boolean getBooleanValue(Key key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected Button getCheckBox(Key key) {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            Button curr = this.fCheckBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Combo getComboBox(Key key) {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String[] strings = new String[]{Messages.BaseConfigurationBlock_settingsChanged, workspaceSettings ? Messages.BaseConfigurationBlock_fullRebuildRequired : Messages.BaseConfigurationBlock_rebuildRequired};
        return strings;
    }

    protected ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected final IWorkbenchPreferenceContainer getPreferenceContainer() {
        return this.fContainer;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    BaseConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected String getStoredValue(Key key) {
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected Text getTextControl(Key key) {
        int i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            Text curr = this.fTextBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BaseConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    protected String getValue(Key key) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.get(key);
        }
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    public boolean hasProjectSpecificOptionsNoCache(IProject project) {
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project);
            Key[] allKeys = this.fAllKeys;
            int i = 0;
            while (i < allKeys.length) {
                if (allKeys[i].getStoredValue((IScopeContext)projectContext, null) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected Combo newComboControl(Composite composite, Key key, String[] values, String[] valueLabels) {
        ControlData data = new ControlData(key, values);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        this.makeScrollableCompositeAware((Control)comboBox);
        String currValue = this.getValue(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    public boolean performApply() {
        return this.processChanges(null);
    }

    public void performDefaults() {
        DefaultScope defaultScope = this.fProject == null ? new DefaultScope() : new InstanceScope();
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            String defValue = curr.getStoredValue((IScopeContext)defaultScope, null);
            this.setValue(curr, defValue);
            ++i;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public boolean performOk() {
        return this.processChanges(this.fContainer);
    }

    public void performRevert() {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            String origValue = curr.getStoredValue(this.fLookupOrder, false, null);
            this.setValue(curr, origValue);
            ++i;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        boolean isProjectSpecific;
        boolean projectSpecificnessChanged = false;
        boolean bl = isProjectSpecific = this.fProject != null && this.fBlockControl.getEnabled();
        if (this.fOriginallyHadProjectSettings ^ isProjectSpecific) {
            projectSpecificnessChanged = true;
        } else if (this.fProject != null && !isProjectSpecific) {
            return true;
        }
        if (!projectSpecificnessChanged && !this.settingsChanged(this.fLookupOrder[0])) {
            return true;
        }
        int response = 1;
        String[] strings = this.getFullBuildDialogStrings(this.fProject == null);
        if (strings != null) {
            MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            response = dialog.open();
        }
        if (response == 0 || response == 1) {
            this.saveSettings();
            if (container == null) {
                this.cacheOriginalValues();
            }
        }
        if (response == 0) {
            if (container != null) {
                container.registerUpdateJob(CoreUtility.getBuildJob((IProject)this.fProject));
            } else {
                CoreUtility.getBuildJob((IProject)this.fProject).schedule();
            }
        } else if (response != 1) {
            return false;
        }
        return true;
    }

    protected void saveSettings() {
        try {
            this.fManager.applyChanges();
        }
        catch (BackingStoreException e) {
            ExceptionHandler.log(e, "Unable to save preferences");
        }
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite excomposite = this.fExpandedComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    public void selectOption(Key key) {
        Control control = this.findControl(key);
        if (control != null) {
            ExpandableComposite expandable;
            if (!this.fExpandedComposites.isEmpty() && (expandable = this.getParentExpandableComposite(control)) != null) {
                int i = 0;
                while (i < this.fExpandedComposites.size()) {
                    ExpandableComposite curr;
                    curr.setExpanded((curr = this.fExpandedComposites.get(i)) == expandable);
                    ++i;
                }
                this.expandedStateChanged(expandable);
            }
            control.setFocus();
        }
    }

    public void selectOption(String key, String qualifier) {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            if (curr.getName().equals(key) && curr.getQualifier().equals(qualifier)) {
                this.selectOption(curr);
            }
            ++i;
        }
    }

    protected void setComboEnabled(Key key, boolean enabled) {
        Combo combo = this.getComboBox(key);
        Label label = this.fLabels.get(combo);
        combo.setEnabled(enabled);
        label.setEnabled(enabled);
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected boolean settingsChanged(IScopeContext currContext) {
        boolean needsBuild = false;
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key key = this.fAllKeys[i];
            String oldVal = key.getStoredValue(currContext, null);
            String val = key.getStoredValue(currContext, this.fManager);
            if (val == null) {
                if (oldVal != null) {
                    needsBuild |= !oldVal.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
                }
            } else if (!val.equals(oldVal)) {
                needsBuild |= oldVal != null || !val.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
            }
            ++i;
        }
        return needsBuild;
    }

    protected void settingsUpdated() {
    }

    protected String setValue(Key key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    protected String setValue(Key key, String value) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        key.setStoredValue(this.fLookupOrder[0], value, this.fManager);
        return oldValue;
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite curr = this.fExpandedComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }

    private void testIfOptionsComplete(Key[] allKeys) {
        int i = 0;
        while (i < allKeys.length) {
            if (allKeys[i].getStoredValue(this.fLookupOrder, false, this.fManager) == null) {
                JavaPlugin.logErrorMessage((String)("preference option missing: " + allKeys[i] + " (" + this.getClass().getName() + ')'));
            }
            ++i;
        }
    }

    protected void textChanged(Text textControl) {
        Key key = (Key)textControl.getData();
        String number = textControl.getText();
        String oldValue = this.setValue(key, number);
        this.validateSettings(key, oldValue, number);
    }

    protected void updateCheckBox(Button curr) {
        String currValue;
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(data.getSelection(currValue = this.getValue(data.getKey())) == 0);
    }

    protected void updateCombo(Combo curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = this.getValue(data.getKey());
        curr.select(data.getSelection(currValue));
    }

    protected void updateControls() {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox(this.fCheckBoxes.get(i));
            --i;
        }
        i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            this.updateCombo(this.fComboBoxes.get(i));
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            this.updateText(this.fTextBoxes.get(i));
            --i;
        }
    }

    protected abstract void updateModel(DialogField var1);

    protected void updateText(Text curr) {
        Key key = (Key)curr.getData();
        String currValue = this.getValue(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.fDisabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.fProject != null) {
            if (enable) {
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String val = this.fDisabledProjectSettings.get(curr);
                    curr.setStoredValue(this.fLookupOrder[0], val, this.fManager);
                    ++i;
                }
                this.fDisabledProjectSettings = null;
                this.updateControls();
            } else {
                this.fDisabledProjectSettings = new IdentityHashMap<Key, String>();
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String oldSetting = curr.getStoredValue(this.fLookupOrder, false, this.fManager);
                    this.fDisabledProjectSettings.put(curr, oldSetting);
                    curr.setStoredValue(this.fLookupOrder[0], null, this.fManager);
                    ++i;
                }
            }
        }
    }

    protected abstract void validateSettings(Key var1, String var2, String var3);

    protected static class ControlData {
        private Key fKey;
        private String[] fValues;

        public ControlData(Key key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public Key getKey() {
            return this.fKey;
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }
    }

    public static final class Key {
        private String fKey;
        private String fQualifier;

        public Key(String qualifier, String key) {
            this.fQualifier = qualifier;
            this.fKey = key;
        }

        public String getName() {
            return this.fKey;
        }

        private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = context.getNode(this.fQualifier);
            if (manager != null) {
                return manager.getWorkingCopy(node);
            }
            return node;
        }

        public String getQualifier() {
            return this.fQualifier;
        }

        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            return this.getNode(context, manager).get(this.fKey, null);
        }

        public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                String value = this.getStoredValue(lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            if (value != null) {
                this.getNode(context, manager).put(this.fKey, value);
            } else {
                this.getNode(context, manager).remove(this.fKey);
            }
        }

        public String toString() {
            return String.valueOf(this.fQualifier) + '/' + this.fKey;
        }
    }

    protected class UpdateAdapter
    implements IDialogFieldListener {
        protected UpdateAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            BaseConfigurationBlock.this.updateModel(field);
        }
    }
}

