/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.FeatureGenerator;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;

public class FeatureGeneratorTask
extends Task {
    private FeatureGenerator generator = new FeatureGenerator();

    public void execute() throws BuildException {
        try {
            this.run();
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void run() throws CoreException {
        this.generator.generate();
    }

    public void setBuildDirectory(String buildDirectory) {
        this.generator.setWorkingDirectory(buildDirectory);
    }

    public void setProductFile(String productFile) {
        this.generator.setProductFile(productFile);
    }

    public void setBaseLocation(String baseLocation) {
        BuildTimeSiteFactory.setInstalledBaseSite((String)baseLocation);
    }

    public void setPluginList(String pluginList) {
        if (pluginList != null && !pluginList.startsWith("${")) {
            this.generator.setPluginList(Utils.getArrayFromString((String)pluginList));
        }
    }

    public void setFeatureList(String featureList) {
        if (featureList != null && !featureList.startsWith("${")) {
            this.generator.setFeatureList(Utils.getArrayFromString((String)featureList));
        }
    }

    public void setFeatureId(String featureId) {
        this.generator.setFeatureId(featureId);
    }

    public void setPluginPath(String pluginPath) {
        this.generator.setPluginPath(Utils.getArrayFromString((String)pluginPath, (String)File.pathSeparator));
    }

    public void setVerify(boolean verify) {
        this.generator.setVerify(verify);
    }
}

