/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlAnimator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ILogger;

public class Policy {
    public static final boolean DEFAULT = false;
    public static final String JFACE = "org.eclipse.jface";
    private static ILogger log;
    private static Comparator viewerComparator;
    private static ControlAnimator animator;
    public static boolean DEBUG_DIALOG_NO_PARENT;
    public static boolean TRACE_ACTIONS;
    public static boolean TRACE_TOOLBAR;

    static {
        DEBUG_DIALOG_NO_PARENT = false;
        TRACE_ACTIONS = false;
        TRACE_TOOLBAR = false;
    }

    private static ILogger getDummyLog() {
        return new ILogger(){

            public void log(IStatus status) {
                System.err.println(status.getMessage());
            }
        };
    }

    public static void setLog(ILogger logger) {
        log = logger;
    }

    public static ILogger getLog() {
        if (log == null) {
            log = Policy.getDummyLog();
        }
        return log;
    }

    private static Comparator getDefaultComparator() {
        return new Comparator(){

            public int compare(Object s1, Object s2) {
                return ((String)s1).compareTo((String)s2);
            }
        };
    }

    public static Comparator getComparator() {
        if (viewerComparator == null) {
            viewerComparator = Policy.getDefaultComparator();
        }
        return viewerComparator;
    }

    public static void setComparator(Comparator comparator) {
        Assert.isTrue(viewerComparator == null);
        viewerComparator = comparator;
    }

    public static void setAnimator(ControlAnimator controlAnimator) {
        animator = controlAnimator;
    }

    public static ControlAnimator getAnimator() {
        if (animator == null) {
            animator = new ControlAnimator();
        }
        return animator;
    }
}

