/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver2;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class JRERuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver2 {
    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IVMInstall jre = null;
        jre = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? JREContainerInitializer.resolveVM(entry.getPath()) : JavaRuntime.computeVMInstall(configuration);
        if (jre == null) {
            return new IRuntimeClasspathEntry[0];
        }
        return this.resolveLibraryLocations(jre, entry.getClasspathProperty());
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        IVMInstall jre = null;
        jre = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? JREContainerInitializer.resolveVM(entry.getPath()) : JavaRuntime.getVMInstall(project);
        if (jre == null) {
            return new IRuntimeClasspathEntry[0];
        }
        return this.resolveLibraryLocations(jre, entry.getClasspathProperty());
    }

    protected IRuntimeClasspathEntry[] resolveLibraryLocations(IVMInstall vm, int kind) {
        LibraryInfo libraryInfo;
        File vmInstallLocation;
        if (kind == 2 && (vmInstallLocation = vm.getInstallLocation()) != null && (libraryInfo = LaunchingPlugin.getLibraryInfo(vmInstallLocation.getAbsolutePath())) != null) {
            String[] extensionDirsArray = libraryInfo.getExtensionDirs();
            HashSet<String> extensionDirsSet = new HashSet<String>();
            int i = 0;
            while (i < extensionDirsArray.length) {
                extensionDirsSet.add(extensionDirsArray[i]);
                ++i;
            }
            LibraryLocation[] libs = JavaRuntime.getLibraryLocations(vm);
            ArrayList<IRuntimeClasspathEntry> resolvedEntries = new ArrayList<IRuntimeClasspathEntry>(libs.length);
            int i2 = 0;
            while (i2 < libs.length) {
                LibraryLocation location = libs[i2];
                IPath libraryPath = location.getSystemLibraryPath();
                String dir = libraryPath.toFile().getParent();
                if (!extensionDirsSet.contains(dir)) {
                    IRuntimeClasspathEntry resolved = JavaRuntime.newArchiveRuntimeClasspathEntry(libraryPath);
                    resolved.setClasspathProperty(2);
                    IPath sourcePath = location.getSystemLibrarySourcePath();
                    if (sourcePath != null && !sourcePath.isEmpty()) {
                        resolved.setSourceAttachmentPath(sourcePath);
                        resolved.setSourceAttachmentRootPath(location.getPackageRootPath());
                    }
                    resolvedEntries.add(resolved);
                }
                ++i2;
            }
            return resolvedEntries.toArray(new IRuntimeClasspathEntry[resolvedEntries.size()]);
        }
        LibraryLocation[] libs = vm.getLibraryLocations();
        LibraryLocation[] defaultLibs = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
        if (libs == null) {
            libs = defaultLibs;
        } else if (!JRERuntimeClasspathEntryResolver.isSameArchives(libs, defaultLibs)) {
            kind = 2;
        }
        ArrayList<IRuntimeClasspathEntry> resolvedEntries = new ArrayList<IRuntimeClasspathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            IPath systemLibraryPath = libs[i].getSystemLibraryPath();
            if (systemLibraryPath.toFile().exists()) {
                IRuntimeClasspathEntry resolved = JavaRuntime.newArchiveRuntimeClasspathEntry(systemLibraryPath);
                IPath path = libs[i].getSystemLibrarySourcePath();
                if (path != null && !path.isEmpty()) {
                    resolved.setSourceAttachmentPath(path);
                    resolved.setSourceAttachmentRootPath(libs[i].getPackageRootPath());
                }
                resolved.setClasspathProperty(kind);
                resolvedEntries.add(resolved);
            }
            ++i;
        }
        return resolvedEntries.toArray(new IRuntimeClasspathEntry[resolvedEntries.size()]);
    }

    public static boolean isSameArchives(LibraryLocation[] libs, LibraryLocation[] defaultLibs) {
        if (libs.length != defaultLibs.length) {
            return false;
        }
        int i = 0;
        while (i < defaultLibs.length) {
            LibraryLocation def = defaultLibs[i];
            LibraryLocation lib = libs[i];
            if (!def.getSystemLibraryPath().equals((Object)lib.getSystemLibraryPath())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 4: {
                if (!entry.getPath().segment(0).equals("JRE_LIB")) break;
                return JavaRuntime.getDefaultVMInstall();
            }
            case 5: {
                if (!entry.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                return JREContainerInitializer.resolveVM(entry.getPath());
            }
        }
        return null;
    }

    public boolean isVMInstallReference(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 4: {
                if (!entry.getPath().segment(0).equals("JRE_LIB")) break;
                return true;
            }
            case 5: {
                if (!entry.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                return true;
            }
        }
        return false;
    }
}

