/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import java.util.Iterator;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextActionDelegate;
import org.eclipse.debug.internal.ui.actions.context.BooleanRequestMonitor;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDebugContextAction
extends Action
implements IDebugContextListener {
    private IStructuredSelection fActiveContext;
    private IWorkbenchWindow fWindow;
    private AbstractDebugContextActionDelegate fDelegate;

    public AbstractDebugContextAction() {
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, helpContextId);
        }
        this.setEnabled(false);
    }

    public void setDelegate(AbstractDebugContextActionDelegate delegate) {
        this.fDelegate = delegate;
    }

    protected abstract void doAction(Object var1);

    public AbstractDebugContextAction(String text) {
        super(text);
    }

    public AbstractDebugContextAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public AbstractDebugContextAction(String text, int style) {
        super(text, style);
    }

    public void contextActivated(ISelection context, IWorkbenchPart part) {
        this.fActiveContext = null;
        this.update(context);
    }

    public void contextChanged(ISelection context, IWorkbenchPart part) {
        this.contextActivated(context, part);
    }

    protected void update(ISelection context) {
        if (context instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)context;
            this.updateEnableStateForContext(ss);
            this.fActiveContext = (IStructuredSelection)context;
        } else {
            this.setEnabled(false);
            this.fActiveContext = StructuredSelection.EMPTY;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.fDelegate != null) {
            this.fDelegate.setEnabled(enabled);
        }
    }

    protected void updateEnableStateForContext(IStructuredSelection selection) {
        int size = selection.size();
        this.setEnabled(false);
        BooleanRequestMonitor monitor = new BooleanRequestMonitor((IAction)this, size);
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            this.isEnabledFor(element, monitor);
        }
    }

    protected abstract void isEnabledFor(Object var1, IBooleanRequestMonitor var2);

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IDebugContextManager manager = DebugContextManager.getDefault();
        manager.addDebugContextListener(this, window);
        ISelection activeContext = manager.getActiveContext(window);
        if (activeContext != null) {
            this.contextActivated(activeContext, null);
        }
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected IStructuredSelection getContext() {
        return this.fActiveContext;
    }

    public void run() {
        IStructuredSelection selection = this.getContext();
        if (selection != null && this.isEnabled()) {
            this.setEnabled(false);
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                this.doAction(element);
            }
        }
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void dispose() {
        IWorkbenchWindow window = this.getWindow();
        if (this.getWindow() != null) {
            DebugContextManager.getDefault().removeDebugContextListener(this, window);
        }
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected String getErrorDialogMessage() {
        return null;
    }

    protected String getStatusMessage() {
        return "";
    }

    public abstract String getHelpContextId();

    public abstract String getId();

    public abstract String getText();

    public abstract String getToolTipText();

    public abstract ImageDescriptor getDisabledImageDescriptor();

    public abstract ImageDescriptor getHoverImageDescriptor();

    public abstract ImageDescriptor getImageDescriptor();
}

