/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousSuspendResumeAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.jface.util.Assert;

public class SuspendResumeAdapter
implements IAsynchronousSuspendResumeAdapter {
    public void canResume(final Object element, final IBooleanRequestMonitor monitor) {
        Assert.isTrue((boolean)(element instanceof ISuspendResume), (String)"element must be an instance of ISuspendResume");
        Job job = new Job("canResume"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    ISuspendResume suspendResume = (ISuspendResume)element;
                    monitor.setResult(suspendResume.canResume());
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void canSuspend(final Object element, final IBooleanRequestMonitor monitor) {
        Assert.isTrue((boolean)(element instanceof ISuspendResume), (String)"element must be an instance of ISuspendResume");
        Job job = new Job("canSuspend"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    ISuspendResume suspendResume = (ISuspendResume)element;
                    monitor.setResult(suspendResume.canSuspend());
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void isSuspended(final Object element, final IBooleanRequestMonitor monitor) {
        Assert.isTrue((boolean)(element instanceof ISuspendResume), (String)"element must be an instance of ISuspendResume");
        Job job = new Job("isSuspended"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    ISuspendResume suspendResume = (ISuspendResume)element;
                    monitor.setResult(suspendResume.isSuspended());
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void resume(final Object element, final IAsynchronousRequestMonitor monitor) {
        Assert.isTrue((boolean)(element instanceof ISuspendResume), (String)"element must be an instance of ISuspendResume");
        Job job = new Job("resume"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    ISuspendResume suspendResume = (ISuspendResume)element;
                    try {
                        suspendResume.resume();
                    }
                    catch (DebugException e) {
                        monitor.setStatus(e.getStatus());
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void suspend(final Object element, final IAsynchronousRequestMonitor monitor) {
        Assert.isTrue((boolean)(element instanceof ISuspendResume), (String)"element must be an instance of ISuspendResume");
        Job job = new Job("suspend"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    ISuspendResume suspendResume = (ISuspendResume)element;
                    try {
                        suspendResume.suspend();
                    }
                    catch (DebugException e) {
                        monitor.setStatus(e.getStatus());
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

