/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.VariableValueEditorManager;
import org.eclipse.debug.internal.ui.elements.adapters.Messages;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractColumnPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class VariableColumnPresentation
extends AbstractColumnPresentation {
    public static final String DEFAULT_VARIABLE_COLUMN_PRESENTATION = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".VARIALBE_COLUMN_PRESENTATION";
    public static final String COLUMN_VARIABLE_NAME = String.valueOf(DEFAULT_VARIABLE_COLUMN_PRESENTATION) + ".COL_VAR_NAME";
    public static final String COLUMN_VARIABLE_TYPE = String.valueOf(DEFAULT_VARIABLE_COLUMN_PRESENTATION) + ".COL_VAR_TYPE";
    public static final String COLUMN_VARIABLE_VALUE = String.valueOf(DEFAULT_VARIABLE_COLUMN_PRESENTATION) + ".COL_VAR_VALUE";
    public static final String COLUMN_VALUE_TYPE = String.valueOf(DEFAULT_VARIABLE_COLUMN_PRESENTATION) + ".COL_VALUE_TYPE";
    private static final String[] ALL_COLUMNS = new String[]{COLUMN_VARIABLE_NAME, COLUMN_VARIABLE_TYPE, COLUMN_VARIABLE_VALUE, COLUMN_VALUE_TYPE};
    private static final String[] INITIAL_COLUMNS = new String[]{COLUMN_VARIABLE_NAME, COLUMN_VARIABLE_VALUE};

    public String[] getAvailableColumns() {
        return ALL_COLUMNS;
    }

    public String getHeader(String id) {
        if (COLUMN_VARIABLE_TYPE.equals(id)) {
            return Messages.VariableColumnPresentation_0;
        }
        if (COLUMN_VARIABLE_NAME.equals(id)) {
            return Messages.VariableColumnPresentation_1;
        }
        if (COLUMN_VARIABLE_VALUE.equals(id)) {
            return Messages.VariableColumnPresentation_2;
        }
        if (COLUMN_VALUE_TYPE.equals(id)) {
            return Messages.VariableColumnPresentation_3;
        }
        return null;
    }

    public CellEditor getCellEditor(String id, Object element, Composite parent) {
        return new TextCellEditor(parent);
    }

    public ICellModifier getCellModifier() {
        return new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (COLUMN_VARIABLE_VALUE.equals(property) && element instanceof IVariable) {
                    IVariable variable = (IVariable)element;
                    IVariableValueEditor editor = VariableValueEditorManager.getDefault().getVariableValueEditor(variable.getModelIdentifier());
                    Shell shell = null;
                    IWorkbenchPart part = VariableColumnPresentation.this.getPresentationContext().getPart();
                    if (part != null) {
                        shell = part.getSite().getShell();
                    }
                    if (editor != null && editor.saveVariable(variable, (String)value, shell)) {
                        return;
                    }
                    try {
                        variable.setValue((String)value);
                    }
                    catch (DebugException e) {
                        DebugUIPlugin.errorDialog(shell, Messages.VariableColumnPresentation_4, Messages.VariableColumnPresentation_5, e.getStatus());
                    }
                }
            }

            public Object getValue(Object element, String property) {
                if (COLUMN_VARIABLE_VALUE.equals(property) && element instanceof IVariable) {
                    IVariable variable = (IVariable)element;
                    try {
                        return variable.getValue().getValueString();
                    }
                    catch (DebugException e) {
                        DebugUIPlugin.log(e);
                    }
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                if (COLUMN_VARIABLE_VALUE.equals(property) && element instanceof IVariable) {
                    return ((IVariable)element).supportsValueModification();
                }
                return false;
            }
        };
    }

    public String getId() {
        return DEFAULT_VARIABLE_COLUMN_PRESENTATION;
    }

    public String[] getInitialColumns() {
        return INITIAL_COLUMNS;
    }

    public boolean isOptional() {
        return true;
    }
}

